/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.client.orion;

import com.evermind.client.orion.ConsoleApplicationInstallation;
import com.evermind.io.IOUtils;
import com.evermind.security.UserAlreadyExistsException;
import com.evermind.server.administration.ApplicationAdministrator;
import com.evermind.server.administration.ApplicationServerAdministrator;
import com.evermind.server.administration.DataSourceRuntimeInfo;
import com.evermind.server.administration.ExtensiveUserInfo;
import com.evermind.server.http.administration.HttpSiteAdministrator;
import com.evermind.server.rmi.RMIInitialContextFactory;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;

public class OrionConsoleAdmin {
    public static void _fn(ApplicationAdministrator applicationAdministrator, List list) throws RemoteException {
        Object object;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        while (!list.isEmpty()) {
            object = OrionConsoleAdmin._fp(list, "-copyTable subcommand");
            if (((String)object).equals("-fromTable")) {
                string = OrionConsoleAdmin._fp(list, "origin table name");
                continue;
            }
            if (((String)object).equals("-fromSource")) {
                string3 = OrionConsoleAdmin._fp(list, "origin source name");
                continue;
            }
            if (((String)object).equals("-toTable")) {
                string2 = OrionConsoleAdmin._fp(list, "target table name");
                continue;
            }
            if (!((String)object).equals("-toSource")) continue;
            string4 = OrionConsoleAdmin._fp(list, "target source name");
        }
        if (string == null) {
            OrionConsoleAdmin._fo("No -fromTable specified");
            return;
        }
        if (string3 == null) {
            OrionConsoleAdmin._fo("No -fromSource specified");
            return;
        }
        if (string2 == null) {
            string2 = string;
        }
        if (string4 == null) {
            string4 = string3;
        }
        if (string2 == string && string4 == string3) {
            OrionConsoleAdmin._fo("Destination table and datasource cannot be the same as the origin datasource and table");
            return;
        }
        object = new HashMap();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        object.put("<table-name>", string);
        hashMap.put("<table-name>", string2);
        object.put("<data-source>", string3);
        hashMap.put("<data-source>", string4);
        try {
            applicationAdministrator.copyTable((Map)object, hashMap);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Configuration error: " + instantiationException.getMessage());
            return;
        }
        catch (SQLException sQLException) {
            System.err.println("SQL error: " + sQLException.getMessage());
            return;
        }
        catch (NamingException namingException) {
            System.err.println("Naming error: " + namingException.getMessage());
            return;
        }
    }

    public static void _fo(String string) {
        if (string != null) {
            System.err.println(string);
            System.err.println();
        }
        System.out.println("Usage: java -jar admin.jar ormi://host.domain.com<:port> username password [command]\nCommands are:\n-shutdown [force|ordinary] [reason] - shuts the entire server down\n-restart [reason] - restarts the entire server\n-deploy [subswitches] - (re)deploys an application. Sub-switches are:\n   -file [filename] - Enterprise Archive to deploy\n   -deploymentName [name] - Name of the application deployment\n   -targetPath [path] - The path on the remote OS to place the archive at. If not specified the applications directory is used\n   -parent [name] - Specifying parent application of this application, the default is the global ('default') application\n   -deploymentDirectory [path] - Root of the deployment configurations, \"[NONE]\" to place them inside the .ear\n   -cluster - Signals that the deployment should be propagated to other live cluster nodes if part of a cluster\n-undeploy [deploymentName] [remove files] - Uninstalls the named (deploymentName) application, the argument 'remove files' can be 'true' of 'false', default is 'true'-bindWebApp [application deployment name] [web-app name] [web-site name] [context root] - binds a web app to the specified site + root\n-application [name] [command] - application specific command, subcommands includes:\n   -dataSourceInfo - gets info about the installed datasources\n   -restart - restarts the application, this will trigger auto-deployment if enabled and a file has been touched\n   -addUser [username] [password] - adds a user to the application\n   -installDataSource - Installs a new datasource, arguments are:\n      -jar [path] - path to a jar file containing the driver to add to the server's library\n      -url [url] - the JDBC database URL\n      -location [location] - the namespace location for the raw source, for instance jdbc/DefaultRawDS\n      -pooledLocation [location] - the namespace location for the pooled source, for instance jdbc/DefaultPooledDS\n      -xaLocation [location] - the namespace location for the XA source, for instance jdbc/xa/DefaultXADS\n      -cmtLocation [location] - the namespace location for the CMT source, for instance jdbc/DefaultDS - this is the source usually used by applications\n      -username [username] - the username to log in with\n      -password [password] - the password to log in with\n      -connectionDriver [drivername] - the JDBC database driver class, for instance 'com.mydb.Driver'");
    }

    public static String _fp(List list, String string) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Invalid usage: " + (string == null ? "Missing argument" : "Missing " + string));
        }
        return (String)list.remove(0);
    }

    public static void _fq(ApplicationServerAdministrator applicationServerAdministrator, List list) throws RemoteException {
        String string = OrionConsoleAdmin._fp(list, "deploymentName");
        String string2 = OrionConsoleAdmin._fp(list, "moduleName");
        String string3 = OrionConsoleAdmin._fp(list, "siteName");
        String string4 = OrionConsoleAdmin._fp(list, "root");
        HttpSiteAdministrator httpSiteAdministrator = applicationServerAdministrator.getHttpServerAdministrator().getSite(string3);
        if (httpSiteAdministrator == null) {
            System.err.println("Unknown site: '" + string3 + "'");
            System.err.println("Active sites are:");
            Iterator iterator = applicationServerAdministrator.getHttpServerAdministrator().getSiteNames().iterator();
            while (iterator.hasNext()) {
                String string5 = iterator.next().toString();
                if (string5.endsWith(".xml")) {
                    String string6 = string5.substring(string5.lastIndexOf(47) + 1, string5.lastIndexOf(46));
                    System.out.println(string6 + " (full name: " + string5 + ")");
                    continue;
                }
                System.out.println(string5);
            }
            return;
        }
        try {
            httpSiteAdministrator.bindWebApp(string4, string, string2);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Error binding web-app: " + instantiationException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("Communication error: " + iOException.getMessage());
        }
    }

    public static void _fr(ApplicationAdministrator applicationAdministrator) throws RemoteException {
        try {
            DataSourceRuntimeInfo[] dataSourceRuntimeInfoArray = applicationAdministrator.getDataSourceInfo();
            System.out.println("DataSource info: ");
            int n = 0;
            while (n < dataSourceRuntimeInfoArray.length) {
                System.out.println(dataSourceRuntimeInfoArray[n].getName() + " - cached: " + dataSourceRuntimeInfoArray[n].getCached() + " used: " + dataSourceRuntimeInfoArray[n].getUsed() + " total: " + (dataSourceRuntimeInfoArray[n].getCached() + dataSourceRuntimeInfoArray[n].getUsed()));
                ++n;
            }
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Error looking up datasource info: " + instantiationException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        block13: {
            try {
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
                try {
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("java.naming.provider.url", OrionConsoleAdmin._fp(arrayList, "URL"));
                    hashtable.put("java.naming.security.principal", OrionConsoleAdmin._fp(arrayList, "username"));
                    hashtable.put("java.naming.security.credentials", OrionConsoleAdmin._fp(arrayList, "password"));
                    hashtable.put("java.naming.factory.initial", "com.evermind.server.rmi.RMIInitialContextFactory");
                    Context context = new RMIInitialContextFactory().getInitialContext(hashtable);
                    ApplicationServerAdministrator applicationServerAdministrator = (ApplicationServerAdministrator)context.lookup("java:comp/ServerAdministrator");
                    String string = OrionConsoleAdmin._fp(arrayList, "command");
                    if (string.equals("-shutdown")) {
                        boolean bl = arrayList.isEmpty() ? false : "force".equals(OrionConsoleAdmin._fp(arrayList, "force"));
                        applicationServerAdministrator.shutdown(arrayList.isEmpty() ? null : OrionConsoleAdmin._fp(arrayList, "Shutdown description"), bl);
                        break block13;
                    }
                    if (string.equals("-restart")) {
                        applicationServerAdministrator.restart(arrayList.isEmpty() ? null : OrionConsoleAdmin._fp(arrayList, "Restart description"));
                        break block13;
                    }
                    if (string.equals("-application")) {
                        OrionConsoleAdmin._ft(applicationServerAdministrator, arrayList);
                        break block13;
                    }
                    if (string.equals("-deploy")) {
                        OrionConsoleAdmin._fs(applicationServerAdministrator, arrayList);
                        break block13;
                    }
                    if (string.equals("-undeploy")) {
                        OrionConsoleAdmin._fu(applicationServerAdministrator, arrayList);
                        break block13;
                    }
                    if (string.equals("-bindWebApp")) {
                        OrionConsoleAdmin._fq(applicationServerAdministrator, arrayList);
                        break block13;
                    }
                    OrionConsoleAdmin._fo("Unknown switch: " + string);
                }
                catch (SecurityException securityException) {
                    System.err.println("Security error: " + securityException.getMessage());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println("Illegal argument: " + illegalArgumentException.getMessage());
                }
                catch (Throwable throwable) {
                    System.err.println("Error: " + throwable);
                    if ("debug".equalsIgnoreCase(System.getProperty("mode"))) {
                        throwable.printStackTrace();
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                OrionConsoleAdmin._fo(illegalArgumentException.getMessage());
            }
        }
    }

    public static void _fs(ApplicationServerAdministrator applicationServerAdministrator, List list) throws RemoteException {
        String string = null;
        HashMap<String, String> hashMap = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        Object var7_7 = null;
        boolean bl2 = false;
        int n = 4;
        while (!list.isEmpty()) {
            String string4 = OrionConsoleAdmin._fp(list, "deployment subcommand");
            if (string4.equals("-file")) {
                string = OrionConsoleAdmin._fp(list, "deployment -file filename");
                continue;
            }
            if (string4.equals("-cluster")) {
                bl2 = true;
                continue;
            }
            if (string4.equals("-targetPath")) {
                string2 = OrionConsoleAdmin._fp(list, "-targetPath argument");
                continue;
            }
            if (string4.equals("-deploymentName")) {
                string3 = OrionConsoleAdmin._fp(list, "deployment name");
                continue;
            }
            if (string4.equals("-pedantic")) {
                bl = true;
                continue;
            }
            if (string4.equals("-parent")) {
                if (hashMap == null) {
                    hashMap = new HashMap<String, String>();
                }
                hashMap.put("parent", OrionConsoleAdmin._fp(list, "-parent argument"));
                continue;
            }
            if (string4.equals("-deploymentDirectory")) {
                if (hashMap == null) {
                    hashMap = new HashMap();
                }
                hashMap.put("deploymentDirectory", OrionConsoleAdmin._fp(list, "-deploymentDirectory"));
                continue;
            }
            if (string4.equals("-autoCreateTables")) {
                if (hashMap == null) {
                    hashMap = new HashMap();
                }
                hashMap.put("autoCreateTables", OrionConsoleAdmin._fp(list, "-autoCreateTables"));
                continue;
            }
            OrionConsoleAdmin._fo("Unknown -deploy switch: " + string4);
            return;
        }
        if (string == null) {
            System.err.println("No -file specified");
            return;
        }
        if (string3 == null) {
            System.err.println("No -deploymentName specified");
            return;
        }
        new ConsoleApplicationInstallation(applicationServerAdministrator, string3, string, bl, string2, null, hashMap, bl2).run();
    }

    public static void _ft(ApplicationServerAdministrator applicationServerAdministrator, List list) throws RemoteException {
        String string;
        ApplicationAdministrator applicationAdministrator;
        String string2 = OrionConsoleAdmin._fp(list, "application name (use default for the global application)");
        try {
            applicationAdministrator = applicationServerAdministrator.getApplication(string2, null);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Error loading application " + string2 + ": " + instantiationException.getMessage() + " (use 'default' as application name if using the default installation configuration)");
            return;
        }
        if (applicationAdministrator == null) {
            System.out.println("Application '" + string2 + "' not found (use 'default' as application name if using the default installation configuration)");
        }
        if ((string = OrionConsoleAdmin._fp(list, "-application subcommand")).equals("-dataSourceInfo")) {
            OrionConsoleAdmin._fr(applicationAdministrator);
        } else if (string.equals("-installDataSource")) {
            OrionConsoleAdmin._fv(applicationAdministrator, list);
        } else if (string.equals("-copyTable")) {
            OrionConsoleAdmin._fn(applicationAdministrator, list);
        } else if (string.equals("-restart")) {
            try {
                applicationAdministrator.restart();
            }
            catch (InstantiationException instantiationException) {
                System.err.println("Error restarting application: " + instantiationException.getMessage());
            }
        } else if (string.equals("-addUser")) {
            try {
                applicationAdministrator.getUserAdministrator().addUser(new ExtensiveUserInfo(OrionConsoleAdmin._fp(list, "-addUser username"), null, null, OrionConsoleAdmin._fp(list, "-addUser password"), new HashSet()));
            }
            catch (IOException iOException) {
                System.err.println("IO Error adding user: " + iOException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                System.err.println("Error adding user: " + instantiationException.getMessage());
            }
            catch (UserAlreadyExistsException userAlreadyExistsException) {
                System.err.println("User already exists");
                return;
            }
        } else {
            OrionConsoleAdmin._fo("Unknown -application command: " + string);
        }
    }

    public static void _fu(ApplicationServerAdministrator applicationServerAdministrator, List list) throws RemoteException {
        ApplicationAdministrator applicationAdministrator;
        String string = OrionConsoleAdmin._fp(list, "application name");
        try {
            applicationAdministrator = applicationServerAdministrator.getApplication(string, null);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Error loading application " + string + ": " + instantiationException.getMessage() + " (use 'default' as application name if using the default installation configuration)");
            return;
        }
        if (applicationAdministrator == null) {
            System.out.println("Application '" + string + "' not found");
        }
        applicationAdministrator.uninstall(list.isEmpty() ? true : list.remove(0).equals("true"));
    }

    public static void _fv(ApplicationAdministrator applicationAdministrator, List list) throws RemoteException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (!list.isEmpty()) {
            Object object;
            String string = OrionConsoleAdmin._fp(list, "-installDataSource command");
            if (string.equals("-location") || string.equals("-pooledLocation") || string.equals("-url") || string.equals("-xaLocation") || string.equals("-cmtLocation") || string.equals("-username") || string.equals("-password") || string.equals("-connectionDriver")) {
                if (list.isEmpty()) {
                    OrionConsoleAdmin._fo(string + " without provided value");
                    return;
                }
                object = string.substring(1);
                if (((String)object).equals("cmtLocation")) {
                    object = "ejbLocation";
                }
                hashMap.put((String)object, OrionConsoleAdmin._fp(list, "argument following " + string));
                continue;
            }
            if (string.equals("-jar")) {
                try {
                    object = new File(OrionConsoleAdmin._fp(list, "filename for -jar"));
                    byte[] byArray = IOUtils._fw((File)object);
                    hashMap.put("jar", byArray);
                    hashMap.put("jarName", ((File)object).getName());
                    continue;
                }
                catch (IOException iOException) {
                    System.err.println("Error reading jar file: " + iOException.getMessage());
                    return;
                }
            }
            OrionConsoleAdmin._fo("Unknown -installDataSource switch: " + string);
            return;
        }
        if (!hashMap.containsKey("url")) {
            OrionConsoleAdmin._fo("No URL specified");
            return;
        }
        if (!hashMap.containsKey("location")) {
            OrionConsoleAdmin._fo("No location specified");
            return;
        }
        try {
            applicationAdministrator.installDataSource(hashMap);
        }
        catch (IOException iOException) {
            System.err.println("IO Error: " + iOException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Error adding source: " + instantiationException.getMessage());
        }
    }
}

