/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

public class IOUtils {
    public static final byte[] _voc = "\r\n".getBytes();

    public static byte[] _fw(URL uRL) throws IOException {
        if (uRL.getProtocol().equals("file")) {
            return IOUtils._fw(new File(uRL.getFile()));
        }
        int n = uRL.openConnection().getContentLength();
        InputStream inputStream = uRL.openStream();
        if (n >= 0) {
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = inputStream.read(byArray, n2, n - n2);
                if (n3 < 0) {
                    throw new IOException();
                }
                n2 += n3;
            }
            return byArray;
        }
        return IOUtils.getContent(inputStream);
    }

    public static byte[] _fw(String string) throws IOException {
        if (string.indexOf(":/") >= 0) {
            return IOUtils._fw(new URL(string));
        }
        return IOUtils._fw(new File(string));
    }

    public static byte[] _fw(File file) throws IOException {
        byte[] byArray = new byte[(int)file.length()];
        if (byArray.length == 0 && file.isDirectory()) {
            throw new IOException("The file was a directory");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            ((InputStream)fileInputStream).read(byArray);
        }
        finally {
            Object var5_3 = null;
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    public static byte[] getContent(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        int n2 = 0;
        while ((n = inputStream.read(byArray, n2, byArray.length - n2)) >= 0) {
            if ((n2 += n) < byArray.length - 256) continue;
            byte[] byArray2 = new byte[byArray.length * 2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
        }
        if (byArray.length == n2) {
            return byArray;
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        return byArray3;
    }

    public static char[] _fw(Reader reader) throws IOException {
        int n;
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        char[] cArray = new char[10240];
        while ((n = reader.read(cArray)) >= 0) {
            charArrayWriter.write(cArray, 0, n);
        }
        return charArrayWriter.toCharArray();
    }

    public static void _ou(InputStream inputStream, byte[] byArray) throws IOException {
        IOUtils._ou(inputStream, byArray, 0, byArray.length);
    }

    public static void _ou(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            if ((n3 += inputStream.read(byArray, n3 + n, n2 - n3)) >= 0) continue;
            throw new IOException("Unexpected EOS");
        }
    }

    public static void _eeb(URL uRL, byte[] byArray) throws IOException {
        if (uRL.getProtocol().equals("file")) {
            IOUtils._eeb(new File(uRL.getFile().replace('/', File.separatorChar)).getAbsolutePath(), byArray);
        } else {
            URLConnection uRLConnection = uRL.openConnection();
            OutputStream outputStream = uRLConnection.getOutputStream();
            outputStream.write(byArray);
            outputStream.close();
        }
    }

    public static void _eeb(String string, byte[] byArray) throws IOException {
        if (string.indexOf(":/") >= 0) {
            URL uRL = new URL(string);
            OutputStream outputStream = uRL.openConnection().getOutputStream();
            outputStream.write(byArray);
            outputStream.close();
        } else {
            IOUtils._eeb(new File(string), byArray);
        }
    }

    public static void _eeb(File file, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ((OutputStream)fileOutputStream).write(byArray);
        ((OutputStream)fileOutputStream).close();
    }

    public static void _vrd(OutputStream outputStream, long l) throws IOException {
        IOUtils._ov(outputStream, (int)l);
        IOUtils._ov(outputStream, (int)(l >> 32));
    }

    public static long _vsd(InputStream inputStream) throws IOException {
        return IOUtils._ot(inputStream) + (IOUtils._ot(inputStream) << 32);
    }

    public static byte[] _hrd(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        objectOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void _vtd(OutputStream outputStream, boolean bl) throws IOException {
        outputStream.write(bl ? 1 : 0);
    }

    public static boolean _vud(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public static void _ov(OutputStream outputStream, int n) throws IOException {
        if (n >= 0 && n < 128) {
            outputStream.write(n);
        } else if (n >= 0 && n < 16384) {
            outputStream.write(n | 0x80);
            outputStream.write(n >>> 7);
        } else if (n >= 0 && n < 0x200000) {
            outputStream.write(n | 0x80);
            outputStream.write(n >>> 7 | 0x80);
            outputStream.write(n >>> 14);
        } else if (n >= 0 && n < 0x10000000) {
            outputStream.write(n | 0x80);
            outputStream.write(n >>> 7 | 0x80);
            outputStream.write(n >>> 14 | 0x80);
            outputStream.write(n >>> 21);
        } else {
            outputStream.write(n | 0x80);
            outputStream.write(n >>> 7 | 0x80);
            outputStream.write(n >>> 14 | 0x80);
            outputStream.write(n >>> 21 | 0x80);
            outputStream.write(n >>> 28);
        }
    }

    public static int _ot(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        if (n < 128) {
            return n;
        }
        int n2 = n & 0x7F;
        int n3 = inputStream.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        if (n3 < 128) {
            return (n3 << 7) + n2;
        }
        int n4 = inputStream.read();
        if (n4 < 0) {
            throw new EOFException();
        }
        if (n4 < 128) {
            return (n4 << 14) + ((n3 & 0x7F) << 7) + n2;
        }
        int n5 = inputStream.read();
        if (n5 < 0) {
            throw new EOFException();
        }
        if (n5 < 128) {
            return (n5 << 21) + ((n4 & 0x7F) << 14) + ((n3 & 0x7F) << 7) + n2;
        }
        int n6 = inputStream.read();
        if (n6 < 0) {
            throw new EOFException();
        }
        return (n6 << 28) + ((n5 & 0x7F) << 21) + ((n4 & 0x7F) << 14) + ((n3 & 0x7F) << 7) + n2;
    }

    public static long _ot(byte[] byArray, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        if (n >= byArray.length) {
            throw new EOFException();
        }
        if ((n5 = (char)byArray[n++] & 0xFF) < 128) {
            return ((long)n << 32) + (long)n5;
        }
        int n6 = n5 & 0x7F;
        if (n >= byArray.length) {
            throw new EOFException();
        }
        if ((n4 = (char)byArray[n++] & 0xFF) < 128) {
            return ((long)n << 32) + (long)(n4 << 7) + (long)n6;
        }
        if (n >= byArray.length) {
            throw new EOFException();
        }
        if ((n3 = (char)byArray[n++] & 0xFF) < 128) {
            return ((long)n << 32) + (long)(n3 << 14) + (long)((n4 & 0x7F) << 7) + (long)n6;
        }
        if (n >= byArray.length) {
            throw new EOFException();
        }
        if ((n2 = (char)byArray[n++] & 0xFF) < 128) {
            return ((long)n << 32) + (long)(n2 << 21) + (long)((n3 & 0x7F) << 14) + (long)((n4 & 0x7F) << 7) + (long)n6;
        }
        if (n >= byArray.length) {
            throw new EOFException();
        }
        int n7 = (char)byArray[n++] & 0xFF;
        return ((long)n << 32) + (long)(n7 << 28) + (long)((n2 & 0x7F) << 21) + (long)((n3 & 0x7F) << 14) + (long)((n4 & 0x7F) << 7) + (long)n6;
    }

    public static int _ov(byte[] byArray, int n, int n2) {
        if (n2 >= 0 && n2 < 128) {
            byArray[n++] = (byte)n2;
        } else if (n2 >= 0 && n2 < 16384) {
            byArray[n++] = (byte)(n2 | 0x80);
            byArray[n++] = (byte)(n2 >>> 7);
        } else if (n2 >= 0 && n2 < 0x200000) {
            byArray[n++] = (byte)(n2 | 0x80);
            byArray[n++] = (byte)(n2 >>> 7 | 0x80);
            byArray[n++] = (byte)(n2 >>> 14);
        } else if (n2 >= 0 && n2 < 0x10000000) {
            byArray[n++] = (byte)(n2 | 0x80);
            byArray[n++] = (byte)(n2 >>> 7 | 0x80);
            byArray[n++] = (byte)(n2 >>> 14 | 0x80);
            byArray[n++] = (byte)(n2 >>> 21);
        } else {
            byArray[n++] = (byte)(n2 | 0x80);
            byArray[n++] = (byte)(n2 >>> 7 | 0x80);
            byArray[n++] = (byte)(n2 >>> 14 | 0x80);
            byArray[n++] = (byte)(n2 >>> 21 | 0x80);
            byArray[n++] = (byte)(n2 >>> 28);
        }
        return n;
    }

    public static void _bxb(OutputStream outputStream, short s) throws IOException {
        outputStream.write(s >>> 8);
        outputStream.write((byte)s);
    }

    public static int _vvd(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        int n2 = inputStream.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (short)(n2 + (n << 8));
    }

    public static String _ijc(InputStream inputStream) throws IOException {
        return IOUtils._ijc(inputStream, false);
    }

    public static String _ijc(InputStream inputStream, boolean bl) throws IOException {
        int n = IOUtils._ot(inputStream);
        if (n < 0) {
            if (!bl) {
                throw new IOException("Read null string");
            }
            return null;
        }
        char[] cArray = new char[n];
        IOUtils._vzd(inputStream, cArray, 0, n);
        return new String(cArray);
    }

    public static void _ikc(OutputStream outputStream, String string) throws IOException {
        IOUtils._ikc(outputStream, string, false);
    }

    public static void _ikc(OutputStream outputStream, String string, boolean bl) throws IOException {
        if (string == null) {
            if (!bl) {
                throw new NullPointerException("string was null");
            }
            IOUtils._ov(outputStream, -1);
        } else {
            IOUtils._ov(outputStream, string.length());
            IOUtils._vyd(outputStream, string);
        }
    }

    public static void _bfb(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtils._bfb(inputStream, outputStream, new byte[10240]);
    }

    public static void _bfb(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static void _vwd(OutputStream outputStream, String string) throws IOException {
        IOUtils._bxb(outputStream, (short)string.length());
        IOUtils._vyd(outputStream, string);
    }

    public static String _vxd(InputStream inputStream) throws IOException {
        int n = IOUtils._vvd(inputStream);
        if (n < 0) {
            throw new IOException("Invalid UTF length");
        }
        char[] cArray = new char[n];
        IOUtils._vzd(inputStream, cArray, 0, cArray.length);
        return new String(cArray);
    }

    public static void _vyd(OutputStream outputStream, String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c >= '\u0001' && c <= '\u007f') {
                outputStream.write((byte)c);
            } else if (c > '\u07ff') {
                outputStream.write((byte)(0xE0 | c >> 12 & 0xF));
                outputStream.write((byte)(0x80 | c >> 6 & 0x3F));
                outputStream.write((byte)(0x80 | c & 0x3F));
            } else {
                outputStream.write((byte)(0xC0 | c >> 6 & 0x1F));
                outputStream.write((byte)(0x80 | c & 0x3F));
            }
            ++n2;
        }
    }

    public static void _vzd(InputStream inputStream, char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = inputStream.read() & 0xFF;
            if (n4 < 128) {
                cArray[n + n3] = (char)n4;
            } else {
                switch (n4 >> 4) {
                    case 12: 
                    case 13: {
                        byte by = (byte)inputStream.read();
                        if ((by & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        cArray[n + n3] = (char)((n4 & 0x1F) << 6 | by & 0x3F);
                        break;
                    }
                    case 14: {
                        byte by = (byte)inputStream.read();
                        byte by2 = (byte)inputStream.read();
                        if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        cArray[n + n3] = (char)((n4 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
                        break;
                    }
                    default: {
                        throw new UTFDataFormatException();
                    }
                }
            }
            ++n3;
        }
    }

    public static void _edb(File file) {
        if (!file.getParentFile().exists()) {
            ArrayList<File> arrayList = new ArrayList<File>();
            File file2 = file.getParentFile();
            while (file2 != null && !file2.exists()) {
                arrayList.add(file2);
                file2 = file2.getParentFile();
            }
            int n = arrayList.size() - 1;
            while (n >= 0) {
                ((File)arrayList.get(n)).mkdir();
                --n;
            }
        }
    }
}

