/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.naming.file;

import com.evermind._vt;
import com.evermind.naming.file.ContentFileContext;
import com.evermind.naming.file.FileContext;
import com.evermind.util.ObjectUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class FileNamingEnumeration
implements NamingEnumeration {
    public File[] _krd;
    public FileContext _gp;
    public int _hp;
    public NameClassPair _pw;
    public NamingException _px;

    public void close() {
    }

    public Object nextElement() {
        if (this._pw == null) {
            throw new NoSuchElementException(String.valueOf(this._hp - 1));
        }
        NameClassPair nameClassPair = this._pw;
        this._pw = this.getNameClassPair();
        return nameClassPair;
    }

    public FileNamingEnumeration(File[] fileArray, FileContext fileContext) {
        this._krd = fileArray;
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n] == null) {
                throw new NullPointerException("File array entry was null");
            }
            ++n;
        }
        this._gp = fileContext;
        this._pw = this.getNameClassPair();
    }

    public NameClassPair getNameClassPair() {
        if (this._krd == null || this._hp >= this._krd.length) {
            return null;
        }
        try {
            File file = this._krd[this._hp++];
            if (file.isDirectory()) {
                return new NameClassPair(file.getName(), "com.evermind.naming.file.FileContext");
            }
            if (this._gp instanceof ContentFileContext) {
                return new NameClassPair(file.getName(), "[B");
            }
            if (this._gp instanceof _vt) {
                FileInputStream fileInputStream = new FileInputStream(file);
                String string = ObjectUtils._pq(fileInputStream, ((_vt)this._gp)._gfc()).getClass().getName();
                fileInputStream.close();
                return new NameClassPair(file.getName(), string);
            }
            return new NameClassPair(file.getName(), "java.io.File");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this._px = new NamingException("ClassNotFoundException: " + classNotFoundException.getMessage());
            return null;
        }
        catch (IOException iOException) {
            this._px = new NamingException("IO Error: " + iOException.getMessage());
            return null;
        }
    }

    public boolean hasMoreElements() {
        return this._pw != null;
    }

    public boolean hasMore() {
        return this.hasMoreElements();
    }

    public Object next() throws NamingException {
        if (this._pw == null && this._px != null) {
            throw this._px;
        }
        NameClassPair nameClassPair = this._pw;
        this._pw = this.getNameClassPair();
        return nameClassPair;
    }
}

