/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind._ks;
import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ejb.DataSourceConnectionContainer;
import com.evermind.server.http.HttpDateFormat;
import com.evermind.sql.DriverManagerDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class DataSourceConnection
implements ConnectionEventListener {
    public PooledConnection _htb;
    public XAResource _hub;
    public Connection _eab;
    public boolean _ka;
    public long _hvb;
    public boolean _edb;
    public String _hwb;
    public PreparedStatement _hxb;
    public DataSourceConnectionContainer _fb;
    public Map _hyb;
    public ApplicationServerTransaction _hzb;
    public Throwable _iab;

    public void close(boolean bl) {
        if (this._ka) {
            return;
        }
        this._ka = true;
        if (this._htb != null) {
            this._htb.removeConnectionEventListener(this);
        }
        this._edb = false;
        this._wyb();
        Object var4_2 = null;
        try {
            if (this._eab != null) {
                this._eab.close();
            }
        }
        catch (Throwable throwable) {
            this._fb._gv._db("Error closing DataSource connection", throwable);
        }
        this._fb = null;
        this._eab = null;
    }

    public void release() {
        if (!this._edb || this._ka) {
            if (!this._edb) {
                throw new InternalError("Was not in used mode");
            }
            return;
        }
        this._edb = false;
        this._fb.releaseConnection(this);
    }

    public PreparedStatement getCustomStatement(String string) throws SQLException {
        PreparedStatement preparedStatement;
        if (this._ka) {
            throw new InternalError("Attempt to use closed connection");
        }
        if (this._hwb == string) {
            return this._hxb;
        }
        if (this._hyb == null) {
            this._hyb = new HashMap();
        }
        if ((preparedStatement = (PreparedStatement)this._hyb.get(string)) == null) {
            preparedStatement = this._eab.prepareStatement(string);
            this._hyb.put(string, preparedStatement);
        }
        this._hwb = string;
        this._hxb = preparedStatement;
        return preparedStatement;
    }

    public String toString() {
        return "[DataSourceConnection " + this._eab + "]";
    }

    public DataSourceConnection(DataSourceConnectionContainer dataSourceConnectionContainer, ApplicationServerTransaction applicationServerTransaction) throws SQLException {
        try {
            this._fb = dataSourceConnectionContainer;
            this._hzb = applicationServerTransaction;
            if (applicationServerTransaction == null && dataSourceConnectionContainer._af.nonTXSource != null) {
                this._htb = dataSourceConnectionContainer._af.nonTXSource._xbb()._xcb();
                this._eab = this._htb.getConnection();
                this._htb.addConnectionEventListener(this);
            } else {
                this._htb = dataSourceConnectionContainer._af._xbb()._xcb();
                if (applicationServerTransaction != null) {
                    this._hub = ((XAConnection)this._htb).getXAResource();
                }
                this._htb.addConnectionEventListener(this);
                this._eab = DriverManagerDataSource.DEBUG ? new _ks(this._htb.getConnection(), true) : this._htb.getConnection();
            }
            if (this._eab == null) {
                throw new InternalError("Received null connection from " + this._htb);
            }
            if (dataSourceConnectionContainer._nub() != -7) {
                this._eab.setTransactionIsolation(dataSourceConnectionContainer._nub());
            }
            this._edb = true;
        }
        catch (SQLException sQLException) {
            block12: {
                try {
                    this.close(true);
                }
                catch (Throwable throwable) {
                    if (dataSourceConnectionContainer._gv == null) break block12;
                    dataSourceConnectionContainer._gv._db("Error closing connection after SQLException", throwable);
                }
            }
            throw sQLException;
        }
        catch (Error error) {
            try {
                this.close(true);
            }
            catch (Throwable throwable) {
                this._fb._gv._db("Error closing connection after " + error.getClass(), throwable);
            }
            throw error;
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        if (DriverManagerDataSource.DEBUG) {
            System.out.println("*** DATASOURCECONNECTION ERROR SIGNALLED: " + connectionEvent.getSource() + " ***");
        }
        ((PooledConnection)connectionEvent.getSource()).removeConnectionEventListener(this);
        this.close(false);
    }

    public void _wyb() {
        this._hwb = null;
        this._hxb = null;
        try {
            try {
                if (this._hyb != null) {
                    Iterator iterator = this._hyb.values().iterator();
                    while (iterator.hasNext()) {
                        ((PreparedStatement)iterator.next()).close();
                    }
                }
            }
            catch (SQLException sQLException) {
                this._fb._gv._db("Error closing DataSource connection", sQLException);
            }
            Object var3_3 = null;
            if (this._hyb != null) {
                this._hyb.clear();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (this._hyb != null) {
                this._hyb.clear();
            }
            throw throwable;
        }
    }

    public void rollback() throws SQLException {
        if (this._eab != null) {
            this._eab.rollback();
        }
    }

    public Connection getConnection() {
        return this._eab;
    }

    protected void finalize() {
        if (!this._ka) {
            System.err.println("DataSourceConnection was not closed!");
            if (DataSourceConnectionContainer._hd) {
                System.err.println("Debug output enabled...");
                if (this._iab != null) {
                    this._iab.printStackTrace();
                }
            }
            this.close(true);
        }
    }

    public void commit() throws SQLException {
        if (this._eab != null) {
            this._eab.commit();
        }
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        if (DriverManagerDataSource.DEBUG) {
            System.out.println("*** DATASOURCECONNECTION CLOSE SIGNALLED: " + connectionEvent.getSource() + " ***");
        }
        this.close(false);
    }

    public boolean _wzb() throws SQLException {
        if (this._eab == null) {
            return true;
        }
        long l = HttpDateFormat._xdb();
        if (this._hvb < l) {
            if (this._eab.isClosed()) {
                this._eab = null;
                this.close(true);
                return true;
            }
            this._hvb = l + this._fb._ibb;
        }
        return false;
    }

    public XAResource _xab() {
        return this._hub;
    }
}

