/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind._dob;
import com.evermind.server.ejb.ChangedValue;
import com.evermind.server.ejb.DataSourceConnection;
import com.evermind.server.ejb.EvermindEntityContext;
import com.evermind.server.rmi.Replaceable;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class ORCollection
extends AbstractCollection
implements Replaceable {
    public EvermindEntityContext context;
    public Object primaryKey;
    public Object[] objects;
    public Object[] added;
    public int deleted;
    public boolean used;

    public boolean remove(Object object, boolean bl) {
        if (this.objects == null) {
            this.objects = this.getObjects();
        }
        if (bl) {
            int n = 0;
            while (n < this.objects.length) {
                Object object2 = this.objects[n];
                if (object2 instanceof ChangedValue) {
                    ChangedValue changedValue = (ChangedValue)object2;
                    if (changedValue.newValue != null && (object == changedValue.newValue || object.equals(changedValue.newValue))) {
                        this.notifyRemovedObject(changedValue.newValue);
                        changedValue.newValue = null;
                        ++this.deleted;
                        this.used = true;
                        return true;
                    }
                } else if (object == object2 || object.equals(object2)) {
                    this.notifyRemovedObject(object2);
                    this.objects[n] = new ChangedValue(object2, null);
                    ++this.deleted;
                    this.used = true;
                    return true;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.objects.length) {
                Object[] objectArray;
                Object object3 = this.objects[n];
                if (object3 instanceof ChangedValue) {
                    objectArray = (Object[])object3;
                    if (objectArray.newValue != null && (object3 == objectArray.newValue || object3.equals(objectArray.newValue))) {
                        Object[] objectArray2 = new Object[this.objects.length - 1];
                        System.arraycopy(this.objects, 0, objectArray2, 0, n);
                        System.arraycopy(this.objects, n + 1, objectArray2, n, this.objects.length - (n + 1));
                        this.objects = objectArray2;
                        return true;
                    }
                } else if (object == object3 || object.equals(object3)) {
                    objectArray = new Object[this.objects.length - 1];
                    System.arraycopy(this.objects, 0, objectArray, 0, n);
                    System.arraycopy(this.objects, n + 1, objectArray, n, this.objects.length - (n + 1));
                    this.objects = objectArray;
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public abstract boolean isImmutable();

    public EvermindEntityContext __getContext() {
        return this.context;
    }

    public void notifyRemovedObject(Object object) {
    }

    public void __setDirty(Object object) {
        this.used = true;
    }

    public boolean isUsed() {
        return this.used;
    }

    public boolean add(Object object) {
        this.notifyAddedObject(object);
        return this.add(object, true);
    }

    public boolean add(Object object, boolean bl) {
        if (object == null) {
            throw new IllegalArgumentException("Illegal adding of null to a collection cmr-field, see the EJB specification 10.3.8");
        }
        if (!bl && this.objects == null) {
            this.objects = this.getObjects();
        }
        if (bl) {
            this.used = true;
        }
        if (this.objects != null) {
            Object[] objectArray = this.objects;
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray.length] = bl ? new ChangedValue(null, object) : object;
            this.objects = objectArray2;
            return true;
        }
        if (this.added == null) {
            Object[] objectArray = new Object[]{bl ? new ChangedValue(null, object) : object};
            this.added = objectArray;
        } else {
            Object[] objectArray = this.added;
            Object[] objectArray3 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
            objectArray3[objectArray.length] = bl ? new ChangedValue(null, object) : object;
            this.added = objectArray3;
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        if (collection instanceof List) {
            List list = (List)collection;
            int n = 0;
            while (n < list.size()) {
                bl |= this.add(list.get(n));
                ++n;
            }
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                bl |= this.add(iterator.next());
            }
        }
        return bl;
    }

    public int size() {
        if (this.objects == null) {
            this.objects = this.getObjects();
        }
        return this.objects.length - this.deleted;
    }

    public abstract void persist(DataSourceConnection var1) throws SQLException;

    public Object getReplacement() {
        return new ArrayList(this);
    }

    protected void clearRemoved() {
        int n = this.objects.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.objects[n2] instanceof ChangedValue) {
                this.objects[n2] = this.objects[n-- - 1];
                --n2;
            }
            ++n2;
        }
        if (n != this.objects.length) {
            Object[] objectArray = new Object[n];
            System.arraycopy(this.objects, 0, objectArray, 0, n);
            this.objects = objectArray;
        }
        this.deleted = 0;
    }

    public Iterator iterator() {
        if (this.objects == null) {
            this.objects = this.getObjects();
        }
        if (!this.isImmutable()) {
            this.used = true;
        }
        return new _dob(this);
    }

    public void initializeObject(Object object) {
    }

    public void notifyAddedObject(Object object) {
        this.initializeObject(object);
    }

    public void clear() {
        if (this.objects == null) {
            this.objects = this.getObjects();
        }
        int n = 0;
        while (n < this.objects.length) {
            if (this.objects[n] instanceof ChangedValue) {
                ChangedValue changedValue = (ChangedValue)this.objects[n];
                if (changedValue.newValue != null) {
                    this.notifyRemovedObject(changedValue.newValue);
                    changedValue.newValue = null;
                    ++this.deleted;
                }
            } else {
                this.notifyRemovedObject(this.objects[n]);
                this.objects[n] = new ChangedValue(this.objects[n], null);
                ++this.deleted;
            }
            ++n;
        }
        this.used = true;
    }

    public abstract Object[] getObjects();

    public void __clearDirty() {
    }

    public void remove(int n) {
        this.used = true;
        if (this.objects[n] instanceof ChangedValue) {
            if (((ChangedValue)this.objects[n]).newValue != null) {
                this.notifyRemovedObject(((ChangedValue)this.objects[n]).newValue);
                ++this.deleted;
                ((ChangedValue)this.objects[n]).newValue = null;
            }
        } else {
            this.notifyRemovedObject(this.objects[n]);
            this.objects[n] = new ChangedValue(this.objects[n], null);
            ++this.deleted;
        }
    }

    public boolean remove(Object object) {
        return this.remove(object, true);
    }
}

