/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.loadbalancer;

import com.evermind._bv;
import com.evermind._cd;
import com.evermind._ce;
import com.evermind._cf;
import com.evermind._cg;
import com.evermind._ch;
import com.evermind._ci;
import com.evermind._ck;
import com.evermind._dvb;
import com.evermind._dwb;
import com.evermind._tn;
import com.evermind.util.ByteString;
import com.evermind.util.ThreadPool;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import javax.jms.JMSException;

public class LoadBalancer
implements Runnable {
    public boolean _heb;
    public _ch _yc;
    public ServerSocket _kl;
    public ThreadPool _iq;
    public _ci _hfb;
    public _ck _hgb;
    public _bv _hhb;
    public boolean _hib = true;
    public _ce _dd = new _ce(this, null);
    public int _hjb;
    public _cf[] _hkb = new _cf[16];
    public int _hlb;
    public _cg[] _hmb = new _cg[16];

    public boolean _vtb() {
        return this._hib;
    }

    public static void _fo(String string) {
        System.err.println(string);
        System.out.println("Usage:");
        System.out.println("-config - path to the load-balancer.xml config file, the default is config/load-balancer.xml");
        System.out.println("-host - host/address to listen to for HTTP connections");
        System.out.println("-port - port to listen to for HTTP connections");
        System.out.println("-dontUseSessionID - specifies the balancer not to scan for Servlet session IDs as a means of identifying clients (useful when for instance balancing SSL sites)");
        System.out.println("-dontUseIP - specifies the balancer not to route connections based on IP if no session exists/is scanned for");
        System.out.println("-dontUseKeepAlives - specifies the balancer not to maintain keep-alives. This is useful if number of open sockets/used threads is a problem on the balancer but it will increase network traffic and CPU usage (and slow down client requests).");
        System.out.println("-minimumIsland - the minimum island to add to alive servers list, useful when using several balancer instances");
        System.out.println("-maximumIsland - the maximum island to add to alive servers list, useful when using several balancer instances");
        System.out.println("-selectiontype - how to select servers, the default is random, options are: 'random', 'first'");
    }

    public synchronized _cg _vub() {
        if (this._hlb > 0) {
            return this._hmb[this._hlb += -1];
        }
        return new _cg(this);
    }

    public Socket _vvb(ByteString[] byteStringArray, InetAddress inetAddress, ByteString byteString, Object object) throws InterruptedException {
        return this._dd._vvb(inetAddress, byteString, object);
    }

    public LoadBalancer(_ch _ch2, _ci _ci2, ThreadPool threadPool, _bv _bv2, boolean bl) throws InstantiationException {
        this._yc = _ch2;
        this._heb = bl;
        this._hfb = _ci2;
        this._iq = threadPool;
        this._dd._hnb = _ch2._vzb();
        this._dd._hob = _ch2._wab();
        this._hib = _ch2._vtb();
        this._hhb = _bv2;
        _bv2._py(new _dvb(this));
        if (_ch2._wbb().equals("first")) {
            this._dd._wcb(new _tn());
        } else {
            this._dd._wcb(new _dwb());
        }
        List list = _ch2._wdb();
        int n = 0;
        while (n < list.size()) {
            this._dd._web((_cd)list.get(n), false);
            ++n;
        }
        this._dd._wbb()._dj(this);
        this._hgb = new _ck("islands", this);
        _ci2._wfb("islands", this._hgb);
        try {
            this._kl = new ServerSocket(_ch2._ga(), 30, _ch2._fx());
        }
        catch (IOException iOException) {
            throw new InstantiationException("Error listening for HTTP/HTTPS connections at " + _ch2._fx() + ":" + _ch2._ga() + ": " + iOException.getMessage());
        }
    }

    public synchronized void _vwb(_cf _cf2) {
        if (this._hjb >= this._hkb.length) {
            _cf[] _cfArray = new _cf[this._hkb.length * 2];
            System.arraycopy(this._hkb, 0, _cfArray, 0, this._hkb.length);
            this._hkb = _cfArray;
        }
        this._hkb[this._hjb++] = _cf2;
    }

    public synchronized void _vwb(_cg _cg2) {
        if (this._hlb >= this._hmb.length) {
            _cg[] _cgArray = new _cg[this._hmb.length * 2];
            System.arraycopy(this._hmb, 0, _cgArray, 0, this._hmb.length);
            this._hmb = _cgArray;
        }
        this._hmb[this._hlb++] = _cg2;
    }

    public static void main(String[] stringArray) throws UnknownHostException, JMSException, IOException {
        ThreadPool threadPool = new ThreadPool(Thread.currentThread().getThreadGroup(), false);
        _ci _ci2 = new _ci(null, InetAddress.getByName("230.0.0.2"), 27512, 0L);
        _bv _bv2 = new _bv(threadPool);
        try {
            Object object;
            int n = 0;
            String string = "config/load-balancer.xml";
            if (stringArray.length >= 2 && stringArray[0].equalsIgnoreCase("-config")) {
                string = stringArray[1];
                n = 2;
            }
            _ch _ch2 = new _ch();
            if (new File(string).exists()) {
                _ch2._dj(new File(string).toURL());
            }
            boolean bl = false;
            while (n < stringArray.length) {
                if (((String)(object = stringArray[n++])).equals("-host")) {
                    if (n == stringArray.length) {
                        LoadBalancer._fo("Expected hostname");
                        _ci2._pd();
                        System.exit(1);
                    }
                    _ch2._wgb(stringArray[n++]);
                    continue;
                }
                if (((String)object).equalsIgnoreCase("-dontUseSessionID")) {
                    _ch2._whb(false);
                    continue;
                }
                if (((String)object).equalsIgnoreCase("-dontUseKeepAlives")) {
                    _ch2._wib(false);
                    continue;
                }
                if (((String)object).equalsIgnoreCase("-?")) {
                    LoadBalancer._fo("");
                    _ci2._pd();
                    System.exit(1);
                    continue;
                }
                if (((String)object).equalsIgnoreCase("-dontUseIP")) {
                    _ch2._wjb(false);
                    continue;
                }
                if (((String)object).equalsIgnoreCase("-debug")) {
                    bl = true;
                    continue;
                }
                if (((String)object).equals("-config")) {
                    LoadBalancer._fo("-config switch must appear first in the list of switches");
                    _ci2._pd();
                    System.exit(1);
                    continue;
                }
                if (((String)object).equals("-port")) {
                    if (n == stringArray.length) {
                        LoadBalancer._fo("Expected port number");
                        _ci2._pd();
                        System.exit(1);
                    }
                    _ch2._wkb(Integer.parseInt(stringArray[n++]));
                    continue;
                }
                if (((String)object).equalsIgnoreCase("-minimumIsland")) {
                    if (n == stringArray.length) {
                        LoadBalancer._fo("Expected island ID");
                        _ci2._pd();
                        System.exit(1);
                    }
                    _ch2._wlb(Integer.parseInt(stringArray[n++]));
                    continue;
                }
                if (((String)object).equalsIgnoreCase("-maximumIsland")) {
                    if (n == stringArray.length) {
                        LoadBalancer._fo("Expected island ID");
                        _ci2._pd();
                        System.exit(1);
                    }
                    _ch2._wmb(Integer.parseInt(stringArray[n++]));
                    continue;
                }
                if (((String)object).equalsIgnoreCase("-selectiontype")) {
                    if (n == stringArray.length) {
                        LoadBalancer._fo("Expected selection type");
                        _ci2._pd();
                        System.exit(1);
                    }
                    _ch2._wnb(stringArray[n++]);
                    continue;
                }
                LoadBalancer._fo("Unexpected switch: " + (String)object);
                _bv2._pv();
                threadPool._pd();
                _ci2._pd();
                System.exit(1);
            }
            threadPool.launch(_ci2);
            _bv2._qa();
            object = new LoadBalancer(_ch2, _ci2, threadPool, _bv2, bl);
            ((LoadBalancer)object)._qa();
            System.out.println("Balancer initialized...");
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Error starting balancer: " + instantiationException.getMessage());
            _ci2._pd();
            threadPool._pd();
        }
    }

    public void _vxb() {
        this._dd._vxb();
    }

    public void _qa() {
        this._iq.launch(this);
    }

    public synchronized void _gj(String[] stringArray, InetAddress inetAddress, int n, int n2) {
        this._dd._gj(inetAddress, n, n2);
    }

    public synchronized _cf _vyb() {
        if (this._hjb > 0) {
            return this._hkb[this._hjb += -1];
        }
        return new _cf(this);
    }

    public ThreadPool _txb() {
        return this._iq;
    }

    public void run() {
        while (true) {
            try {
                Object object;
                Socket socket = this._kl.accept();
                if (this._dd._hnb) {
                    object = this._vyb();
                    ((_cf)object)._dj(socket);
                    continue;
                }
                object = this._vub();
                ((_cg)object)._dj(socket);
            }
            catch (IOException iOException) {
            }
        }
    }

    public synchronized void _gi(String[] stringArray, InetAddress inetAddress, int n, int n2, long l) {
        if (n2 < this._yc._wob() || n2 > this._yc._wpb()) {
            return;
        }
        this._dd._gi(inetAddress, n, n2, l);
    }
}

