package com.evermind.taglib.util;

import java.util.*;
import java.text.*;
import javax.ejb.*;
import javax.naming.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

/**
 * Displays a number in a special way.
 */
public class DisplayNumberTag extends TagSupport
{
	private double number;
	private String format;
	private Locale locale;
	
	public void setLocale(Locale locale)
	{
		this.locale = locale;
	}
	
	public void setNumber(double number)
	{
		this.number = number;
	}
	
	public void setFormat(String format)
	{
		this.format = format;
	}

	public int doStartTag() throws JspTagException
	{
		if(this.locale == null)
		{
			this.locale = this.pageContext.getRequest().getLocale();
		
			if(this.locale == null)
				this.locale = Locale.getDefault();
		}

		NumberFormat format = this.format == null ? NumberFormat.getInstance(locale) : new DecimalFormat(this.format);
		
		try
		{
			pageContext.getOut().print(format.format(number));
		}
		catch(java.io.IOException e)
		{
			throw new JspTagException("IO Error: " + e.getMessage());
		}
		
		return Tag.SKIP_BODY;
	}
}
