import java.util.*;
import javax.ejb.*;
import java.rmi.RemoteException;

/**
 * An implementation of the Cart/CartHome interface. Note that the bean
 * doesnt actually implement the interfaces since the container (middleware)
 * wraps all access.
 * 
 * @author Magnus Stenman/The Orion team
 */
public class CartEJB implements SessionBean
{
	protected String user;
	protected Collection items = new ArrayList();

	/**
	 * Creates a Cart with the default "Anonymous" user.
	 */
	public void ejbCreate()
	{
		this.user = "Anonymous";
	}

	/**
	 * Creates a new Cart with user as owner.
	 * 
	 * @param user Owner of the Cart.
	 */
	public void ejbCreate(String user)
	{
		this.user = user;
	}

	public void add(String item)
	{
		// No need to synchronize, EJB access is always serialized
		items.add(item);
	}
	
	public void remove(String item) throws NotInCartException
	{
		// No need to synchronize, EJB access is always serialized
		if(!items.remove(item))
			throw new NotInCartException(item);
	}

	/**
	 * Returns the items in the Cart.
	 */
	public Collection getItems()
	{
		return items;
	}

	/**
	 * Called when the Session is activated.
	 */
	public void ejbActivate()
	{
	}
	
	/**
	 * Called when the SessionBean is passivated due to
	 * any form of timeout.
	 */
	public void ejbPassivate()
	{
	}

	/**
	 * Called when the SessionBean is invalidated.
	 */
	public void ejbRemove()
	{
	}

	/**
	 * Gives the bean access to it's context/environment.
	 */
	public void setSessionContext(SessionContext context)
	{
	}
}
