package com.evermind.ejb.taglib;

import javax.ejb.*;
import javax.naming.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

public class UseBeanTag extends TagSupport
{
	protected Object value;
	protected String type;
	protected String scope;

	public void setScope(String scope)
	{
		this.scope = scope;
	}

	public void setValue(Object value)
	{
		this.value = value;
	}

	public void setType(String type)
	{
		this.type = type;
	}

	public int doStartTag() throws JspException
	{
		try
		{
			if(value == null)
			{
				if(scope != null)
				{
					if(scope.equals("session"))
					{
						HttpSession session = pageContext.getSession();
						
						if(session != null)
						{
							Object object = session.getAttribute(this.getId());
						
							if(object instanceof EJBObject)
							{
								pageContext.setAttribute(this.getId(), object);
								return SKIP_BODY;
							}
						}
					}
					else if(scope.equals("request"))
					{
						Object object = pageContext.getRequest().getAttribute(this.getId());
						
						if(object instanceof EJBObject)
						{
							pageContext.setAttribute(this.getId(), object);
							return SKIP_BODY;
						}
					}
					else if(scope.equals("application"))
					{
						Object object = pageContext.getServletContext().getAttribute(this.getId());
						
						if(object instanceof EJBObject)
						{
							pageContext.setAttribute(this.getId(), object);
							return SKIP_BODY;
						}
					}
				}

				return EVAL_BODY_INCLUDE;
			}
			else
			{
				InitialContext context = new InitialContext();
		
				EJBObject instance = (EJBObject)javax.rmi.PortableRemoteObject.narrow(value, Class.forName(type, true, pageContext.getPage().getClass().getClassLoader()));
				pageContext.setAttribute(this.getId(), instance);

				return SKIP_BODY;
			}
		}
		catch(NamingException e)
		{
			throw new JspException("NamingException: " + e.getMessage());
		}
		catch(ClassNotFoundException e)
		{
			throw new JspException("ClassNotFoundException: " + e.getMessage());
		}
	}
}
