# NOTE: Derived from blib/lib/Net/SOCKS.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Net::SOCKS;

#line 189 "blib/lib/Net/SOCKS.pm (autosplit into blib/lib/auto/Net/SOCKS/connect.al)"
# connect() opens a socket through _request() and sends a command
# code of 1 to the SOCKS server.  It returns a reference to a socket
# upon success or undef upon failure.

sub connect {
  my $self = shift;

  if (${*self}{protocol_version}==4) {
    if ( $self->_request(1, @_) == SOCKS_OKAY ) { return ${*self}{fh} }
  } elsif (${*self}{protocol_version}==5) {
    if ( $self->_request5(1, @_) == SOCKS_OKAY ) { return ${*self}{fh} }
  } else {
    ${*self}{status_num} = SOCKS_UNSUPPORTED_PROTOCOL_VERSION;
  }

  return undef;
}

# end of Net::SOCKS::connect
1;
