# PaxoBackend.py
# 
# Copyright (c) 1999 Philip Hunt
# Released under the GNU General Public Licence
# 
# Paxo backend for Parrot
# 
# Paxo is the Parrot XML Output format.
# The Paxo backend takes the attributes that were written into
# the PaxoBackend classes by the backend.py module, and writes
# them to an XML file. Note that this means that attribute processing
# is done, so if there is a sub.<attr>=<value>, then this attribute
# will be written to all the subcomponents in the Paxo output
# file.

# Last altered: 28-Aug-1999
# History:
# 24-Aug-1999 PhilHunt: created


from inrep import *

from backend import *

prefixLength = 3
prefix = ' '*prefixLength

#===========================================================
# non-container components
#===========================================================

class Paxo_component(Backend_component):

   def getCode(self, pre):
      newPre = pre + prefix
      result = pre + '<component>\n'
      result = result + self.getTypeCode(newPre)
      result = result + self.getAttrCode(newPre)
      result = result + pre + '</component>\n'
      return result
 
   def getAttrDoc(self):
      return {'text': "the label's text"}

   def getTypeCode(self, pre):
      return pre + ('<type>%s</type>\n' % self.type)

   def getAttrCode(self, pre):
      result = ''
      for k,v in self.attr.items():
         result = result + pre \
            + ('<attr><name>%s</name><value>%s</value></attr>\n'
               % (k, v))
      return result
 

#===========================================================
# containers
#===========================================================

class Paxo_container(Backend_container, Paxo_component): 

   def __init__(self):
      components = [ ]

   def getAttrDoc(self):
      return {}

   def getSubComponentCode(self, pre):
      result = ''
      for sc in self.components:
         result = result + sc.getCode(pre)
      return result
 
   def getCode(self, pre):
      newPre = pre + prefix
      result = pre + '<container>\n'
      result = result + self.getTypeCode(newPre)
      result = result + self.getAttrCode(newPre) 
      result = result + self.getSubComponentCode(newPre)
      result = result + pre + '</container>\n'
      return result
 


#===========================================================
#####  Paxo backend  ####################################### 
#===========================================================

class Paxo_GLOBAL(Backend_GLOBAL,Paxo_container):

   def getStartCode(self):
      return """<?xml version="1.0"?>
<!-- autogenerated by Parrot's PaxoBackend module -->
<gui>
""" 

   def getEndCode(self):
      return """
</gui>
"""

   def getBackendSignature(self): return 'Paxo'

   def produceCode(self):
      return self.getCode()

   def getCode(self):
      result = self.getStartCode()
      result = result + self.getAttrCode(prefix)
      result = result + self.getSubComponentCode(prefix)
      result = result + self.getEndCode()
      return result
      

   # The Html backend produces files with an .html extension
   def fileExtension(self): return '.xml'

   # return list of container types understood by this backend:
   def getContainerTypes(self):
      return [ ] 
      # Paxo doesn't understand any types, it just outputs them
      # as-is.

   # return list of components which aren't containers
   def getNonContainerTypes(self):
      return [ ]




#===========================================================

#end 








