namespace eval Users {

proc {new} {} {
global PgAcVar
	Window show .pgaw:User
	wm transient .pgaw:User .pgaw:Main
	set PgAcVar(user,action) "CREATE"
	set PgAcVar(user,name) {}
	set PgAcVar(user,password) {}
	set PgAcVar(user,createdb) NOCREATEDB
	set PgAcVar(user,createuser) NOCREATEUSER
	set PgAcVar(user,verifypassword) {}
	set PgAcVar(user,validuntil) {}
	focus .pgaw:User.eusername
}

proc {design} {username} {
global PgAcVar CurrentDB
	Window show .pgaw:User
	tkwait visibility .pgaw:User
	wm transient .pgaw:User .pgaw:Main
	wm title .pgaw:User [intlmsg "Change user"]
	set PgAcVar(user,action) "ALTER"
	set PgAcVar(user,name) $username
	set PgAcVar(user,password) {} ; set PgAcVar(user,verifypassword) {}
	pg_select $CurrentDB "SELECT *,date(valuntil) AS valdata FROM pg_user WHERE usename='$username'" tup {
		if {$tup(usesuper)=="t"} {
			set PgAcVar(user,createuser) CREATEUSER
		} else {
			set PgAcVar(user,createuser) NOCREATEUSER
		}
		if {$tup(usecreatedb)=="t"} {
			set PgAcVar(user,createdb) CREATEDB
		} else {
			set PgAcVar(user,createdb) NOCREATEDB
		}
		if {$tup(valuntil)!=""} {
			set PgAcVar(user,validuntil) $tup(valdata)
		} else {
			set PgAcVar(user,validuntil) {}
		}
	}
	.pgaw:User.eusername configure -state disabled
	.pgaw:User.bcreate configure -text [intlmsg Save]
	focus .pgaw:User.epassword
}

proc {save} {} {
global PgAcVar CurrentDB
	set PgAcVar(user,name) [string trim $PgAcVar(user,name)]
	set PgAcVar(user,password) [string trim $PgAcVar(user,password)]
	set PgAcVar(user,verifypassword) [string trim $PgAcVar(user,verifypassword)]
	if {$PgAcVar(user,name)==""} {
		showError [intlmsg "User without name?"]
		focus .pgaw:User.eusername
		return
	}
	if {$PgAcVar(user,password)!=$PgAcVar(user,verifypassword)} {
		showError [intlmsg "Passwords do not match!"]
		set PgAcVar(user,password) {} ; set PgAcVar(user,verifypassword) {}
		focus .pgaw:User.epassword
		return
	}
	set cmd "$PgAcVar(user,action) user \"$PgAcVar(user,name)\""
	if {$PgAcVar(user,password)!=""} {
		set cmd "$cmd WITH PASSWORD '$PgAcVar(user,password)' "
	}
	set cmd "$cmd $PgAcVar(user,createdb) $PgAcVar(user,createuser)"
	if {$PgAcVar(user,validuntil)!=""} {
		set cmd "$cmd VALID UNTIL '$PgAcVar(user,validuntil)'"
	}
	if {[sql_exec noquiet $cmd]} {
		Window destroy .pgaw:User
		Mainlib::cmd_Users
	}
}

}

proc vTclWindow.pgaw:User {base} {
	if {$base == ""} {
		set base .pgaw:User
	}
	if {[winfo exists $base]} {
		wm deiconify $base; return
	}
	toplevel $base -class Toplevel
	wm focusmodel $base passive
	wm geometry $base 263x220+233+165
	wm maxsize $base 1009 738
	wm minsize $base 1 1
	wm overrideredirect $base 0
	wm resizable $base 0 0
	wm deiconify $base
	wm title $base [intlmsg "Define new user"]

	label $base.lusername \
		-borderwidth 0 -anchor w -text [intlmsg "User name"]
	entry $base.eusername \
		-background #fefefe -borderwidth 1 -textvariable PgAcVar(user,name) 
	bind $base.eusername <Key-Return> "focus .pgaw:User.epassword"
	bind $base.eusername <Key-KP_Enter> "focus .pgaw:User.epassword"

	label $base.lpassword \
		-borderwidth 0 -text [intlmsg Password]
	entry $base.epassword \
		-background #fefefe -borderwidth 1 -show * \
		-textvariable PgAcVar(user,password) 
	bind $base.epassword <Key-Return> "focus .pgaw:User.everifypassword"
	bind $base.epassword <Key-KP_Enter> "focus .pgaw:User.everifypassword"

	label $base.lverifypassword \
		-borderwidth 0 -text [intlmsg {verify password}]
	entry $base.everifypassword \
		-background #fefefe -borderwidth 1 -show * \
		-textvariable PgAcVar(user,verifypassword) 
	bind $base.everifypassword <Key-Return> "focus .pgaw:User.cbcreatedb"
	bind $base.everifypassword <Key-KP_Enter> "focus .pgaw:User.cbcreatedb"

	checkbutton $base.cbcreatedb \
		-borderwidth 1 -offvalue NOCREATEDB -onvalue CREATEDB \
		-text [intlmsg {Allow user to create databases}] \
		-variable PgAcVar(user,createdb) 
	checkbutton $base.cbcreateuser \
		-borderwidth 1 -offvalue NOCREATEUSER -onvalue CREATEUSER \
		-text [intlmsg {Allow user to create other users}] \
		-variable PgAcVar(user,createuser) 

	label $base.lvaliduntil \
		-borderwidth 0 -anchor w -text [intlmsg {Valid until (date)}]
	entry $base.evaliduntil \
		-background #fefefe -borderwidth 1 \
		-textvariable PgAcVar(user,validuntil)
	bind $base.evaliduntil <Key-Return> "focus .pgaw:User.bcreate"
	bind $base.evaliduntil <Key-KP_Enter> "focus .pgaw:User.bcreate"

	button $base.bcreate \
		-borderwidth 1 -command Users::save -text [intlmsg Create]
	button $base.bcancel \
		-borderwidth 1 -command {Window destroy .pgaw:User} \
		-text [intlmsg Cancel]

	place $base.lusername \
		-x 5 -y 7 -height 16 -anchor nw -bordermode ignore 
	place $base.eusername \
		-x 109 -y 5 -width 146 -height 20 -anchor nw -bordermode ignore 
	place $base.lpassword \
		-x 5 -y 35 -anchor nw -bordermode ignore 
	place $base.epassword \
		-x 109 -y 32 -width 146 -height 20 -anchor nw -bordermode ignore 
	place $base.lverifypassword \
		-x 5 -y 60 -anchor nw -bordermode ignore 
	place $base.everifypassword \
		-x 109 -y 58 -width 146 -height 20 -anchor nw -bordermode ignore 
	place $base.cbcreatedb \
		-x 5 -y 90 -anchor nw -bordermode ignore 
	place $base.cbcreateuser \
		-x 5 -y 115 -anchor nw -bordermode ignore 
	place $base.lvaliduntil \
		-x 5 -y 145 -height 16 -anchor nw -bordermode ignore 
	place $base.evaliduntil \
		-x 110 -y 143 -width 146 -height 20 -anchor nw -bordermode ignore 
	place $base.bcreate \
		-x 45 -y 185 -anchor nw -width 70 -height 25 -bordermode ignore 
	place $base.bcancel \
		-x 140 -y 185 -anchor nw -width 70 -height 25 -bordermode ignore 
}

