/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import phex.Res;
import phex.ServiceManager;
import phex.actions.base.ActionBase;
import phex.gui.actions.FWAction;
import phex.gui.common.GUIRegistry;
import phex.utils.Logger;

public class BaseFrame
extends JFrame {
    private static Vector sFrames = new Vector();
    private String mFrameType;
    protected Hashtable mActions;
    protected Hashtable mAccelerators = new Hashtable();

    protected BaseFrame() {
    }

    public BaseFrame(String string) {
        sFrames.addElement(this);
        this.mFrameType = string;
        this.mActions = new Hashtable();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading L&F: " + exception);
        }
        this.setTitle(Res.getStr(this.mFrameType + ".Title"));
        ((Component)this).setBackground(Color.lightGray);
        Icon icon = GUIRegistry.getInstance().getIconFactory().getIcon("Phex16");
        if (icon != null) {
            ((Frame)this).setIconImage(((ImageIcon)icon).getImage());
        }
        JMenuBar jMenuBar = this.createMenubar();
        this.setJMenuBar(jMenuBar);
        JToolBar jToolBar = this.createToolbar();
        if (jToolBar != null) {
            this.getContentPane().add("North", jToolBar);
        }
    }

    public void dispose() {
        try {
            sFrames.removeElement(this);
            super.dispose();
        }
        catch (Exception exception) {
            Logger.logWarning((short)32, exception);
        }
    }

    private FWAction loadAction(String string) {
        String string2 = Res.getStr(string + ".ActionKey");
        if (string2 != null) {
            FWAction fWAction = GUIRegistry.getInstance().getGlobalAction(string2);
            if (fWAction == null) {
                Logger.logMessage(Logger.SEVERE, (short)32, "No action for action key '" + string2 + "' found.");
            }
            return fWAction;
        }
        String string3 = Res.getStr(string + ".ActionID");
        String string4 = Res.getStr(string + ".Label");
        ImageIcon imageIcon = Res.getIcon(string + ".Icon");
        String string5 = Res.getStr(string + ".ActionClass");
        if (string3 == null) {
            System.out.println("Missing " + string + ".ActionID");
            return null;
        }
        if (string5 == null) {
            System.out.println("Missing " + string + ".ActionClass");
            return null;
        }
        if (this.mActions.get(string3) != null) {
            return (ActionBase)this.mActions.get(string3);
        }
        try {
            Class[] classArray = new Class[3];
            Object[] objectArray = new Object[3];
            classArray[0] = this.getClass().getSuperclass();
            classArray[1] = Class.forName("java.lang.String");
            classArray[2] = Class.forName("javax.swing.Icon");
            objectArray[0] = this;
            objectArray[1] = string4;
            objectArray[2] = imageIcon;
            Class<?> clazz = Class.forName(string5);
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            ActionBase actionBase = (ActionBase)constructor.newInstance(objectArray);
            this.mActions.put(string3, actionBase);
            return actionBase;
        }
        catch (Exception exception) {
            System.out.println("Fail to load " + string5 + ".  " + exception);
            return null;
        }
    }

    private JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        String string = Res.getStr(this.mFrameType + ".MenuBar");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = Res.getStr(string2 + ".Label");
                if (string3 == null) continue;
                JMenu jMenu = new JMenu(string3);
                String string4 = Res.getStr(string2 + ".Mnemonic");
                if (string4 != null) {
                    jMenu.setMnemonic(string4.charAt(0));
                }
                this.populateMenu(jMenu, string2);
                jMenuBar.add(jMenu);
            }
        }
        return jMenuBar;
    }

    private void populateMenu(JMenu jMenu, String string) {
        String string2 = Res.getStr(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        Object object = "";
        ButtonGroup buttonGroup = null;
        while (stringTokenizer.hasMoreTokens()) {
            Object object2;
            Object object3;
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("-")) {
                jMenu.addSeparator();
                continue;
            }
            if (Res.getStr(string3 + ".SubMenu") != null) {
                object3 = new JMenu(Res.getStr(string3 + ".Label"));
                object2 = Res.getStr(string3 + ".Mnemonic");
                ((AbstractButton)object3).setMnemonic(((String)object2).charAt(0));
                this.populateMenu((JMenu)object3, string3);
                jMenu.add((JMenuItem)object3);
                continue;
            }
            object3 = Res.getStr(string3 + ".Radio");
            if (object3 == null) {
                buttonGroup = null;
                object = "";
            } else if (!((String)object3).equals(object) || buttonGroup == null) {
                buttonGroup = new ButtonGroup();
                object = object3;
            }
            object2 = this.createMenuItem(string3, buttonGroup);
            if (object2 == null) continue;
            jMenu.add((JMenuItem)object2);
        }
    }

    public JPopupMenu createPopupMenu(String string) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.populatePopupMenu(jPopupMenu, string);
        return jPopupMenu;
    }

    public void populatePopupMenu(JPopupMenu jPopupMenu, String string) {
        String string2 = Res.getStr(string);
        if (string2 == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        String string3 = "";
        ButtonGroup buttonGroup = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("-")) {
                jPopupMenu.addSeparator();
                continue;
            }
            String string5 = Res.getStr(string4 + ".Radio");
            if (string5 == null) {
                buttonGroup = null;
                string3 = "";
            } else if (!string5.equals(string3) || buttonGroup == null) {
                buttonGroup = new ButtonGroup();
                string3 = string5;
            }
            JMenuItem jMenuItem = this.createMenuItem(string4, buttonGroup);
            if (jMenuItem == null) continue;
            jPopupMenu.add(jMenuItem);
        }
    }

    private JMenuItem createMenuItem(String string, ButtonGroup buttonGroup) {
        JMenuItem jMenuItem;
        String string2 = Res.getStr(string + ".ActionID");
        String string3 = Res.getStr(string + ".Label");
        ImageIcon imageIcon = Res.getIcon(string + ".Icon");
        boolean bl = Res.getStr(string + ".CheckBox") != null;
        String string4 = Res.getStr(string + ".Mnemonic");
        KeyStroke keyStroke = Res.getAccelerator(string + ".Accelerator");
        boolean bl2 = Res.getStr(string + ".Radio.Selected") != null;
        FWAction fWAction = this.loadAction(string);
        if (buttonGroup != null) {
            jMenuItem = new JRadioButtonMenuItem(string3);
            buttonGroup.add(jMenuItem);
            if (bl2) {
                jMenuItem.setSelected(true);
            }
        } else if (bl) {
            jMenuItem = new JCheckBoxMenuItem(string3);
        } else {
            jMenuItem = new JMenuItem();
            if (string3 != null) {
                jMenuItem.setText(string3);
            } else {
                jMenuItem.setText((String)fWAction.getValue("Name"));
            }
        }
        if (fWAction != null) {
            jMenuItem.addActionListener(fWAction);
            if (fWAction instanceof ActionBase) {
                ((ActionBase)fWAction).addRefreshComponent(jMenuItem);
            }
        } else {
            jMenuItem.setEnabled(false);
        }
        if (string4 != null) {
            jMenuItem.setMnemonic(string4.charAt(0));
        }
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
            this.mAccelerators.put(keyStroke, keyStroke);
        }
        if (imageIcon != null && !bl) {
            jMenuItem.setIcon(imageIcon);
            jMenuItem.setHorizontalTextPosition(4);
        } else {
            jMenuItem.setIcon((Icon)fWAction.getValue("SmallIcon"));
        }
        return jMenuItem;
    }

    private JToolBar createToolbar() {
        JToolBar jToolBar = new JToolBar();
        int n = 0;
        String string = Res.getStr(this.mFrameType + ".ToolBar");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                AbstractButton abstractButton;
                Object object;
                ++n;
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("-")) {
                    jToolBar.addSeparator();
                    continue;
                }
                boolean bl = Res.getStr(string2 + ".CheckBox") != null;
                FWAction fWAction = this.loadAction(string2);
                if (fWAction == null) {
                    System.out.println("No action class for " + string2);
                    continue;
                }
                if (bl) {
                    object = Res.getIcon(string2 + ".Icon");
                    ImageIcon imageIcon = Res.getIcon(string2 + ".Icon.Selected");
                    JToggleButton jToggleButton = new JToggleButton(imageIcon);
                    jToggleButton.setSelectedIcon((Icon)object);
                    jToggleButton.addActionListener(fWAction);
                    jToolBar.add(jToggleButton);
                    abstractButton = jToggleButton;
                } else {
                    abstractButton = jToolBar.add(fWAction);
                }
                if (fWAction instanceof ActionBase) {
                    ((ActionBase)fWAction).addRefreshComponent(abstractButton);
                }
                abstractButton.setMargin(new Insets(0, 0, 0, 0));
                object = Res.getStr(string2 + ".Tooltip");
                if (object == null) {
                    object = (String)fWAction.getValue("ToolTipText");
                }
                abstractButton.setToolTipText((String)object);
                abstractButton.setText(null);
            }
        }
        if (n > 0) {
            jToolBar.add(Box.createHorizontalGlue());
            return jToolBar;
        }
        return null;
    }

    public void refreshAllActions() {
        Enumeration enumeration = this.mActions.elements();
        while (enumeration.hasMoreElements()) {
            ActionBase actionBase = (ActionBase)enumeration.nextElement();
            actionBase.refresh();
        }
    }

    public void refreshAction(String string) {
        ActionBase actionBase = (ActionBase)this.mActions.get(string);
        if (actionBase != null) {
            actionBase.refresh();
        }
    }

    protected void doAction(Component component, String string) {
        Action action = (Action)this.mActions.get(string);
        if (action == null) {
            JOptionPane.showMessageDialog(this, "No action defined for " + string, "Error", 0);
            return;
        }
        action.actionPerformed(new ActionEvent(component, 1001, string));
    }

    public void addRefreshComponent(String string, JComponent jComponent) {
        ActionBase actionBase = (ActionBase)this.mActions.get(string);
        if (actionBase != null) {
            actionBase.addRefreshComponent(jComponent);
        }
    }

    public void setFonts() {
        FontUIResource fontUIResource = new FontUIResource(ServiceManager.sCfg.mFontTable);
        UIManager.getDefaults().put("Table.font", fontUIResource);
        UIManager.getDefaults().put("TextPane.font", fontUIResource);
        UIManager.getDefaults().put("TextArea.font", fontUIResource);
        UIManager.getDefaults().put("TextField.font", fontUIResource);
        UIManager.getDefaults().put("PasswordField.font", fontUIResource);
        UIManager.getDefaults().put("EditorPane.font", fontUIResource);
        UIManager.getDefaults().put("ProgressBar.font", fontUIResource);
        FontUIResource fontUIResource2 = new FontUIResource(ServiceManager.sCfg.mFontMenu);
        UIManager.getDefaults().put("MenuBar.font", fontUIResource2);
        UIManager.getDefaults().put("Menu.font", fontUIResource2);
        UIManager.getDefaults().put("MenuItem.font", fontUIResource2);
        UIManager.getDefaults().put("PopupMenu.font", fontUIResource2);
        UIManager.getDefaults().put("CheckBoxMenuItem.font", fontUIResource2);
        UIManager.getDefaults().put("RadioButtonMenuItem.font", fontUIResource2);
        FontUIResource fontUIResource3 = new FontUIResource(ServiceManager.sCfg.mFontLabel);
        UIManager.getDefaults().put("CheckBox.font", fontUIResource3);
        UIManager.getDefaults().put("ComboBox.font", fontUIResource3);
        UIManager.getDefaults().put("Button.font", fontUIResource3);
        UIManager.getDefaults().put("Tree.font", fontUIResource3);
        UIManager.getDefaults().put("ScrollPane.font", fontUIResource3);
        UIManager.getDefaults().put("TabbedPane.font", fontUIResource3);
        UIManager.getDefaults().put("TitledBorder.font", fontUIResource3);
        UIManager.getDefaults().put("OptionPane.font", fontUIResource3);
        UIManager.getDefaults().put("ToolBar.font", fontUIResource3);
        UIManager.getDefaults().put("RadioButton.font", fontUIResource3);
        UIManager.getDefaults().put("ToggleButton.font", fontUIResource3);
        UIManager.getDefaults().put("ToolTip.font", fontUIResource3);
        UIManager.getDefaults().put("TableHeader.font", fontUIResource3);
        UIManager.getDefaults().put("Panel.font", fontUIResource3);
        UIManager.getDefaults().put("List.font", fontUIResource3);
        UIManager.getDefaults().put("ColorChooser.font", fontUIResource3);
        UIManager.getDefaults().put("Label.font", fontUIResource3);
        UIManager.getDefaults().put("Viewport.font", fontUIResource3);
        BaseFrame.updateComponentsUI();
    }

    public static void setAllFramesLookAndFeel(LookAndFeel lookAndFeel) {
        try {
            if (lookAndFeel.getID().equals(UIManager.getLookAndFeel().getID())) {
                return;
            }
            UIManager.setLookAndFeel(lookAndFeel);
            BaseFrame.updateComponentsUI();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), "Error loading Look & Feel " + exception, "Error", 0);
        }
    }

    protected static void updateComponentsUI() {
        int n = 0;
        while (n < sFrames.size()) {
            BaseFrame baseFrame = (BaseFrame)sFrames.elementAt(n);
            SwingUtilities.updateComponentTreeUI(baseFrame);
            baseFrame.refreshAllActions();
            Window[] windowArray = baseFrame.getOwnedWindows();
            int n2 = 0;
            while (n2 < windowArray.length) {
                SwingUtilities.updateComponentTreeUI(windowArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public void resetLookAndFeel() {
        try {
            UIManager.setLookAndFeel(ServiceManager.sCfg.mLFClassName);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error loading Look & Feel " + exception, "Error", 0);
        }
        this.refreshAllActions();
    }

    public static void resetAllFramesLookAndFeel() {
        int n = 0;
        while (n < sFrames.size()) {
            BaseFrame baseFrame = (BaseFrame)sFrames.elementAt(n);
            baseFrame.resetLookAndFeel();
            ++n;
        }
    }

    public static void centerWindow(Window window, Point point) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        Rectangle rectangle = new Rectangle((dimension.width - dimension2.width) / 2 + point.x, (dimension.height - dimension2.height) / 2 + point.y, dimension2.width, dimension2.height);
        ((Component)window).setBounds(rectangle);
    }

    public static void centerAndSizeWindow(Window window, int n, int n2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = dimension.width * n / n2;
        int n4 = dimension.height * n / n2;
        Rectangle rectangle = new Rectangle((dimension.width - n3) / 2, (dimension.height - n4) / 2, n3, n4);
        ((Component)window).setBounds(rectangle);
    }
}

