/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.io.Serializable;
import java.rmi.dgc.VMID;
import phex.utils.HexConverter;

public class GUID
implements Serializable {
    public static final int sDataLength = 16;
    private byte[] mBytes;
    private Integer mHashCode = new Integer(0);
    private String mStr = null;

    public GUID() {
        VMID vMID = new VMID();
        this.mBytes = new byte[16];
        this.vmid2GUID(vMID.toString());
        this.computeHashCode();
    }

    public GUID(boolean bl) {
        this.mBytes = new byte[16];
    }

    public GUID(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("Attempted to construct a GUID from an array of bytes not 16 long: " + byArray.length);
        }
        this.mBytes = byArray;
        this.mStr = null;
        this.computeHashCode();
    }

    public void setGuid(byte[] byArray) {
        System.arraycopy(byArray, 0, this.mBytes, 0, 16);
        this.mStr = null;
        this.computeHashCode();
    }

    public byte[] getGuid() {
        return this.mBytes;
    }

    public Integer getHashCode() {
        return this.mHashCode;
    }

    public boolean equals(GUID gUID) {
        int n = 0;
        while (n < 16) {
            if (this.mBytes[n] != gUID.mBytes[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void computeHashCode() {
        int n = this.mBytes[0] < 0 ? this.mBytes[0] + 256 : this.mBytes[0];
        int n2 = this.mBytes[1] < 0 ? this.mBytes[1] + 256 : this.mBytes[1];
        int n3 = this.mBytes[2] < 0 ? this.mBytes[2] + 256 : this.mBytes[2];
        int n4 = this.mBytes[3] < 0 ? this.mBytes[3] + 256 : this.mBytes[3];
        int n5 = n << 24 | n2 << 16 | n3 << 8 | n4;
        int n6 = 4;
        while (n6 < 16) {
            n = this.mBytes[n6 + 0] < 0 ? this.mBytes[n6 + 0] + 256 : this.mBytes[n6 + 0];
            n2 = this.mBytes[n6 + 1] < 0 ? this.mBytes[n6 + 1] + 256 : this.mBytes[n6 + 1];
            n3 = this.mBytes[n6 + 2] < 0 ? this.mBytes[n6 + 2] + 256 : this.mBytes[n6 + 2];
            n4 = this.mBytes[n6 + 3] < 0 ? this.mBytes[n6 + 3] + 256 : this.mBytes[n6 + 3];
            int n7 = n << 24 | n2 << 16 | n3 << 8 | n4;
            n5 ^= n7;
            n6 += 4;
        }
        this.mHashCode = new Integer(n5);
    }

    public int getSize() {
        return 16;
    }

    public void copy(byte[] byArray) {
        System.arraycopy(byArray, 0, this.mBytes, 0, 16);
        this.mStr = null;
        this.computeHashCode();
    }

    public int serialize(byte[] byArray, int n) {
        System.arraycopy(this.mBytes, 0, byArray, n, 16);
        return n + 16;
    }

    public int deserialize(byte[] byArray, int n) {
        System.arraycopy(byArray, n, this.mBytes, 0, 16);
        this.mStr = null;
        this.computeHashCode();
        return n + 16;
    }

    private void vmid2GUID(String string) {
        int n = 0;
        int n2 = 0;
        while (n < string.length()) {
            if (n < 16) {
                this.mBytes[n2] = (byte)string.charAt(n);
            } else {
                int n3 = n2;
                this.mBytes[n3] = (byte)(this.mBytes[n3] ^ (byte)string.charAt(n));
            }
            if (++n2 >= 16) {
                n2 = 0;
            }
            ++n;
        }
        this.mStr = null;
        this.mBytes[8] = -1;
        this.mBytes[15] = 0;
    }

    public String toString() {
        if (this.mStr == null) {
            this.mStr = this.generateString();
        }
        return this.mStr;
    }

    private String generateString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(HexConverter.toHexString(this.mBytes, 0, 4));
        stringBuffer.append('-');
        stringBuffer.append(HexConverter.toHexString(this.mBytes, 4, 2));
        stringBuffer.append('-');
        stringBuffer.append(HexConverter.toHexString(this.mBytes, 6, 2));
        stringBuffer.append('-');
        stringBuffer.append(HexConverter.toHexString(this.mBytes, 8, 2));
        stringBuffer.append('-');
        stringBuffer.append(HexConverter.toHexString(this.mBytes, 10, 6));
        return stringBuffer.toString();
    }

    public String toHexString() {
        return HexConverter.toHexString(this.mBytes);
    }

    public void fromHexString(String string) throws Exception {
        this.mBytes = HexConverter.toBytes(string);
        this.mStr = null;
        this.computeHashCode();
    }

    public static GUID createFromHexString(String string) throws Exception {
        GUID gUID = new GUID(true);
        gUID.fromHexString(string);
        return gUID;
    }

    public static void main(String[] stringArray) {
        GUID gUID = new GUID();
        System.out.println(gUID);
    }
}

