/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.io.IOException;
import java.net.Socket;
import phex.ServiceManager;
import phex.common.ThreadPool;
import phex.connection.ConnectionRequest;
import phex.host.Host;
import phex.msg.MsgPushRequest;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.utils.IOUtil;
import phex.utils.Logger;

public class PushWorker
implements Runnable {
    private MsgPushRequest mPushMsg;

    private PushWorker() {
    }

    public PushWorker(MsgPushRequest msgPushRequest) {
        this.mPushMsg = msgPushRequest;
        ThreadPool.getInstance().addJob(this);
    }

    public void run() {
        ShareManager shareManager = ServiceManager.getShareManager();
        Host host = null;
        try {
            ShareFile shareFile = shareManager.getFileAdministration().getFileByIndex((int)this.mPushMsg.getFileIndex());
            if (shareFile == null) {
                return;
            }
            Socket socket = ServiceManager.getConnectionManager().connect(this.mPushMsg.getRequestAddress());
            host = new Host(this.mPushMsg.getRequestAddress());
            host.setType(4);
            host.setSock(socket);
            host.setOs(socket.getOutputStream());
            host.setIs(socket.getInputStream());
            String string = "GIV " + this.mPushMsg.getFileIndex() + ":" + this.mPushMsg.getClientGUID().toHexString() + "/" + shareFile.getEffectiveName();
            byte[] byArray = new byte[1024];
            int n = IOUtil.serializeString(string, byArray, 0);
            byArray[n++] = 10;
            byArray[n++] = 10;
            host.getOs().write(byArray, 0, n);
            ConnectionRequest connectionRequest = new ConnectionRequest(host);
            connectionRequest.initializeIncomming();
            if (connectionRequest.getMethod().equals("GET")) {
                shareManager.httpRequestHandler(connectionRequest, host);
            }
            Logger.logMessage(Logger.FINER, (short)4, "PushWorker finished");
        }
        catch (IOException iOException) {
            Logger.logMessage(Logger.FINER, (short)4, iOException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

