/*
 * Decompiled with CFR 0.152.
 */
package phex;

import phex.SendWorker;
import phex.cqueue.CQueue;
import phex.host.Host;
import phex.host.HostMsg;
import phex.interfaces.IMsg;

public class SendManager {
    private CQueue mSendQueue = new CQueue(5000, true);
    private CQueue mFreeQueue = new CQueue(5000, true);

    SendManager() {
        SendWorker sendWorker = new SendWorker(this);
        sendWorker.startup();
        sendWorker = new SendWorker(this);
        sendWorker.startup();
        sendWorker = new SendWorker(this);
        sendWorker.startup();
        sendWorker = new SendWorker(this);
        sendWorker.startup();
    }

    public synchronized void queueMsgToSend(Host host, IMsg iMsg, boolean bl) {
        HostMsg hostMsg = (HostMsg)this.mFreeQueue.removeFromHead();
        if (hostMsg == null) {
            hostMsg = new HostMsg();
        }
        hostMsg.setHost(host);
        hostMsg.setMsg(iMsg);
        hostMsg.setUrgent(bl);
        this.queueMsgToSend(hostMsg);
    }

    public synchronized void queueMsgToSend(HostMsg hostMsg) {
        try {
            if (hostMsg.getUrgent()) {
                this.mSendQueue.addToHead(hostMsg);
            } else {
                this.mSendQueue.addToTail(hostMsg);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.notifyAll();
    }

    public synchronized HostMsg getNextHostMsg() {
        HostMsg hostMsg;
        while ((hostMsg = (HostMsg)this.mSendQueue.removeFromHead()) == null) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hostMsg;
    }

    public synchronized void freeHostMsg(HostMsg hostMsg) {
        try {
            hostMsg.setHost(null);
            hostMsg.setMsg(null);
            this.mFreeQueue.addToTail(hostMsg);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void queueDummyMsg() {
        this.queueMsgToSend(null, null, false);
    }
}

