/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.io.IOException;
import java.io.OutputStream;
import phex.FlexBuf;
import phex.SendManager;
import phex.ServiceManager;
import phex.common.ThreadPool;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.HostMsg;
import phex.interfaces.IMsg;
import phex.utils.StatisticTracker;

public class SendWorker
implements Runnable {
    private SendManager mManager;
    private boolean mRequestToDie = false;

    private SendWorker() {
    }

    public SendWorker(SendManager sendManager) {
        this.mManager = sendManager;
    }

    public void startup() {
        this.mRequestToDie = false;
        ThreadPool.getInstance().addJob(this);
    }

    public void shutdown() {
        this.mRequestToDie = true;
    }

    public void run() {
        FlexBuf flexBuf = new FlexBuf();
        HostManager hostManager = ServiceManager.getHostManager();
        StatisticTracker statisticTracker = ServiceManager.getStatisticTracker();
        while (!this.mRequestToDie) {
            HostMsg hostMsg;
            block10: {
                Object var14_15;
                hostMsg = this.mManager.getNextHostMsg();
                if (this.mRequestToDie) {
                    this.mManager.queueMsgToSend(hostMsg);
                    break;
                }
                Host host = hostMsg.getHost();
                IMsg iMsg = hostMsg.getMsg();
                if (host == null || iMsg == null || !host.acquireSendLockOrQueueMsg(hostMsg)) continue;
                try {
                    block9: {
                        try {
                            OutputStream outputStream = host.getOs();
                            if (outputStream == null) break block9;
                            iMsg.computeHeaderLen();
                            int n = iMsg.getSize();
                            byte[] byArray = flexBuf.getBuf(n);
                            iMsg.serialize(byArray, 0);
                            int n2 = 0;
                            boolean bl = false;
                            int n3 = 0;
                            while (n2 < n) {
                                n3 = n - n2;
                                if (n3 > 1024) {
                                    n3 = 1024;
                                }
                                outputStream.write(byArray, n2, n3);
                                n2 += n3;
                                statisticTracker.incBytesCount(n3);
                                hostManager.throttleControl(n3);
                            }
                            host.incSentCount();
                        }
                        catch (IOException iOException) {
                            host.setStatus(1, iOException.getMessage());
                            var14_15 = null;
                            host.releaseSendLock();
                            break block10;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            var14_15 = null;
                            host.releaseSendLock();
                        }
                    }
                    var14_15 = null;
                    host.releaseSendLock();
                }
                catch (Throwable throwable) {
                    var14_15 = null;
                    host.releaseSendLock();
                    throw throwable;
                }
            }
            this.mManager.freeHostMsg(hostMsg);
        }
    }
}

