/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.io.File;
import phex.GUID;
import phex.JobsRunner;
import phex.Listener;
import phex.NetworkManager;
import phex.SendManager;
import phex.common.TransferRateService;
import phex.config.Cfg;
import phex.connection.ConnectionManager;
import phex.download.swarming.SwarmingManager;
import phex.host.HostManager;
import phex.msg.MsgManager;
import phex.query.QueryManager;
import phex.share.IndexerManager;
import phex.share.ShareManager;
import phex.utils.FileUtils;
import phex.utils.Logger;
import phex.utils.StatisticTracker;
import phex.utils.ThrottleController;

public class ServiceManager {
    private static final String CONFIG_FILE_NAME;
    private static final String LOG_FILE_NAME;
    private static final String AUTOCONNECT_HOSTS_FILE_NAME;
    private static final String G_WEB_CACHE_FILE_NAME;
    private static final String HOSTS_FILE_NAME;
    public static final String XML_DOWNLOAD_FILE_NAME;
    private static final String XML_RESEARCH_SERVICE_FILE_NAME;
    private static final String XML_GUI_SETTINGS_FILE_NAME;
    private static final String XML_SHARED_LIBRARY_FILE_NAME;
    private static ServiceManager sTheManager;
    private static Object sInitLocker;
    public static Cfg sCfg;
    private String mLogfilename;
    private String mDebugfilename;
    private String mHostsFilename;
    private String autoConnectHostsFilename;
    private String gWebCacheFilename;
    private String mXMLDownloadSaveFilename;
    private String xmlResearchServiceFilename;
    private String xmlGUISettingsFilename;
    private String xmlSharedLibraryFilename;
    private ConnectionManager mConnectionManager;
    private NetworkManager mNetworkManager;
    private SendManager mSendManager;
    private HostManager mHostManager;
    private MsgManager mMsgManager;
    private ShareManager mShareManager;
    private SwarmingManager swarmingManager;
    private QueryManager queryManager;
    private IndexerManager mIndexerManager;
    private Listener mListener;
    private JobsRunner mJobsRunner;
    private StatisticTracker statisticTracker;
    private TransferRateService transferRateService;
    private ThrottleController phexBandwidthThrottle;
    private ThrottleController downloadThrottle;

    private static void checkPhexHomePath() {
        String string = ServiceManager.determinePhexHomePath();
        File file = new File(string);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        String[] stringArray = new String[]{"phex.cfg", "phex.log", "phex.hosts", "phex.debug", "phex.download", "phexdownload.xml"};
        String string2 = System.getProperty("user.home");
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(string2 + File.separator + stringArray[n]);
            if (file2.exists()) {
                File file3 = new File(string + File.separator + stringArray[n]);
                file2.renameTo(file3);
            }
            ++n;
        }
    }

    private static String determinePhexHomePath() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(System.getProperty("user.home"));
        stringBuffer.append(File.separator);
        if (File.separatorChar == '/') {
            stringBuffer.append('.');
        }
        stringBuffer.append("phex");
        return stringBuffer.toString();
    }

    public static ServiceManager getManager() {
        if (sTheManager == null) {
            Object object = sInitLocker;
            synchronized (object) {
                if (sTheManager == null) {
                    sTheManager = new ServiceManager();
                    sTheManager.init();
                }
            }
        }
        return sTheManager;
    }

    private ServiceManager() {
    }

    private void init() {
        String string;
        this.mLogfilename = ServiceManager.envSubstitution(LOG_FILE_NAME);
        sCfg = new Cfg(CONFIG_FILE_NAME);
        sCfg.load();
        if (ServiceManager.sCfg.mLogFile != null && ServiceManager.sCfg.mLogFile.length() > 0 && !(string = ServiceManager.envSubstitution(ServiceManager.sCfg.mLogFile)).equals(LOG_FILE_NAME)) {
            Logger.setLogFileName(string);
        }
        this.mHostsFilename = ServiceManager.sCfg.mHostFile;
        if (this.mHostsFilename == null || this.mHostsFilename.length() == 0) {
            this.mHostsFilename = HOSTS_FILE_NAME;
        }
        this.mHostsFilename = ServiceManager.envSubstitution(this.mHostsFilename);
        this.gWebCacheFilename = ServiceManager.sCfg.gWebCacheFilename;
        if (this.gWebCacheFilename == null || this.gWebCacheFilename.length() == 0) {
            this.gWebCacheFilename = G_WEB_CACHE_FILE_NAME;
        }
        this.gWebCacheFilename = ServiceManager.envSubstitution(this.gWebCacheFilename);
        this.autoConnectHostsFilename = ServiceManager.sCfg.autoConnectHostsFilename;
        if (this.autoConnectHostsFilename == null || this.autoConnectHostsFilename.length() == 0) {
            this.autoConnectHostsFilename = AUTOCONNECT_HOSTS_FILE_NAME;
        }
        this.autoConnectHostsFilename = ServiceManager.envSubstitution(this.autoConnectHostsFilename);
        this.xmlGUISettingsFilename = ServiceManager.sCfg.xmlGUISettingsFilename;
        if (this.xmlGUISettingsFilename == null || this.xmlGUISettingsFilename.length() == 0) {
            this.xmlGUISettingsFilename = XML_GUI_SETTINGS_FILE_NAME;
        }
        this.xmlGUISettingsFilename = ServiceManager.envSubstitution(this.xmlGUISettingsFilename);
        if (this.xmlSharedLibraryFilename == null || this.xmlSharedLibraryFilename.length() == 0) {
            this.xmlSharedLibraryFilename = XML_SHARED_LIBRARY_FILE_NAME;
        }
        this.xmlSharedLibraryFilename = ServiceManager.envSubstitution(this.xmlSharedLibraryFilename);
        this.mXMLDownloadSaveFilename = ServiceManager.sCfg.mXMLDownloadSaveFile;
        if (this.mXMLDownloadSaveFilename == null || this.mXMLDownloadSaveFilename.length() == 0) {
            this.mXMLDownloadSaveFilename = XML_DOWNLOAD_FILE_NAME;
        }
        this.mXMLDownloadSaveFilename = ServiceManager.envSubstitution(this.mXMLDownloadSaveFilename);
        this.xmlResearchServiceFilename = ServiceManager.sCfg.xmlResearchServiceFilename;
        if (this.xmlResearchServiceFilename == null || this.xmlResearchServiceFilename.length() == 0) {
            this.xmlResearchServiceFilename = XML_RESEARCH_SERVICE_FILE_NAME;
        }
        this.xmlResearchServiceFilename = ServiceManager.envSubstitution(this.xmlResearchServiceFilename);
        Logger.logMessage(Logger.FINE, (short)255, "Init ServiceManager");
        this.statisticTracker = new StatisticTracker();
        Logger.logMessage(Logger.FINER, (short)255, "Started StatisticTracker");
        this.transferRateService = new TransferRateService();
        Logger.logMessage(Logger.FINER, (short)255, "Started TransferRateService");
        this.mIndexerManager = new IndexerManager(this);
        Logger.logMessage(Logger.FINER, (short)255, "Started IndexerManager");
        this.mConnectionManager = new ConnectionManager();
        Logger.logMessage(Logger.FINER, (short)255, "Started ConnectionManager");
        this.mNetworkManager = new NetworkManager();
        Logger.logMessage(Logger.FINER, (short)255, "Started NetworkManager");
        this.mListener = new Listener();
        Logger.logMessage(Logger.FINER, (short)255, "Starting HostManager");
        this.mHostManager = new HostManager();
        this.queryManager = new QueryManager();
        Logger.logMessage(Logger.FINER, (short)255, "Started QueryManager");
        this.mSendManager = new SendManager();
        Logger.logMessage(Logger.FINER, (short)255, "Started SendManager");
        this.mMsgManager = new MsgManager();
        Logger.logMessage(Logger.FINER, (short)255, "Started MsgManager");
        this.mShareManager = new ShareManager();
        Logger.logMessage(Logger.FINER, (short)255, "Started ShareManager");
        this.swarmingManager = new SwarmingManager();
        Logger.logMessage(Logger.FINER, (short)255, "Started SwarmingManager");
        this.mJobsRunner = new JobsRunner();
        Logger.logMessage(Logger.FINER, (short)255, "Started JobsRunner");
        this.phexBandwidthThrottle = ThrottleController.acquireThrottle();
        this.phexBandwidthThrottle.setRate(ServiceManager.sCfg.maxTotalBandwidth);
        this.downloadThrottle = ThrottleController.acquireThrottle();
        this.downloadThrottle.linkThrottleIntoChain(this.phexBandwidthThrottle);
        this.downloadThrottle.setRate(ServiceManager.sCfg.mDownloadMaxBandwidth);
        Logger.logMessage(Logger.FINE, (short)255, "ServiceManager is ready");
    }

    public synchronized void shutdown() {
        this.mJobsRunner.shutdown(true);
        ThrottleController.releaseThrottle(this.downloadThrottle);
        ThrottleController.releaseThrottle(this.phexBandwidthThrottle);
    }

    public void startJobsRunner() {
        this.mJobsRunner.startup();
    }

    public static ConnectionManager getConnectionManager() {
        return ServiceManager.getManager().mConnectionManager;
    }

    public static NetworkManager getNetworkManager() {
        return ServiceManager.getManager().mNetworkManager;
    }

    public static SendManager getSendManager() {
        return ServiceManager.getManager().mSendManager;
    }

    public static HostManager getHostManager() {
        return ServiceManager.getManager().mHostManager;
    }

    public static QueryManager getQueryManager() {
        return ServiceManager.getManager().queryManager;
    }

    public static StatisticTracker getStatisticTracker() {
        return ServiceManager.getManager().statisticTracker;
    }

    public static TransferRateService getTransferRateService() {
        return ServiceManager.getManager().transferRateService;
    }

    public static MsgManager getMsgManager() {
        return ServiceManager.getManager().mMsgManager;
    }

    public static ShareManager getShareManager() {
        return ServiceManager.getManager().mShareManager;
    }

    public static SwarmingManager getSwarmingManager() {
        return ServiceManager.getManager().swarmingManager;
    }

    public static IndexerManager getIndexerManager() {
        return ServiceManager.getManager().mIndexerManager;
    }

    public static Listener getListener() {
        return ServiceManager.getManager().mListener;
    }

    public GUID getClientID() {
        return ServiceManager.sCfg.mProgramClientID;
    }

    public static String getHostsFilename() {
        if (ServiceManager.sCfg.mCurrentNetwork.equals("<General Gnutella Network>")) {
            return ServiceManager.getManager().mHostsFilename;
        }
        String string = "phex_" + ServiceManager.sCfg.mCurrentNetwork + ".hosts";
        string = FileUtils.convertToLocalSystemFilename(string);
        return System.getProperty("user.home") + File.separator + string;
    }

    public static String getAutoConnectHostsFilename() {
        return ServiceManager.getManager().autoConnectHostsFilename;
    }

    public static String getGWebCacheFilename() {
        return ServiceManager.getManager().gWebCacheFilename;
    }

    public static String getXMLDownloadSaveFilename() {
        return ServiceManager.getManager().mXMLDownloadSaveFilename;
    }

    public static String getXMLSharedLibraryFilename() {
        return ServiceManager.getManager().xmlSharedLibraryFilename;
    }

    public static String getXMLGUISettingsFilename() {
        return ServiceManager.getManager().xmlGUISettingsFilename;
    }

    public static String getXMLResearchServiceFilename() {
        return ServiceManager.getManager().xmlResearchServiceFilename;
    }

    public static String getLogFileName() {
        return ServiceManager.getManager().mLogfilename;
    }

    public static String envSubstitution(String string) {
        String string2 = string.toLowerCase();
        String string3 = "$user.home";
        String string4 = "$(user.home)";
        if (string2.startsWith(string3)) {
            string = System.getProperty("user.home") + string.substring(string3.length());
        } else if (string2.startsWith(string4)) {
            string = System.getProperty("user.home") + string.substring(string4.length());
        }
        return string;
    }

    public static void log(Object object) {
        Logger.logMessage(Logger.INFO, (short)255, object);
    }

    public static boolean isMacOSX() {
        String string = System.getProperty("os.name");
        return string.startsWith("Mac OS") && string.endsWith("X");
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string.indexOf("Windows") != -1;
    }

    public static void setUploadBandwidth(int n) {
        ServiceManager.sCfg.mUploadMaxBandwidth = n;
    }

    public static void setDownloadBandwidth(int n) {
        ServiceManager.sCfg.mDownloadMaxBandwidth = n;
        ServiceManager.sTheManager.downloadThrottle.setRate(n);
    }

    public static void setNetworkBandwidth(int n) {
        ServiceManager.sCfg.mNetMaxRate = n;
    }

    public static void setPhexTotalBandwidth(int n) {
        ServiceManager.sCfg.maxTotalBandwidth = n;
        ServiceManager.sTheManager.phexBandwidthThrottle.setRate(n);
    }

    public ThrottleController getPhexBandwidthThrottle() {
        return this.phexBandwidthThrottle;
    }

    public ThrottleController getDownloadThrottle() {
        return this.downloadThrottle;
    }

    static {
        ServiceManager.checkPhexHomePath();
        String string = ServiceManager.determinePhexHomePath();
        CONFIG_FILE_NAME = string + File.separator + "phex.cfg";
        LOG_FILE_NAME = string + File.separator + "phex.log";
        AUTOCONNECT_HOSTS_FILE_NAME = string + File.separator + "autoconnecthosts.cfg";
        G_WEB_CACHE_FILE_NAME = string + File.separator + "gwebcache.cfg";
        HOSTS_FILE_NAME = string + File.separator + "phex.hosts";
        XML_DOWNLOAD_FILE_NAME = string + File.separator + "phexdownload.xml";
        XML_RESEARCH_SERVICE_FILE_NAME = string + File.separator + "phexresearch.xml";
        XML_GUI_SETTINGS_FILE_NAME = string + File.separator + "phexgui.xml";
        XML_SHARED_LIBRARY_FILE_NAME = string + File.separator + "sharedlibrary.xml";
        sTheManager = null;
        sInitLocker = new Object();
    }
}

