/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.LinkedList;
import phex.utils.Logger;

public class ThreadPool {
    private static ThreadPool instance;
    private long suicideTime = 20000L;
    private long spawnTime = 500L;
    private LinkedList jobs = null;
    private int inactiveThreads = 0;
    private boolean askedToStop = false;

    public static ThreadPool getInstance() {
        if (instance == null) {
            instance = new ThreadPool();
        }
        return instance;
    }

    public void shutDown() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.askedToStop = true;
        }
    }

    public void addJob(Runnable runnable) {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (this.jobs == null) {
                this.jobs = new LinkedList();
                Worker worker = new Worker();
                worker.setDaemon(false);
                worker.start();
                JobMonitor jobMonitor = new JobMonitor();
                jobMonitor.setDaemon(true);
                jobMonitor.start();
            }
            this.jobs.addLast(new Job(runnable, System.currentTimeMillis()));
            this.notifyAll();
        }
    }

    private class Worker
    extends Thread {
        public void run() {
            Job job = null;
            while (true) {
                ThreadPool threadPool = ThreadPool.this;
                synchronized (threadPool) {
                    long l = System.currentTimeMillis();
                    while (ThreadPool.this.jobs.isEmpty()) {
                        long l2 = System.currentTimeMillis() - l;
                        long l3 = ThreadPool.this.suicideTime - l2;
                        if (l3 < 0L) {
                            return;
                        }
                        try {
                            ThreadPool.this.wait(l3);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (ThreadPool.this.askedToStop) {
                        return;
                    }
                    job = (Job)ThreadPool.this.jobs.removeFirst();
                }
                try {
                    job.getRunnable().run();
                    continue;
                }
                catch (Throwable throwable) {
                    Logger.logError(throwable);
                    continue;
                }
                break;
            }
        }
    }

    private class JobMonitor
    extends Thread {
        private JobMonitor() {
        }

        public void run() {
            while (true) {
                ThreadPool threadPool = ThreadPool.this;
                synchronized (threadPool) {
                    if (ThreadPool.this.jobs.isEmpty()) {
                        try {
                            ThreadPool.this.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        Job job = (Job)ThreadPool.this.jobs.getFirst();
                        long l = System.currentTimeMillis();
                        long l2 = l - job.getRequestTime();
                        if (l2 > ThreadPool.this.spawnTime) {
                            Worker worker = new Worker();
                            worker.setDaemon(false);
                            worker.start();
                        }
                        try {
                            ThreadPool.this.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private class Job {
        private final Runnable runnable;
        private final long requestTime;

        public Job(Runnable runnable, long l) {
            this.runnable = runnable;
            this.requestTime = l;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public long getRequestTime() {
            return this.requestTime;
        }
    }
}

