/*
 * Decompiled with CFR 0.152.
 */
package phex.dialogues;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import phex.BaseFrame;
import phex.utils.IPUtils;

public class DlgConfigFilter
extends JDialog
implements KeyListener {
    private BaseFrame mFrame;
    private Vector mFilterdHosts;
    private boolean mCancel;
    private JTextField mFilterText;
    private DefaultListModel mHostModel;
    private JList mHostList;

    public DlgConfigFilter(BaseFrame baseFrame, String string, Vector vector) {
        super((Frame)baseFrame, true);
        this.mFrame = baseFrame;
        this.mFilterdHosts = new Vector();
        this.setTitle("Filterd Hosts");
        this.setDefaultCloseOperation(1);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 0, 0));
        jPanel.add("Center", new JLabel("The search results of filtered host will be filtered."));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(20, 20, 6, 20), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(16, 20, 20, 20)));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.mFilterText = new JTextField(string, 20);
        JButton jButton = new JButton("Add");
        jButton.addActionListener(new AddActionListener());
        jPanel4.add("Center", this.mFilterText);
        jPanel4.add("East", jButton);
        jPanel3.add("North", new JLabel("Filter Host:"));
        jPanel3.add("Center", jPanel4);
        jPanel3.add("South", new JLabel("  "));
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JPanel jPanel6 = new JPanel(new FlowLayout());
        JButton jButton2 = new JButton("Remove");
        jButton2.addActionListener(new RemoveActionListener());
        jPanel6.add(jButton2);
        this.mHostModel = new DefaultListModel();
        this.mHostList = new JList(this.mHostModel);
        jPanel5.add("North", new JLabel("Filterd Hosts:"));
        jPanel5.add("Center", new JScrollPane(this.mHostList));
        jPanel5.add("South", jPanel6);
        jPanel2.add("North", jPanel3);
        jPanel2.add("Center", jPanel5);
        this.getContentPane().add("North", jPanel);
        this.getContentPane().add("Center", jPanel2);
        JPanel jPanel7 = new JPanel(new FlowLayout());
        JButton jButton3 = new JButton("OK");
        JButton jButton4 = new JButton("Cancel");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!actionEvent.getActionCommand().equals("Cancel")) {
                    if (!DlgConfigFilter.this.doOk()) {
                        return;
                    }
                } else {
                    DlgConfigFilter.this.mCancel = true;
                }
                ((Component)DlgConfigFilter.this).setVisible(false);
            }
        };
        jButton3.addActionListener(actionListener);
        jButton3.setMnemonic('O');
        jButton4.addActionListener(actionListener);
        jButton4.setMnemonic('C');
        jPanel7.add(jButton3);
        jPanel7.add(jButton4);
        this.getContentPane().add("South", jPanel7);
        this.addKeyListener(this);
        int n = 0;
        while (n < vector.size()) {
            String[] stringArray = (String[])vector.elementAt(n);
            String string2 = stringArray[0] + "." + stringArray[1] + "." + stringArray[2] + "." + stringArray[3];
            this.mHostModel.addElement(string2);
            ++n;
        }
        this.pack();
        BaseFrame.centerWindow(this, new Point(0, 0));
    }

    public Vector getFilteredHosts() {
        return this.mFilterdHosts;
    }

    public boolean getCancel() {
        return this.mCancel;
    }

    private boolean doOk() {
        int n = 0;
        while (n < this.mHostModel.size()) {
            this.mFilterdHosts.addElement(IPUtils.splitIP2Parts((String)this.mHostModel.elementAt(n)));
            ++n;
        }
        this.mCancel = false;
        return true;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.mCancel = true;
            ((Component)this).setVisible(false);
        } else if (keyEvent.getKeyCode() == 10) {
            // empty if block
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private class RemoveActionListener
    implements ActionListener {
        private RemoveActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = DlgConfigFilter.this.mHostList.getSelectedIndices();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            int n = nArray.length - 1;
            while (n >= 0) {
                DlgConfigFilter.this.mHostModel.removeElementAt(nArray[n]);
                --n;
            }
            DlgConfigFilter.this.mHostList.clearSelection();
        }
    }

    private class AddActionListener
    implements ActionListener {
        private AddActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = DlgConfigFilter.this.mFilterText.getText().trim();
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                String[] stringArray = new String[4];
                stringArray[0] = stringTokenizer.nextToken();
                if (!(stringArray[0].equals("*") || Integer.parseInt(stringArray[0]) >= 0 && Integer.parseInt(stringArray[0]) < 256)) {
                    throw new Exception();
                }
                stringArray[1] = stringTokenizer.nextToken();
                if (!(stringArray[1].equals("*") || Integer.parseInt(stringArray[1]) >= 0 && Integer.parseInt(stringArray[1]) < 256)) {
                    throw new Exception();
                }
                stringArray[2] = stringTokenizer.nextToken();
                if (!(stringArray[2].equals("*") || Integer.parseInt(stringArray[2]) >= 0 && Integer.parseInt(stringArray[2]) < 256)) {
                    throw new Exception();
                }
                stringArray[3] = stringTokenizer.nextToken();
                if (!(stringArray[3].equals("*") || Integer.parseInt(stringArray[3]) >= 0 && Integer.parseInt(stringArray[3]) < 256)) {
                    throw new Exception();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    throw new Exception();
                }
                int n = 0;
                while (n < DlgConfigFilter.this.mHostModel.size()) {
                    if (string.equals(DlgConfigFilter.this.mHostModel.elementAt(n))) {
                        JOptionPane.showMessageDialog(DlgConfigFilter.this.mFrame, "'" + string + "' is already in the list.", "Duplicate Address", 0);
                        DlgConfigFilter.this.mFilterText.requestFocus();
                        return;
                    }
                    ++n;
                }
                DlgConfigFilter.this.mHostModel.addElement(string);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(DlgConfigFilter.this.mFrame, "'" + string + "' is not a valid IP address.", "Invalid Host Address", 0);
                DlgConfigFilter.this.mFilterText.requestFocus();
            }
        }
    }
}

