/*
 * Decompiled with CFR 0.152.
 */
package phex.dialogues;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import phex.BaseFrame;
import phex.ServiceManager;
import phex.gui.common.GUIUtils;

public class DlgConfigProxy
extends JDialog
implements KeyListener {
    private BaseFrame mFrame;
    private boolean mCancel;
    private JTextField mProxyHostText;
    private JTextField mProxyPortText;
    private JCheckBox mAuthentication;
    private JLabel mUsernameLabel;
    private JTextField mProxyUsernameText;
    private JLabel mPasswordLabel;
    private JPasswordField mProxyPassword;

    DlgConfigProxy(BaseFrame baseFrame) {
        super((Frame)baseFrame, true);
        this.mFrame = baseFrame;
        this.setTitle("Enter Socks5 Proxy Server Information");
        this.setDefaultCloseOperation(1);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(20, 20, 6, 20), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(16, 20, 20, 20)));
        this.mAuthentication = new JCheckBox("Authentication", ServiceManager.sCfg.mProxyUserName.length() > 0);
        this.mAuthentication.addActionListener(new AuthenticationHandler());
        JPanel jPanel2 = new JPanel(new GridLayout(5, 1, 10, 0));
        this.mUsernameLabel = new JLabel("Proxy User Name: ");
        this.mPasswordLabel = new JLabel("Proxy Password: ");
        jPanel2.add(new JLabel("Proxy Hostname/IP: "));
        jPanel2.add(new JLabel("Proxy Port: "));
        jPanel2.add(this.mAuthentication);
        jPanel2.add(this.mUsernameLabel);
        jPanel2.add(this.mPasswordLabel);
        JPanel jPanel3 = new JPanel(new GridLayout(5, 1, 0, 6));
        this.mProxyHostText = new JTextField(ServiceManager.sCfg.mProxyHost, 15);
        this.mProxyPortText = new JTextField("" + ServiceManager.sCfg.mProxyPort, 15);
        GUIUtils.setToolTipText(this.mProxyPortText, "My listening port for other to connect to me.  Set to 0 for random port.");
        this.mProxyUsernameText = new JTextField(ServiceManager.sCfg.mProxyUserName, 15);
        this.mProxyPassword = new JPasswordField(ServiceManager.sCfg.mProxyPassword, 15);
        jPanel3.add(this.mProxyHostText);
        jPanel3.add(this.mProxyPortText);
        jPanel3.add(new JLabel(" "));
        jPanel3.add(this.mProxyUsernameText);
        jPanel3.add(this.mProxyPassword);
        jPanel.add("West", jPanel2);
        jPanel.add("Center", jPanel3);
        this.getContentPane().add("Center", jPanel);
        JPanel jPanel4 = new JPanel(new FlowLayout());
        JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("Cancel");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!actionEvent.getActionCommand().equals("Cancel")) {
                    if (!DlgConfigProxy.this.doOk()) {
                        return;
                    }
                } else {
                    DlgConfigProxy.this.mCancel = true;
                }
                ((Component)DlgConfigProxy.this).setVisible(false);
            }
        };
        jButton.addActionListener(actionListener);
        jButton.setMnemonic('O');
        jButton2.addActionListener(actionListener);
        jButton2.setMnemonic('C');
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        this.getContentPane().add("South", jPanel4);
        this.enableUserPassword();
        this.addKeyListener(this);
        this.pack();
        BaseFrame.centerWindow(this, new Point(0, 0));
    }

    private void enableUserPassword() {
        this.mUsernameLabel.setEnabled(this.mAuthentication.isSelected());
        this.mProxyUsernameText.setEnabled(this.mAuthentication.isSelected());
        this.mPasswordLabel.setEnabled(this.mAuthentication.isSelected());
        this.mProxyPassword.setEnabled(this.mAuthentication.isSelected());
    }

    boolean getCancel() {
        return this.mCancel;
    }

    private boolean doOk() {
        int n;
        String string = this.mProxyHostText.getText().trim();
        String string2 = this.mProxyPortText.getText().trim();
        String string3 = this.mProxyUsernameText.getText().trim();
        String string4 = this.mProxyPassword.getText().trim();
        if (!this.mAuthentication.isSelected()) {
            string3 = "";
            string4 = "";
        }
        if (string.length() == 0) {
            JOptionPane.showMessageDialog(this.mFrame, "Please enter the hostname or IP address for the proxy server.", "Invalid Input", 0);
            this.mProxyHostText.requestFocus();
            return false;
        }
        try {
            n = Integer.parseInt(string2);
            if (n < 0) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.mFrame, "Please enter a non-negative integer for the port.", "Invalid Input", 0);
            this.mProxyPortText.requestFocus();
            return false;
        }
        ServiceManager.sCfg.mProxyHost = string;
        ServiceManager.sCfg.mProxyPort = n;
        ServiceManager.sCfg.mProxyUserName = string3;
        ServiceManager.sCfg.mProxyPassword = string4;
        ServiceManager.sCfg.save();
        this.mCancel = false;
        return true;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.mCancel = true;
            ((Component)this).setVisible(false);
        } else if (keyEvent.getKeyCode() == 10) {
            if (!this.doOk()) {
                return;
            }
            this.mCancel = false;
            ((Component)this).setVisible(false);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private class AuthenticationHandler
    implements ActionListener {
        private AuthenticationHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DlgConfigProxy.this.enableUserPassword();
        }
    }
}

