/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.net.Socket;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import phex.GUID;
import phex.download.IDownloadCandidate;
import phex.download.PushRequestSleeper;
import phex.utils.Logger;

public class PushHandler {
    private static PushHandler singleton = new PushHandler();
    private ArrayList pushSleeperList = new ArrayList(5);

    private PushHandler() {
    }

    public static void handleIncommingGIV(Socket socket, GUID gUID, long l, String string) {
        singleton.internalHandleIncommingGIV(socket, gUID, l, string);
    }

    public static Socket requestSocketViaPush(IDownloadCandidate iDownloadCandidate) {
        return singleton.internalRequestSocketViaPush(iDownloadCandidate);
    }

    public static void unregisterPushRequestSleeper(PushRequestSleeper pushRequestSleeper) {
        singleton.internalUnregisterPushRequestSleeper(pushRequestSleeper);
    }

    private void internalHandleIncommingGIV(Socket socket, GUID gUID, long l, String string) {
        Logger.logMessage(Logger.FINER, (short)2, "Handle incomming GIV response: " + l + " - " + string);
        ArrayList arrayList = this.pushSleeperList;
        synchronized (arrayList) {
            Iterator iterator = ((AbstractList)this.pushSleeperList).iterator();
            while (iterator.hasNext()) {
                boolean bl = ((PushRequestSleeper)iterator.next()).acceptGIVConnection(socket, gUID, l, string);
                if (!bl) continue;
                Logger.logMessage(Logger.FINER, (short)2, "Accepted GIV response: " + l + " - " + string);
                return;
            }
        }
        Logger.logMessage(Logger.FINER, (short)2, "No Push request for GIV found: " + l + " - " + string);
    }

    private Socket internalRequestSocketViaPush(IDownloadCandidate iDownloadCandidate) {
        PushRequestSleeper pushRequestSleeper = new PushRequestSleeper(iDownloadCandidate);
        ArrayList arrayList = this.pushSleeperList;
        synchronized (arrayList) {
            this.pushSleeperList.add(pushRequestSleeper);
        }
        Socket socket = pushRequestSleeper.requestSocketViaPush();
        return socket;
    }

    private void internalUnregisterPushRequestSleeper(PushRequestSleeper pushRequestSleeper) {
        ArrayList arrayList = this.pushSleeperList;
        synchronized (arrayList) {
            ((AbstractCollection)this.pushSleeperList).remove(pushRequestSleeper);
        }
    }
}

