/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.actions;

import java.awt.event.ActionEvent;
import phex.MainFrame;
import phex.ServiceManager;
import phex.gui.actions.FWAction;
import phex.gui.common.DesktopIndicator;
import phex.gui.common.GUIRegistry;
import phex.gui.dialogs.CloseOptionsDialog;
import phex.utils.Localizer;

public class CloseGUIAction
extends FWAction {
    public CloseGUIAction() {
        super(Localizer.getString("Close"), GUIRegistry.getInstance().getIconFactory().getIcon("Close"), Localizer.getString("TTTClosePhex"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CloseGUIAction.performCloseGUIAction();
    }

    public static void performCloseGUIAction() {
        if (ServiceManager.sCfg.showCloseOptionsDialog) {
            CloseOptionsDialog closeOptionsDialog = new CloseOptionsDialog();
            closeOptionsDialog.show();
            if (!closeOptionsDialog.isOkActivated()) {
                return;
            }
        }
        if (ServiceManager.sCfg.minimizeToBackground) {
            CloseGUIAction.minimizeToBackground();
        } else {
            CloseGUIAction.shutdown();
        }
    }

    private static void minimizeToBackground() {
        GUIRegistry gUIRegistry = GUIRegistry.getInstance();
        DesktopIndicator desktopIndicator = gUIRegistry.getDesktopIndicator();
        MainFrame mainFrame = gUIRegistry.getMainFrame();
        if (mainFrame.getState() != 1) {
            mainFrame.setState(1);
        }
        if (desktopIndicator != null) {
            desktopIndicator.showIndicator();
            mainFrame.hide();
        }
    }

    public static void shutdown() {
        ServiceManager.getHostManager().saveHostsContainer();
        ServiceManager.getSwarmingManager().saveDownloadList();
        ServiceManager.getShareManager().getFileAdministration().saveSharedLibrary();
        GUIRegistry gUIRegistry = GUIRegistry.getInstance();
        DesktopIndicator desktopIndicator = gUIRegistry.getDesktopIndicator();
        if (desktopIndicator != null) {
            desktopIndicator.hideIndicator();
            desktopIndicator.removeIndicator();
        }
        gUIRegistry.getMainFrame().saveGUISettings();
        gUIRegistry.getMainFrame().dispose();
        System.exit(0);
    }

    public void refreshActionState() {
    }
}

