/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import phex.gui.actions.FWAction;

public class FWToolBar
extends JToolBar {
    private static final Insets buttonInsets = new Insets(0, 0, 0, 0);
    private boolean isTextShown;

    public FWToolBar(int n) {
        super(n);
        this.putClientProperty("JToolBar.isRollover", new Boolean(true));
        this.isTextShown = true;
    }

    public void setShowText(boolean bl) {
        this.isTextShown = bl;
    }

    public AbstractButton addAction(FWAction fWAction) {
        return this.addAction((Action)fWAction);
    }

    public AbstractButton addAction(Action action) {
        JButton jButton = new JButton();
        Icon icon = (Icon)action.getValue("MediumIcon");
        if (icon == null) {
            icon = (Icon)action.getValue("SmallIcon");
        }
        jButton.setIcon(icon);
        jButton.setHorizontalTextPosition(4);
        jButton.setVerticalTextPosition(3);
        jButton.setEnabled(action.isEnabled());
        jButton.addActionListener(action);
        this.registerActionChangeListener(jButton, action);
        jButton.setToolTipText((String)action.getValue("ToolTipText"));
        if (this.isTextShown) {
            jButton.setText((String)action.getValue("Name"));
        }
        jButton.setRequestFocusEnabled(false);
        jButton.setMargin(buttonInsets);
        this.add(jButton);
        return jButton;
    }

    private void registerActionChangeListener(AbstractButton abstractButton, Action action) {
        ActionChangedListener actionChangedListener = new ActionChangedListener(abstractButton);
        action.addPropertyChangeListener(actionChangedListener);
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        AbstractButton button;

        ActionChangedListener(AbstractButton abstractButton) {
            this.button = abstractButton;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.button.setText(string2);
                this.button.repaint();
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.button.setEnabled(bl);
                this.button.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals("MediumIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this.button.setIcon(icon);
                this.button.invalidate();
                this.button.repaint();
            }
        }
    }
}

