/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.util.HashMap;
import phex.MainFrame;
import phex.ServiceManager;
import phex.SplashWindow;
import phex.gui.actions.CloseGUIAction;
import phex.gui.actions.DisconnectNetworkAction;
import phex.gui.actions.FWAction;
import phex.gui.common.DesktopIndicator;
import phex.gui.common.GUIRegistryConstants;
import phex.gui.common.IconFactory;
import phex.gui.common.LazyEventQueue;
import phex.gui.common.TableUpdateService;
import phex.utils.Logger;

public class GUIRegistry
implements GUIRegistryConstants {
    private static GUIRegistry instance = new GUIRegistry();
    private HashMap globalActionMap;
    private LazyEventQueue lazyEventQueue;
    private TableUpdateService tableUpdateService;
    private DesktopIndicator desktopIndicator;
    private IconFactory iconFactory;
    private MainFrame mainFrame;

    private GUIRegistry() {
    }

    public static GUIRegistry getInstance() {
        return instance;
    }

    public void initialize() {
        SplashWindow splashWindow = new SplashWindow();
        this.iconFactory = new IconFactory("phex.gui.resources.Icons");
        if (ServiceManager.isWindows()) {
            try {
                this.desktopIndicator = new DesktopIndicator();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.desktopIndicator = null;
            }
        }
        this.initializeGlobalActions();
        this.mainFrame = new MainFrame(splashWindow);
        Logger.logMessage(Logger.FINE, (short)32, "GUIRegistry initialized.");
    }

    public DesktopIndicator getDesktopIndicator() {
        return this.desktopIndicator;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public IconFactory getIconFactory() {
        return this.iconFactory;
    }

    public LazyEventQueue getLazyEventQueue() {
        if (this.lazyEventQueue == null) {
            this.lazyEventQueue = new LazyEventQueue();
        }
        return this.lazyEventQueue;
    }

    public TableUpdateService getTableUpdateService() {
        if (this.tableUpdateService == null) {
            this.tableUpdateService = new TableUpdateService();
        }
        return this.tableUpdateService;
    }

    public FWAction getGlobalAction(String string) {
        return (FWAction)this.globalActionMap.get(string);
    }

    private void initializeGlobalActions() {
        this.globalActionMap = new HashMap(2);
        FWAction fWAction = new CloseGUIAction();
        this.globalActionMap.put("CloseGUIAction", fWAction);
        fWAction = new DisconnectNetworkAction();
        this.globalActionMap.put("DisconnectNetworkAction", fWAction);
    }
}

