/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import phex.ServiceManager;
import phex.download.swarming.SwarmingManager;
import phex.event.DownloadFilesChangeListener;
import phex.event.NetworkHostsChangeListener;
import phex.event.UploadFilesChangeListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.IconFactory;
import phex.host.HostManager;
import phex.interfaces.IDataChangedListener;
import phex.share.UploadFileContainer;
import phex.utils.Localizer;
import phex.utils.StatisticTracker;

public class StatusBar
extends JPanel {
    private HostManager hostMgr;
    private SwarmingManager swarmingMgr;
    private StatisticTracker statTracker;
    private UploadFileContainer uploadContainer;
    private JLabel statusLabel;
    private Icon connectedIcon;
    private Icon disconnectedIcon;

    public StatusBar() {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusLabel = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.statusLabel, gridBagConstraints);
        IconFactory iconFactory = GUIRegistry.getInstance().getIconFactory();
        this.connectedIcon = iconFactory.getIcon("Network");
        this.disconnectedIcon = iconFactory.getIcon("Disconnect");
        this.hostMgr = ServiceManager.getHostManager();
        this.swarmingMgr = ServiceManager.getSwarmingManager();
        this.statTracker = ServiceManager.getStatisticTracker();
        this.uploadContainer = ServiceManager.getShareManager().getUploadFileContainer();
        this.updateStatusBar();
        StatusChangedListener statusChangedListener = new StatusChangedListener();
        this.hostMgr.addNetworkHostsChangeListener(statusChangedListener);
        this.uploadContainer.addUploadFilesChangeListener(statusChangedListener);
        this.swarmingMgr.addDownloadFilesChangeListener(statusChangedListener);
        this.statTracker.addStatusChangedListener(statusChangedListener);
    }

    private void updateStatusBar() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = StatusBar.this.hostMgr.getConnectedHostCount();
                if (n > 0) {
                    StatusBar.this.statusLabel.setIcon(StatusBar.this.connectedIcon);
                } else {
                    StatusBar.this.statusLabel.setIcon(StatusBar.this.disconnectedIcon);
                }
                Object[] objectArray = new Object[]{new Integer(n), new Integer(StatusBar.this.uploadContainer.getUploadFileCount()), new Integer(StatusBar.this.statTracker.getStatUploadCount()), new Integer(StatusBar.this.swarmingMgr.getDownloadFileCount(2)), new Integer(StatusBar.this.swarmingMgr.getDownloadFileCount()), new Integer(StatusBar.this.statTracker.getStatDownloadCount())};
                String string = Localizer.getFormatedString("StatusBarInfo", objectArray);
                StatusBar.this.statusLabel.setText(string);
                StatusBar.this.setPreferredSize(new Dimension(((StatusBar)StatusBar.this).statusLabel.getPreferredSize().width, ((StatusBar)StatusBar.this).statusLabel.getPreferredSize().height + 6));
            }
        });
    }

    private class StatusChangedListener
    implements IDataChangedListener,
    DownloadFilesChangeListener,
    UploadFilesChangeListener,
    NetworkHostsChangeListener {
        private StatusChangedListener() {
        }

        public void dataChanged(Object object) {
            StatusBar.this.updateStatusBar();
        }

        public void networkHostChanged(int n) {
            StatusBar.this.updateStatusBar();
        }

        public void networkHostAdded(int n) {
            StatusBar.this.updateStatusBar();
        }

        public void networkHostRemoved(int n) {
            StatusBar.this.updateStatusBar();
        }

        public void uploadFileChanged(int n) {
            StatusBar.this.updateStatusBar();
        }

        public void uploadFileAdded(int n) {
            StatusBar.this.updateStatusBar();
        }

        public void uploadFileRemoved(int n) {
            StatusBar.this.updateStatusBar();
        }

        public void downloadFileChanged(int n) {
            StatusBar.this.updateStatusBar();
        }

        public void downloadFileAdded(int n) {
            StatusBar.this.updateStatusBar();
        }

        public void downloadFileRemoved(int n) {
            StatusBar.this.updateStatusBar();
        }
    }
}

