/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import phex.ServiceManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.MultiLinePanel;
import phex.utils.Localizer;

public class CloseOptionsDialog
extends JDialog {
    private JRadioButton minimizeToBackgroundRBtn;
    private JRadioButton shutdownRBtn;
    private JCheckBox dontDisplayAgainChkBox;
    private boolean isOkActivated = false;

    public CloseOptionsDialog() {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("CloseOptions"), true);
        this.prepareComponent();
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CloseOptionsDialog.this.closeDialog(false);
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        gridBagConstraints.anchor = 10;
        container.add((Component)jPanel, gridBagConstraints);
        MultiLinePanel multiLinePanel = new MultiLinePanel(Localizer.getString("CloseOptionsText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)multiLinePanel, gridBagConstraints);
        String string = GUIRegistry.getInstance().getDesktopIndicator() != null ? Localizer.getString("MinimizeToSysTray") : Localizer.getString("MinimizeToBackground");
        this.minimizeToBackgroundRBtn = new JRadioButton(string, ServiceManager.sCfg.minimizeToBackground);
        Font font = this.minimizeToBackgroundRBtn.getFont();
        Font font2 = font.deriveFont(1, font.getSize() + 1);
        this.minimizeToBackgroundRBtn.setFont(font2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.minimizeToBackgroundRBtn, gridBagConstraints);
        this.shutdownRBtn = new JRadioButton(Localizer.getString("Shutdown"), !ServiceManager.sCfg.minimizeToBackground);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.shutdownRBtn, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.minimizeToBackgroundRBtn);
        buttonGroup.add(this.shutdownRBtn);
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        container.add((Component)jSeparator, gridBagConstraints);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        container.add((Component)jPanel, gridBagConstraints);
        this.dontDisplayAgainChkBox = new JCheckBox(Localizer.getString("DontAskAnymore"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.dontDisplayAgainChkBox, gridBagConstraints);
        ButtonActionHandler buttonActionHandler = new ButtonActionHandler();
        JButton jButton = new JButton(Localizer.getString("OK"));
        jButton.setDefaultCapable(true);
        jButton.setRequestFocusEnabled(true);
        jButton.addActionListener(buttonActionHandler);
        jButton.setActionCommand("OK");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton(Localizer.getString("Cancel"));
        jButton2.setRequestFocusEnabled(true);
        jButton2.addActionListener(buttonActionHandler);
        jButton2.setActionCommand("CANCEL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jButton2, gridBagConstraints);
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(jButton);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !this.dontDisplayAgainChkBox.isSelected();
        if (bl2 != ServiceManager.sCfg.showCloseOptionsDialog) {
            ServiceManager.sCfg.showCloseOptionsDialog = bl2;
            bl = true;
        }
        if (bl) {
            ServiceManager.sCfg.save();
        }
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public boolean isOkActivated() {
        return this.isOkActivated;
    }

    private class ButtonActionHandler
    implements ActionListener {
        private ButtonActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            if (actionEvent.getActionCommand().equals("OK")) {
                boolean bl2 = CloseOptionsDialog.this.minimizeToBackgroundRBtn.isSelected();
                if (bl2 != ServiceManager.sCfg.minimizeToBackground) {
                    ServiceManager.sCfg.minimizeToBackground = bl2;
                    bl = true;
                }
                CloseOptionsDialog.this.isOkActivated = true;
            }
            CloseOptionsDialog.this.closeDialog(bl);
        }
    }
}

