/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import phex.MainFrame;
import phex.ServiceManager;
import phex.common.FileHandlingException;
import phex.config.Cfg;
import phex.download.IDownloadFile;
import phex.download.RemoteFile;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.utils.FileUtils;
import phex.utils.Localizer;
import phex.utils.StrUtil;

public class DownloadConfigDialog
extends JDialog {
    private JTextField filenameTF;
    private JCheckBox renameOldFileCBx;
    private JTextField researchTermTF;
    private JCheckBox switchToDownldCBx;
    private RemoteFile remoteFile;
    private IDownloadFile downloadFile;

    private DownloadConfigDialog() {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("DownloadConfiguration"), true);
    }

    public DownloadConfigDialog(RemoteFile remoteFile) {
        this();
        this.remoteFile = remoteFile;
        this.prepareComponent();
    }

    public DownloadConfigDialog(IDownloadFile iDownloadFile) {
        this();
        this.downloadFile = iDownloadFile;
        this.prepareComponent();
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DownloadConfigDialog.this.closeDialog();
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        container.add((Component)jPanel, gridBagConstraints);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Localizer.getString("File"));
        stringBuffer.append(":  ");
        if (this.remoteFile != null) {
            stringBuffer.append(this.remoteFile.getFilename());
        } else if (this.downloadFile != null) {
            stringBuffer.append(this.downloadFile.getDestinationFileName());
        }
        JLabel jLabel = new JLabel(stringBuffer.toString());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jLabel, gridBagConstraints);
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(Localizer.getString("FileSize"));
        stringBuffer2.append(":  ");
        if (this.remoteFile != null) {
            stringBuffer2.append(this.remoteFile.getFileSizeObject());
        } else if (this.downloadFile != null) {
            stringBuffer2.append(this.downloadFile.getTotalDataSize());
        }
        stringBuffer2.append(' ');
        stringBuffer2.append(Localizer.getString("Bytes"));
        jLabel = new JLabel(stringBuffer2.toString());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jSeparator, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("LocalFileName") + ":  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        String string = null;
        if (this.remoteFile != null) {
            string = this.remoteFile.getFilename();
        } else if (this.downloadFile != null) {
            string = this.downloadFile.getDestinationFileName();
        }
        this.filenameTF = new JTextField(string, 30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.filenameTF, gridBagConstraints);
        if (this.downloadFile != null) {
            this.renameOldFileCBx = new JCheckBox(Localizer.getString("RenameFile"));
            this.renameOldFileCBx.setSelected(true);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 12;
            jPanel2.add((Component)this.renameOldFileCBx, gridBagConstraints);
        }
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("ResearchTerm") + ":  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        String string2 = null;
        if (this.remoteFile != null) {
            string2 = StrUtil.createNaturalSearchTerm(this.remoteFile.getShortname());
        } else if (this.downloadFile != null) {
            string2 = this.downloadFile.getResearchSetting().getSearchTerm();
        }
        this.researchTermTF = new JTextField(string2, 30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.researchTermTF, gridBagConstraints);
        if (this.remoteFile != null) {
            this.switchToDownldCBx = new JCheckBox(Localizer.getString("SwitchToDownloadTab"));
            this.switchToDownldCBx.setSelected(true);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(3, 0, 3, 0);
            jPanel.add((Component)this.switchToDownldCBx, gridBagConstraints);
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 14;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        jSeparator = new JSeparator();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)jSeparator, gridBagConstraints);
        String string3 = null;
        if (this.remoteFile != null) {
            string3 = Localizer.getString("Download");
        } else if (this.downloadFile != null) {
            string3 = Localizer.getString("Change");
        }
        JButton jButton = new JButton(string3);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DownloadConfigDialog.this.isInputValidAndUpdated()) {
                    DownloadConfigDialog.this.closeDialogAfterDownload();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        jPanel3.add((Component)jButton, gridBagConstraints);
        jButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(jButton);
        JButton jButton2 = new JButton(Localizer.getString("Cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DownloadConfigDialog.this.closeDialog();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        jPanel3.add((Component)jButton2, gridBagConstraints);
        this.pack();
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(GUIRegistry.getInstance().getMainFrame());
    }

    private boolean isInputValidAndUpdated() {
        String string = this.filenameTF.getText().trim();
        if (string.length() == 0) {
            GUIUtils.showErrorMessage(this, Localizer.getString("NoFileName"));
            this.filenameTF.requestFocus();
            return false;
        }
        String string2 = this.researchTermTF.getText().trim();
        if (string2.length() < Cfg.MIN_SEARCH_TERM_LENGTH) {
            Object[] objectArray = new Object[]{new Integer(Cfg.MIN_SEARCH_TERM_LENGTH)};
            GUIUtils.showErrorMessage(this, Localizer.getFormatedString("MinSearchTerm", objectArray));
            this.researchTermTF.requestFocus();
            return false;
        }
        if (this.remoteFile != null) {
            ServiceManager.getSwarmingManager().addFileToDownload(this.remoteFile, ServiceManager.sCfg.mDownloadDir + File.separator + FileUtils.convertToLocalSystemFilename(string), string2);
            this.remoteFile.setInDownloadQueue(true);
        } else if (this.downloadFile != null) {
            if (!this.downloadFile.getDestinationFileName().equals(string)) {
                boolean bl = this.renameOldFileCBx.isSelected();
                try {
                    File file = new File(ServiceManager.sCfg.mDownloadDir + File.separator + FileUtils.convertToLocalSystemFilename(string));
                    this.downloadFile.setDestinationFile(file, bl);
                }
                catch (FileHandlingException fileHandlingException) {
                    if (fileHandlingException.getType() == 1) {
                        Object[] objectArray = new Object[]{string};
                        GUIUtils.showErrorMessage(this, Localizer.getFormatedString("FileAlreadyExists", objectArray));
                    }
                    if (fileHandlingException.getType() == 0) {
                        GUIUtils.showErrorMessage(this, Localizer.getString("FileRenameFailed"));
                    }
                    fileHandlingException.printStackTrace();
                }
            }
            this.downloadFile.getResearchSetting().setSearchTerm(string2);
        }
        return true;
    }

    private void closeDialogAfterDownload() {
        MainFrame mainFrame = GUIRegistry.getInstance().getMainFrame();
        if (this.remoteFile != null && this.switchToDownldCBx.isSelected()) {
            mainFrame.setSelectedTab(3);
        }
        this.closeDialog();
    }

    private void closeDialog() {
        ((Component)this).setVisible(false);
        this.dispose();
    }
}

