/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import phex.ServiceManager;
import phex.gui.common.GUIUtils;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;

public class NetworkPane
extends OptionsSettingsPane {
    private static final String LISTENING_PORT_KEY = "ListeningPort";
    private static final String MY_TTL_KEY = "MyTTL";
    private static final String MAX_TTL_KEY = "MaxTTL";
    private static final String MIN_CONNECTIONS_KEY = "MinConnections";
    private static final String MAX_CONNECTIONS_KEY = "MaxConnections";
    private static final String CONNECTION_TIMEOUT_KEY = "ConnectionTimeout";
    private static final String PING_FREQUENCY_KEY = "PingFrequency";
    private static final String PING_TIMEOUT_KEY = "PingTimeout";
    private IntegerTextField listeningPortTF;
    private IntegerTextField myTTLTF;
    private IntegerTextField maxTTLTF;
    private IntegerTextField minConnectionsTF;
    private IntegerTextField maxConnectionsTF;
    private IntegerTextField connectionTimeoutTF;
    private IntegerTextField pingFrequencyTF;
    private IntegerTextField pingTimeoutTF;
    private JCheckBox connectedToLANChkbx;

    public NetworkPane() {
        super("Network");
    }

    protected void prepareComponent() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("NetworkSettings")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JLabel jLabel = new JLabel(Localizer.getString(LISTENING_PORT_KEY) + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.listeningPortTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mListeningPort), 5, 5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.listeningPortTF, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString(MY_TTL_KEY) + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.myTTLTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mNetTTL), 2, 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.myTTLTF, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString(MAX_TTL_KEY) + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 20, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.maxTTLTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mNetMaxTTL), 2, 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.maxTTLTF, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString(MIN_CONNECTIONS_KEY) + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.minConnectionsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mNetMinConn), 2, 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.minConnectionsTF, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString(MAX_CONNECTIONS_KEY) + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 20, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.maxConnectionsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mNetMaxConnection), 2, 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.maxConnectionsTF, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString(PING_FREQUENCY_KEY) + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.pingFrequencyTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mPingFrequency / 1000), 2, 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.pingFrequencyTF, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString(PING_TIMEOUT_KEY) + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 20, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.pingTimeoutTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mPingTimeout / 1000), 2, 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.pingTimeoutTF, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString(CONNECTION_TIMEOUT_KEY) + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.connectionTimeoutTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mNetConnectionTimeout / 1000), 3, 3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.connectionTimeoutTF, gridBagConstraints);
        this.connectedToLANChkbx = new JCheckBox(Localizer.getString("ConnectedToLAN"), ServiceManager.sCfg.connectedToLAN);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.connectedToLANChkbx, gridBagConstraints);
    }

    public void checkInput(HashMap hashMap) {
        Integer n;
        String string;
        try {
            string = this.listeningPortTF.getText();
            n = new Integer(string);
            hashMap.put(LISTENING_PORT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.listeningPortTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.myTTLTF.getText();
            n = new Integer(string);
            hashMap.put(MY_TTL_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.myTTLTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.maxTTLTF.getText();
            n = new Integer(string);
            hashMap.put(MAX_TTL_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.maxTTLTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.minConnectionsTF.getText();
            n = new Integer(string);
            hashMap.put(MIN_CONNECTIONS_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.minConnectionsTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.maxConnectionsTF.getText();
            n = new Integer(string);
            hashMap.put(MAX_CONNECTIONS_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.maxConnectionsTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.connectionTimeoutTF.getText();
            n = new Integer(string);
            hashMap.put(CONNECTION_TIMEOUT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.connectionTimeoutTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.pingFrequencyTF.getText();
            n = new Integer(string);
            hashMap.put(PING_FREQUENCY_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.pingFrequencyTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.pingTimeoutTF.getText();
            n = new Integer(string);
            hashMap.put(PING_TIMEOUT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.pingTimeoutTF);
            this.setInputValid(hashMap, false);
            return;
        }
        this.setInputValid(hashMap, true);
    }

    public void displayErrorMessage(HashMap hashMap) {
        if (hashMap.containsKey("NumberFormatError")) {
            this.displayNumberFormatError(hashMap);
        }
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        boolean bl;
        Integer n;
        int n2;
        Integer n3;
        int n4;
        Integer n5;
        int n6;
        Integer n7;
        int n8;
        Integer n9;
        int n10;
        Integer n11;
        int n12;
        Integer n13;
        int n14;
        Integer n15 = (Integer)hashMap.get(LISTENING_PORT_KEY);
        int n16 = n15;
        if (ServiceManager.sCfg.mListeningPort != n16) {
            ServiceManager.sCfg.mListeningPort = n16;
            OptionsSettingsPane.triggerConfigSave(hashMap);
            ServiceManager.getListener().shutdown(true);
            try {
                ServiceManager.getListener().startup();
            }
            catch (Exception exception) {
                GUIUtils.showErrorMessage(Localizer.getString("FailedToListenOnNewPort"), Localizer.getString("ListenerError"));
            }
        }
        if (ServiceManager.sCfg.mNetTTL != (n14 = (n13 = (Integer)hashMap.get(MY_TTL_KEY)).intValue())) {
            ServiceManager.sCfg.mNetTTL = n14;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mNetMaxTTL != (n12 = (n11 = (Integer)hashMap.get(MAX_TTL_KEY)).intValue())) {
            ServiceManager.sCfg.mNetMaxTTL = n12;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mNetMinConn != (n10 = (n9 = (Integer)hashMap.get(MIN_CONNECTIONS_KEY)).intValue())) {
            ServiceManager.sCfg.mNetMinConn = n10;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mNetMaxConnection != (n8 = (n7 = (Integer)hashMap.get(MAX_CONNECTIONS_KEY)).intValue())) {
            ServiceManager.sCfg.mNetMaxConnection = n8;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mNetConnectionTimeout != (n6 = (n5 = (Integer)hashMap.get(CONNECTION_TIMEOUT_KEY)) * 1000)) {
            ServiceManager.sCfg.mNetConnectionTimeout = n6;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mPingFrequency != (n4 = (n3 = (Integer)hashMap.get(PING_FREQUENCY_KEY)) * 1000)) {
            ServiceManager.sCfg.mPingFrequency = n4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mPingTimeout != (n2 = (n = (Integer)hashMap.get(PING_TIMEOUT_KEY)) * 1000)) {
            ServiceManager.sCfg.mPingTimeout = n2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.connectedToLAN != (bl = this.connectedToLANChkbx.isSelected())) {
            ServiceManager.sCfg.connectedToLAN = bl;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
    }
}

