/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import phex.ServiceManager;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadInfo;
import phex.download.swarming.SwarmingManager;
import phex.event.DownloadFilesChangeListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.LazyEventQueue;
import phex.gui.comparator.TransferRateComparator;
import phex.gui.comparator.TransferSizeComparator;
import phex.gui.models.FWTableModel;
import phex.utils.Localizer;

public class SWDownloadTableModel
extends FWTableModel {
    private static final int FILE_COLUMN_ID = 1001;
    private static final int PROGRESS_COLUMN_ID = 1002;
    private static final int SIZE_COLUMN_ID = 1003;
    private static final int RATE_COLUMN_ID = 1004;
    private static final int STATUS_COLUMN_ID = 1005;
    private static final int CANDIDATE_COUNT_COLUMN_ID = 1006;
    private static final int SEARCH_TERM_COLUMN_ID = 1007;
    private static final int SHA1_COLUMN_ID = 1008;
    private static final int FILE_MODEL_INDEX = 0;
    private static final int PROGRESS_MODEL_INDEX = 1;
    private static final int SIZE_MODEL_INDEX = 2;
    private static final int RATE_MODEL_INDEX = 3;
    private static final int CANDIDATE_COUNT_MODEL_INDEX = 4;
    private static final int STATUS_MODEL_INDEX = 5;
    private static final int SEARCH_TERM_MODEL_INDEX = 6;
    private static final int SHA1_MODEL_INDEX = 7;
    private static String[] tableColumns = new String[]{Localizer.getString("File"), Localizer.getString("PercentSign"), Localizer.getString("Size"), Localizer.getString("Rate"), Localizer.getString("NumberOfCandidates"), Localizer.getString("Status"), Localizer.getString("SearchTerm"), Localizer.getString("SHA1")};
    private static Class[] tableClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SWDownloadTableModel.class$("java.lang.String")) : class$java$lang$String, class$phex$gui$renderer$ProgressCellRenderer == null ? (class$phex$gui$renderer$ProgressCellRenderer = SWDownloadTableModel.class$("phex.gui.renderer.ProgressCellRenderer")) : class$phex$gui$renderer$ProgressCellRenderer, class$phex$gui$renderer$TransferSizeCellRenderer == null ? (class$phex$gui$renderer$TransferSizeCellRenderer = SWDownloadTableModel.class$("phex.gui.renderer.TransferSizeCellRenderer")) : class$phex$gui$renderer$TransferSizeCellRenderer, class$phex$gui$renderer$TransferRateCellRenderer == null ? (class$phex$gui$renderer$TransferRateCellRenderer = SWDownloadTableModel.class$("phex.gui.renderer.TransferRateCellRenderer")) : class$phex$gui$renderer$TransferRateCellRenderer, class$java$lang$Integer == null ? (class$java$lang$Integer = SWDownloadTableModel.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$String == null ? (class$java$lang$String = SWDownloadTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SWDownloadTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SWDownloadTableModel.class$("java.lang.String")) : class$java$lang$String};
    private SwarmingManager swarmingMgr = ServiceManager.getSwarmingManager();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$phex$gui$renderer$ProgressCellRenderer;
    static /* synthetic */ Class class$phex$gui$renderer$TransferSizeCellRenderer;
    static /* synthetic */ Class class$phex$gui$renderer$TransferRateCellRenderer;
    static /* synthetic */ Class class$java$lang$Integer;

    public SWDownloadTableModel() {
        super(tableColumns, tableClasses);
        this.swarmingMgr.addDownloadFilesChangeListener(new DownloadFilesListener());
    }

    public int getRowCount() {
        return this.swarmingMgr.getDownloadFileCount();
    }

    public Object getValueAt(int n, int n2) {
        SWDownloadFile sWDownloadFile = this.swarmingMgr.getDownloadFile(n);
        if (sWDownloadFile == null) {
            this.fireTableRowsDeleted(n, n);
            return "";
        }
        switch (n2) {
            case 0: {
                return sWDownloadFile.getDestinationFile().getName();
            }
            case 1: {
                return sWDownloadFile.getProgress();
            }
            case 2: 
            case 3: {
                return sWDownloadFile;
            }
            case 4: {
                return sWDownloadFile.getCandidateCountObject();
            }
            case 5: {
                return SWDownloadInfo.getDownloadFileStatusString(sWDownloadFile.getStatus());
            }
            case 6: {
                return sWDownloadFile.getResearchSetting().getSearchTerm();
            }
            case 7: {
                return sWDownloadFile.getResearchSetting().getSHA1();
            }
        }
        return "";
    }

    public Comparator getColumnComparator(int n) {
        switch (n) {
            case 2: {
                return new TransferSizeComparator();
            }
            case 3: {
                return new TransferRateComparator();
            }
        }
        return null;
    }

    public int mapColumnIDToModelIndex(int n) {
        switch (n) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1004: {
                return 3;
            }
            case 1006: {
                return 4;
            }
            case 1005: {
                return 5;
            }
            case 1007: {
                return 6;
            }
            case 1008: {
                return 7;
            }
        }
        return -1;
    }

    public boolean isColumnHideable(int n) {
        return n != 1001;
    }

    public static int[] getColumnIdArray() {
        int[] nArray = new int[]{1001, 1002, 1003, 1004, 1006, 1005, 1007, 1008};
        return nArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DownloadFilesListener
    implements DownloadFilesChangeListener {
        private LazyEventQueue lazyEventQueue = GUIRegistry.getInstance().getLazyEventQueue();

        public void downloadFileChanged(int n) {
            this.lazyEventQueue.addTableModelEvent(new TableModelEvent(SWDownloadTableModel.this, n, n, -1, 0));
        }

        public void downloadFileAdded(int n) {
            SWDownloadTableModel.this.fireTableChanged(new TableModelEvent(SWDownloadTableModel.this, n, n, -1, 1));
        }

        public void downloadFileRemoved(int n) {
            SWDownloadTableModel.this.fireTableChanged(new TableModelEvent(SWDownloadTableModel.this, n, n, -1, -1));
        }
    }
}

