/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import java.util.Comparator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import phex.ServiceManager;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SwarmingManager;
import phex.event.DownloadSegmentsChangeListener;
import phex.gui.common.FWTable;
import phex.gui.common.GUIRegistry;
import phex.gui.common.LazyEventQueue;
import phex.gui.comparator.TransferRateComparator;
import phex.gui.comparator.TransferSizeComparator;
import phex.gui.models.FWTableModel;
import phex.utils.Localizer;

public class SWSegmentTableModel
extends FWTableModel {
    public static final int FROM_COLUMN_ID = 1001;
    public static final int PROGRESS_COLUMN_ID = 1002;
    public static final int SIZE_COLUMN_ID = 1003;
    public static final int RATE_COLUMN_ID = 1004;
    public static final int FROM_MODEL_INDEX = 0;
    public static final int PROGRESS_MODEL_INDEX = 1;
    public static final int SIZE_MODEL_INDEX = 2;
    public static final int RATE_MODEL_INDEX = 3;
    private static String[] tableColumns = new String[]{Localizer.getString("From"), Localizer.getString("PercentSign"), Localizer.getString("Size"), Localizer.getString("Rate")};
    private static Class[] tableClasses = new Class[]{class$java$lang$Long == null ? (class$java$lang$Long = SWSegmentTableModel.class$("java.lang.Long")) : class$java$lang$Long, class$phex$gui$renderer$ProgressCellRenderer == null ? (class$phex$gui$renderer$ProgressCellRenderer = SWSegmentTableModel.class$("phex.gui.renderer.ProgressCellRenderer")) : class$phex$gui$renderer$ProgressCellRenderer, class$phex$gui$renderer$TransferSizeCellRenderer == null ? (class$phex$gui$renderer$TransferSizeCellRenderer = SWSegmentTableModel.class$("phex.gui.renderer.TransferSizeCellRenderer")) : class$phex$gui$renderer$TransferSizeCellRenderer, class$phex$gui$renderer$TransferRateCellRenderer == null ? (class$phex$gui$renderer$TransferRateCellRenderer = SWSegmentTableModel.class$("phex.gui.renderer.TransferRateCellRenderer")) : class$phex$gui$renderer$TransferRateCellRenderer};
    private SwarmingManager swarmingMgr = ServiceManager.getSwarmingManager();
    private SWDownloadFile downloadFile;
    private FWTable downloadTable;
    private DownloadSegmentsListener changeListener;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$phex$gui$renderer$ProgressCellRenderer;
    static /* synthetic */ Class class$phex$gui$renderer$TransferSizeCellRenderer;
    static /* synthetic */ Class class$phex$gui$renderer$TransferRateCellRenderer;

    public SWSegmentTableModel(FWTable fWTable) {
        super(tableColumns, tableClasses);
        this.downloadTable = fWTable;
        this.downloadTable.getSelectionModel().addListSelectionListener(new DownloadSelectionChangeHandler());
        this.changeListener = new DownloadSegmentsListener();
    }

    public int getRowCount() {
        if (this.downloadFile == null) {
            return 0;
        }
        return this.downloadFile.getSegmentCount();
    }

    public Object getValueAt(int n, int n2) {
        SWDownloadSegment sWDownloadSegment = this.downloadFile.getSegment(n);
        if (sWDownloadSegment == null) {
            this.fireTableRowsDeleted(n, n);
            return "";
        }
        switch (n2) {
            case 0: {
                return sWDownloadSegment.getStartPositionObject();
            }
            case 1: {
                return sWDownloadSegment.getProgress();
            }
            case 2: 
            case 3: {
                return sWDownloadSegment;
            }
        }
        return "";
    }

    public Comparator getColumnComparator(int n) {
        switch (n) {
            case 2: {
                return new TransferSizeComparator();
            }
            case 3: {
                return new TransferRateComparator();
            }
        }
        return null;
    }

    public int mapColumnIDToModelIndex(int n) {
        switch (n) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1004: {
                return 3;
            }
        }
        return -1;
    }

    public boolean isColumnHideable(int n) {
        return n != 1002;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DownloadSegmentsListener
    implements DownloadSegmentsChangeListener {
        private LazyEventQueue lazyEventQueue = GUIRegistry.getInstance().getLazyEventQueue();

        public void downloadSegmentChanged(int n) {
            this.lazyEventQueue.addTableModelEvent(new TableModelEvent(SWSegmentTableModel.this, n, n, -1, 0));
        }

        public void downloadSegmentAdded(int n) {
            SWSegmentTableModel.this.fireTableChanged(new TableModelEvent(SWSegmentTableModel.this, n, n, -1, 1));
        }

        public void downloadSegmentRemoved(int n) {
            SWSegmentTableModel.this.fireTableChanged(new TableModelEvent(SWSegmentTableModel.this, n, n, -1, -1));
        }
    }

    private class DownloadSelectionChangeHandler
    implements ListSelectionListener {
        private DownloadSelectionChangeHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                int n = listSelectionModel.getLeadSelectionIndex();
                int n2 = SWSegmentTableModel.this.downloadTable.convertRowIndexToModel(n);
                SWDownloadFile sWDownloadFile = SWSegmentTableModel.this.swarmingMgr.getDownloadFile(n2);
                if (sWDownloadFile != SWSegmentTableModel.this.downloadFile) {
                    if (SWSegmentTableModel.this.downloadFile != null) {
                        SWSegmentTableModel.this.downloadFile.removeDownloadSegmentChangeListener(SWSegmentTableModel.this.changeListener);
                    }
                    SWSegmentTableModel.this.downloadFile = sWDownloadFile;
                    if (SWSegmentTableModel.this.downloadFile != null) {
                        SWSegmentTableModel.this.downloadFile.addDownloadSegmentChangeListener(SWSegmentTableModel.this.changeListener);
                    }
                    SWSegmentTableModel.this.fireTableDataChanged();
                }
            }
        }
    }
}

