/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import phex.MainFrame;
import phex.ServiceManager;
import phex.event.SharedFilesChangeListener;
import phex.gui.common.FWTable;
import phex.gui.common.GUIUtils;
import phex.gui.models.FWSortedTableModel;
import phex.gui.models.FWTableColumnModel;
import phex.gui.models.SharedFilesTableModel;
import phex.gui.models.UploadFilesTableModel;
import phex.gui.renderer.DefaultPhexCellRenderers;
import phex.share.FileAdministration;
import phex.share.ShareManager;
import phex.share.UploadFile;
import phex.share.UploadFileContainer;
import phex.utils.Localizer;
import phex.utils.StrUtil;
import phex.xml.XMLGUISettings;
import phex.xml.XMLGUITable;
import phex.xml.XMLGUITableColumnList;

public class ShareTab
extends JPanel {
    private static final String UPLOAD_TABLE_IDENTIFIER = "UploadTable";
    private static final String SHARED_FILES_TABLE_IDENTIFIER = "SharedFilesTable";
    private ShareManager mShareMgr;
    private UploadFileContainer uploadContainer;
    private FileAdministration fileAdmin;
    private MainFrame mainFrame;
    private JLabel sharedFilesLabel;
    private FWTable uploadTable;
    private UploadFilesTableModel uploadModel;
    private FWTableColumnModel uploadColumnModel;
    private FWTable sharedFilesTable;
    private SharedFilesTableModel sharedFilesModel;
    private FWTableColumnModel sharedFilesColumnModel;

    public ShareTab(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.mShareMgr = ServiceManager.getShareManager();
        this.fileAdmin = this.mShareMgr.getFileAdministration();
        this.uploadContainer = this.mShareMgr.getUploadFileContainer();
    }

    public void initComponent(XMLGUISettings xMLGUISettings) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.uploadModel = new UploadFilesTableModel();
        XMLGUITable xMLGUITable = GUIUtils.getXMLGUITableByIdentifier(xMLGUISettings, UPLOAD_TABLE_IDENTIFIER);
        this.buildUploadTableColumnModel(xMLGUITable);
        this.uploadTable = new FWTable((TableModel)new FWSortedTableModel(this.uploadModel), this.uploadColumnModel);
        this.uploadTable.activateAllHeaderActions();
        this.uploadTable.setAutoResizeMode(0);
        this.uploadTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        jPanel.add("Center", new JScrollPane(this.uploadTable));
        DefaultPhexCellRenderers.setDefaultPhexCellRenderers(this.uploadTable);
        CellRenderer cellRenderer = new CellRenderer();
        this.uploadColumnModel.getColumn(0).setCellRenderer(cellRenderer);
        this.uploadColumnModel.getColumn(1).setCellRenderer(cellRenderer);
        this.uploadColumnModel.getColumn(2).setCellRenderer(cellRenderer);
        this.uploadColumnModel.getColumn(6).setCellRenderer(cellRenderer);
        GUIUtils.adjustTableProgresssBarHeight(this.uploadTable);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        JButton jButton = new JButton(Localizer.getString("AbortUpload"));
        JButton jButton2 = new JButton(Localizer.getString("ClearCompleted"));
        this.mainFrame.addRefreshComponent("ActionShareAbort", jButton);
        this.mainFrame.addRefreshComponent("ActionShareClear", jButton2);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jButton.addActionListener(new AbortUploadHandler());
        jButton2.addActionListener(new ClearUploadHandler());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("Center", jPanel);
        jPanel3.add("South", jPanel2);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("Uploads")));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.sharedFilesModel = new SharedFilesTableModel();
        xMLGUITable = GUIUtils.getXMLGUITableByIdentifier(xMLGUISettings, SHARED_FILES_TABLE_IDENTIFIER);
        this.buildSharedFilesTableColumnModel(xMLGUITable);
        this.sharedFilesTable = new FWTable((TableModel)new FWSortedTableModel(this.sharedFilesModel), this.sharedFilesColumnModel);
        this.sharedFilesTable.activateAllHeaderActions();
        this.sharedFilesTable.setAutoResizeMode(0);
        this.sharedFilesTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        JPanel jPanel5 = new JPanel(new FlowLayout());
        JButton jButton3 = new JButton(Localizer.getString("Rescan"));
        jPanel5.add(jButton3);
        jButton3.addActionListener(new ShareRescanHandler());
        this.sharedFilesLabel = new JLabel(" ");
        this.sharedFilesLabel.setHorizontalAlignment(4);
        this.fileAdmin.addSharedFilesChangeListener(new SharedFilesChangeHandler());
        jPanel4.add("North", this.sharedFilesLabel);
        jPanel4.add("Center", new JScrollPane(this.sharedFilesTable));
        jPanel4.add("South", jPanel5);
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("SharedFiles")));
        jPanel3.setPreferredSize(new Dimension(780, 230));
        jPanel4.setPreferredSize(new Dimension(780, 200));
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jSplitPane.setDividerSize(6);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setTopComponent(jPanel3);
        jSplitPane.setBottomComponent(jPanel4);
        this.add("Center", jSplitPane);
    }

    public void updateUI() {
        super.updateUI();
        if (this.uploadTable != null) {
            GUIUtils.adjustTableProgresssBarHeight(this.uploadTable);
        }
    }

    public void abortUpload() {
        int n = this.uploadTable.getSelectedRow();
        if (n < 0 || n >= this.uploadContainer.getUploadListSize()) {
            return;
        }
        UploadFile uploadFile = this.uploadContainer.getUploadFileAt(n = this.uploadTable.convertRowIndexToModel(n));
        if (uploadFile == null) {
            return;
        }
        uploadFile.abortUpload();
        this.mainFrame.refreshAllActions();
    }

    public boolean isUploadSelected() {
        return this.mainFrame.isUploadTabSelected() && this.uploadTable.getSelectedRowCount() > 0 && this.uploadContainer.getUploadListSize() > 0;
    }

    public void clearUpload() {
        this.uploadContainer.cleanUploadFileList();
        this.mainFrame.refreshAllActions();
    }

    private void buildUploadTableColumnModel(XMLGUITable xMLGUITable) {
        int[] nArray = new int[]{1001, 1002, 1003, 1004, 1005, 1006, 1007};
        XMLGUITableColumnList xMLGUITableColumnList = null;
        if (xMLGUITable != null) {
            xMLGUITableColumnList = xMLGUITable.getTableColumnList();
        }
        this.uploadColumnModel = new FWTableColumnModel(this.uploadModel, nArray, xMLGUITableColumnList);
    }

    private void buildSharedFilesTableColumnModel(XMLGUITable xMLGUITable) {
        int[] nArray = SharedFilesTableModel.getColumnIdArray();
        XMLGUITableColumnList xMLGUITableColumnList = null;
        if (xMLGUITable != null) {
            xMLGUITableColumnList = xMLGUITable.getTableColumnList();
        }
        this.sharedFilesColumnModel = new FWTableColumnModel(this.sharedFilesModel, nArray, xMLGUITableColumnList);
    }

    public void appendXMLGUISettings(XMLGUISettings xMLGUISettings) {
        XMLGUITableColumnList xMLGUITableColumnList = this.uploadColumnModel.createXMLGUITableColumnList();
        XMLGUITable xMLGUITable = new XMLGUITable();
        xMLGUITable.setTableColumnList(xMLGUITableColumnList);
        xMLGUITable.setTableIdentifier(UPLOAD_TABLE_IDENTIFIER);
        xMLGUISettings.getTableList().addXMLGUITable(xMLGUITable);
        xMLGUITableColumnList = this.sharedFilesColumnModel.createXMLGUITableColumnList();
        xMLGUITable = new XMLGUITable();
        xMLGUITable.setTableColumnList(xMLGUITableColumnList);
        xMLGUITable.setTableIdentifier(SHARED_FILES_TABLE_IDENTIFIER);
        xMLGUISettings.getTableList().addXMLGUITable(xMLGUITable);
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private CellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setForeground(Color.black);
            if (jTable == ShareTab.this.uploadTable && n < ShareTab.this.uploadContainer.getUploadListSize()) {
                n = ShareTab.this.uploadTable.convertRowIndexToModel(n);
                switch (ShareTab.this.uploadContainer.getUploadFileAt(n).getStatus()) {
                    case 5: 
                    case 6: {
                        this.setForeground(Color.darkGray);
                        break;
                    }
                    case 3: {
                        this.setForeground(Color.red);
                        break;
                    }
                    case 4: {
                        this.setForeground(Color.blue);
                    }
                }
            }
            return this;
        }
    }

    private class SharedFilesChangeHandler
    implements SharedFilesChangeListener {
        private SharedFilesChangeHandler() {
        }

        public void sharedFileChanged(int n) {
        }

        public void sharedFileAdded(int n) {
            this.updateLabel();
        }

        public void sharedFileRemoved(int n) {
            this.updateLabel();
        }

        public void allSharedFilesChanged() {
            this.updateLabel();
        }

        private void updateLabel() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            stringBuffer.append(ShareTab.this.fileAdmin.getFileCount());
            stringBuffer.append(" / ");
            stringBuffer.append(StrUtil.formatSizeBytes((long)ShareTab.this.fileAdmin.getTotalFileSizeInKb() * 1024L)).append(')');
            ShareTab.this.sharedFilesLabel.setText(stringBuffer.toString());
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ShareTab.this.mainFrame.refreshAllActions();
        }
    }

    private class ShareRescanHandler
    implements ActionListener {
        private ShareRescanHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShareTab.this.mShareMgr.getFileAdministration().rescan(true);
        }
    }

    private class ClearUploadHandler
    implements ActionListener {
        private ClearUploadHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShareTab.this.clearUpload();
        }
    }

    private class AbortUploadHandler
    implements ActionListener {
        private AbortUploadHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShareTab.this.abortUpload();
        }
    }
}

