/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import phex.ServiceManager;
import phex.event.AsynchronousDispatcher;
import phex.event.CaughtHostsChangeListener;
import phex.host.HostAddress;
import phex.utils.IPUtils;
import phex.utils.Logger;

public class CaughtHostsContainer {
    private static final String[] DEFAULT_STARTUP_HOSTS = new String[]{"connect1.gnutellanet.com:6346", "connect2.gnutellanet.com:6346", "connect3.gnutellanet.com:6346", "gnutella-again.hostscache.com:6346", "gnutella.hostscache.com:6346", "gnotella.fileflash.com:6346", "public.bearshare.net:6346"};
    public static final short HIGH_PRIORITY = 0;
    public static final short LOW_PRIORITY = 1;
    private ArrayList caughtHosts;
    private HashSet uniqueCaughtHosts;
    private ArrayList autoConnectHosts;
    private boolean hasChangedSinceLastSave;
    private ArrayList listenerList = new ArrayList(2);

    public CaughtHostsContainer() {
        this.caughtHosts = new ArrayList();
        this.autoConnectHosts = new ArrayList();
        this.uniqueCaughtHosts = new HashSet();
    }

    public void initializeCaughtHostsContainer() {
        this.removeAllCaughtHosts();
        this.removeAllAutoConnectHosts();
        this.hasChangedSinceLastSave = false;
        this.loadHostsFromFile();
        this.loadAutoConnectHostsFromFile();
    }

    public synchronized String getNextCaughtHost() {
        String string = this.getCaughtHostAt(0);
        if (string == null) {
            this.addAutoConnectHosts();
            string = this.getCaughtHostAt(0);
        }
        this.removeCaughtHost(string);
        return string;
    }

    public synchronized int getCaughtHostsCount() {
        return this.caughtHosts.size();
    }

    public synchronized int getAutoConnectHostsCount() {
        return this.autoConnectHosts.size();
    }

    public synchronized String getCaughtHostAt(int n) {
        if (n >= this.caughtHosts.size()) {
            return null;
        }
        return (String)this.caughtHosts.get(n);
    }

    public synchronized String getAutoConnectHostAt(int n) {
        if (n >= this.autoConnectHosts.size()) {
            return null;
        }
        return (String)this.autoConnectHosts.get(n);
    }

    public synchronized String[] getCaughtHostsAt(int[] nArray) {
        int n = nArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.caughtHosts.get(nArray[n2]);
            ++n2;
        }
        return stringArray;
    }

    public synchronized void resetCaughtHosts() {
        this.removeAllCaughtHosts();
        this.addAutoConnectHosts();
    }

    public synchronized void removeAllCaughtHosts() {
        int n = this.caughtHosts.size() - 1;
        while (n >= 0) {
            this.removeCaughtHost((String)this.caughtHosts.get(n));
            --n;
        }
    }

    public synchronized void removeAllAutoConnectHosts() {
        int n = this.autoConnectHosts.size() - 1;
        while (n >= 0) {
            this.removeAutoConnectHost((String)this.autoConnectHosts.get(n));
            --n;
        }
    }

    public synchronized void addCaughtHost(HostAddress hostAddress, short s) {
        if (hostAddress.isLocalHost()) {
            return;
        }
        try {
            if (IPUtils.isInvalidIP(hostAddress.getHostIP())) {
                return;
            }
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
        this.insertCaughtHost(hostAddress.getHostName() + ":" + hostAddress.getPort(), s);
    }

    public synchronized void addAutoConnectHost(String string) {
        this.insertAutoConnectHost(string, this.autoConnectHosts.size());
    }

    private synchronized void insertCaughtHost(String string, short s) {
        if (this.caughtHosts.size() > ServiceManager.sCfg.mNetMaxHostToCatch) {
            if (s == 0) {
                this.removeCaughtHost(this.getCaughtHostAt(this.caughtHosts.size() - 1));
            } else {
                this.removeCaughtHost(this.getCaughtHostAt(0));
            }
        }
        int n = s == 0 ? 0 : this.caughtHosts.size();
        if (!this.uniqueCaughtHosts.contains(string)) {
            this.caughtHosts.add(n, string);
            this.uniqueCaughtHosts.add(string);
            this.hasChangedSinceLastSave = true;
            this.fireCaughtHostAdded(n);
        }
    }

    private synchronized void insertAutoConnectHost(String string, int n) {
        if (!this.autoConnectHosts.contains(string)) {
            this.autoConnectHosts.add(n, string);
            this.hasChangedSinceLastSave = true;
            this.fireAutoConnectHostAdded(n);
        }
    }

    public synchronized void removeCaughtHost(String string) {
        int n = this.caughtHosts.indexOf(string);
        if (n >= 0) {
            this.caughtHosts.remove(n);
            this.uniqueCaughtHosts.remove(string);
            this.fireCaughtHostRemoved(n);
            this.hasChangedSinceLastSave = true;
        }
    }

    public synchronized void removeAutoConnectHost(String string) {
        int n = this.autoConnectHosts.indexOf(string);
        if (n >= 0) {
            this.autoConnectHosts.remove(n);
            this.fireAutoConnectHostRemoved(n);
            this.hasChangedSinceLastSave = true;
        }
    }

    public synchronized void saveHostsContainer() {
        if (!this.hasChangedSinceLastSave) {
            return;
        }
        this.saveCaughtHosts();
        this.saveAutoConnectHosts();
        this.hasChangedSinceLastSave = false;
    }

    private synchronized void addAutoConnectHosts() {
        if (ServiceManager.sCfg.mCurrentNetwork.equals("<General Gnutella Network>")) {
            int n = this.autoConnectHosts.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                this.insertCaughtHost((String)this.autoConnectHosts.get(n2), (short)0);
                --n2;
            }
            if (n == 0) {
                this.addDefaultAutoConnectHosts();
            }
        }
    }

    private synchronized void addDefaultAutoConnectHosts() {
        if (ServiceManager.sCfg.mCurrentNetwork.equals("<General Gnutella Network>")) {
            int n = DEFAULT_STARTUP_HOSTS.length - 1;
            while (n >= 0) {
                this.insertCaughtHost(DEFAULT_STARTUP_HOSTS[n], (short)0);
                --n;
            }
        }
    }

    private void copyDefaultAutoConnectHosts() {
        int n = 0;
        while (n < DEFAULT_STARTUP_HOSTS.length) {
            this.addAutoConnectHost(DEFAULT_STARTUP_HOSTS[n]);
            ++n;
        }
    }

    private void loadHostsFromFile() {
        try {
            String string;
            File file = new File(ServiceManager.getHostsFilename());
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#")) continue;
                this.insertCaughtHost(string, (short)1);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Logger.logWarning(iOException);
        }
    }

    private void loadAutoConnectHostsFromFile() {
        try {
            String string;
            File file = new File(ServiceManager.getAutoConnectHostsFilename());
            if (!file.exists()) {
                this.copyDefaultAutoConnectHosts();
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#")) continue;
                this.insertAutoConnectHost(string, this.autoConnectHosts.size());
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void saveCaughtHosts() {
        try {
            File file = new File(ServiceManager.getHostsFilename());
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            int n = 0;
            while (n < this.caughtHosts.size()) {
                String string = (String)this.caughtHosts.get(n);
                if (!this.isInStartupHosts(string)) {
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                }
                ++n;
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private synchronized void saveAutoConnectHosts() {
        try {
            File file = new File(ServiceManager.getAutoConnectHostsFilename());
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            int n = 0;
            while (n < this.autoConnectHosts.size()) {
                String string = (String)this.autoConnectHosts.get(n);
                bufferedWriter.write(string);
                bufferedWriter.newLine();
                ++n;
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private boolean isInStartupHosts(String string) {
        int n = 0;
        while (n < DEFAULT_STARTUP_HOSTS.length) {
            if (string.equals(DEFAULT_STARTUP_HOSTS[n])) {
                return true;
            }
            ++n;
        }
        int n2 = this.autoConnectHosts.size();
        int n3 = 0;
        while (n3 < n2) {
            if (string.equals(this.autoConnectHosts.get(n3))) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public void addCaughtHostsChangeListener(CaughtHostsChangeListener caughtHostsChangeListener) {
        this.listenerList.add(caughtHostsChangeListener);
    }

    public void removeCaughtHostsChangeListener(CaughtHostsChangeListener caughtHostsChangeListener) {
        ((AbstractCollection)this.listenerList).remove(caughtHostsChangeListener);
    }

    private void fireCaughtHostAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = CaughtHostsContainer.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    CaughtHostsChangeListener caughtHostsChangeListener = (CaughtHostsChangeListener)objectArray[n2];
                    caughtHostsChangeListener.caughtHostAdded(n);
                    --n2;
                }
            }
        });
    }

    private void fireAutoConnectHostAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = CaughtHostsContainer.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    CaughtHostsChangeListener caughtHostsChangeListener = (CaughtHostsChangeListener)objectArray[n2];
                    caughtHostsChangeListener.autoConnectHostAdded(n);
                    --n2;
                }
            }
        });
    }

    private void fireCaughtHostRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = CaughtHostsContainer.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    CaughtHostsChangeListener caughtHostsChangeListener = (CaughtHostsChangeListener)objectArray[n2];
                    caughtHostsChangeListener.caughtHostRemoved(n);
                    --n2;
                }
            }
        });
    }

    private void fireAutoConnectHostRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = CaughtHostsContainer.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    CaughtHostsChangeListener caughtHostsChangeListener = (CaughtHostsChangeListener)objectArray[n2];
                    caughtHostsChangeListener.autoConnectHostRemoved(n);
                    --n2;
                }
            }
        });
    }
}

