/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import phex.ServiceManager;
import phex.connection.GWebCacheConnection;
import phex.connection.ProtocolNotSupportedException;
import phex.host.CaughtHostsContainer;
import phex.host.HostAddress;
import phex.utils.Logger;

public class GWebCacheContainer {
    private static int MIN_G_WEB_CACHES_SIZE = 20;
    private ArrayList allGWebCaches;
    private ArrayList functionalGWebCaches;
    private HashSet uniqueGWebCaches;
    private Random random;

    public GWebCacheContainer() {
        Logger.logMessage(Logger.FINEST, (short)255, "Initializing GWebCacheContainer");
        this.allGWebCaches = new ArrayList();
        this.functionalGWebCaches = new ArrayList();
        this.uniqueGWebCaches = new HashSet();
        this.random = new Random();
        this.loadGWebCacheFromFile();
        Logger.logMessage(Logger.FINEST, (short)255, "Initialized GWebCacheContainer");
    }

    public boolean queryMoreHosts() {
        int n = 0;
        boolean bl = false;
        do {
            ++n;
            GWebCacheConnection gWebCacheConnection = this.getRandomGWebCacheConnection();
            if (gWebCacheConnection == null) continue;
            HostAddress[] hostAddressArray = gWebCacheConnection.sendHostFileRequest();
            if (!this.verifyGWebCache(gWebCacheConnection) || hostAddressArray == null) continue;
            CaughtHostsContainer caughtHostsContainer = ServiceManager.getHostManager().getCaughtHostsContainer();
            int n2 = 0;
            while (n2 < hostAddressArray.length) {
                caughtHostsContainer.addCaughtHost(hostAddressArray[n2], (short)0);
                ++n2;
            }
            bl = true;
        } while (!bl && n < 5);
        return bl;
    }

    public boolean updateRemoteGWebCache(HostAddress hostAddress) {
        String string = null;
        if (hostAddress != null) {
            string = hostAddress.getFullHostName();
        }
        int n = 0;
        boolean bl = false;
        do {
            ++n;
            GWebCacheConnection gWebCacheConnection = this.getRandomGWebCacheConnection();
            if (gWebCacheConnection == null) continue;
            URL uRL = this.getRandomFunctionalGWebCacheURL();
            if (uRL != null && uRL.equals(gWebCacheConnection.getGWebCacheURL()) && (uRL = this.getRandomFunctionalGWebCacheURL()) != null && uRL.equals(gWebCacheConnection.getGWebCacheURL())) {
                uRL = null;
            }
            String string2 = null;
            if (uRL != null) {
                string2 = uRL.toExternalForm();
            }
            if (string == null && string2 == null) continue;
            bl = gWebCacheConnection.updateRequest(string, string2);
            if (this.verifyGWebCache(gWebCacheConnection) && bl) continue;
        } while (!bl && n < 5);
        return bl;
    }

    public boolean queryMoreGWebCaches() {
        int n = 0;
        boolean bl = false;
        do {
            ++n;
            GWebCacheConnection gWebCacheConnection = this.getRandomGWebCacheConnection();
            if (gWebCacheConnection == null) continue;
            URL[] uRLArray = gWebCacheConnection.sendURLFileRequest();
            if (!this.verifyGWebCache(gWebCacheConnection) || uRLArray == null) continue;
            int n2 = 0;
            while (n2 < uRLArray.length) {
                this.insertGWebCache(uRLArray[n2]);
                ++n2;
            }
            if (uRLArray.length > 0) {
                this.saveGWebCacheToFile();
            }
            bl = true;
        } while (!bl && n < 5);
        return bl;
    }

    private URL getRandomFunctionalGWebCacheURL() {
        URL uRL = null;
        int n = this.functionalGWebCaches.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return (URL)this.functionalGWebCaches.get(0);
        }
        int n2 = this.random.nextInt(n - 1);
        uRL = (URL)this.functionalGWebCaches.get(n2);
        return uRL;
    }

    private URL getRandomGWebCacheURL() {
        URL uRL = null;
        ArrayList arrayList = this.allGWebCaches;
        synchronized (arrayList) {
            int n = this.allGWebCaches.size();
            if (n == 0) {
                URL uRL2 = null;
                return uRL2;
            }
            if (n == 1) {
                URL uRL3 = (URL)this.allGWebCaches.get(0);
                return uRL3;
            }
            int n2 = this.random.nextInt(n - 1);
            uRL = (URL)this.allGWebCaches.get(n2);
        }
        return uRL;
    }

    private GWebCacheConnection getRandomGWebCacheConnection() {
        GWebCacheConnection gWebCacheConnection = null;
        URL uRL = null;
        try {
            uRL = this.getRandomGWebCacheURL();
            gWebCacheConnection = new GWebCacheConnection(uRL);
            if (!gWebCacheConnection.sendPingRequest()) {
                this.removeGWebCache(uRL, false);
                return null;
            }
        }
        catch (ProtocolNotSupportedException protocolNotSupportedException) {
            this.removeGWebCache(uRL, true);
            return null;
        }
        if (!this.functionalGWebCaches.contains(uRL)) {
            this.functionalGWebCaches.add(uRL);
        }
        return gWebCacheConnection;
    }

    private boolean verifyGWebCache(GWebCacheConnection gWebCacheConnection) {
        if (gWebCacheConnection.isCacheBad()) {
            this.removeGWebCache(gWebCacheConnection.getGWebCacheURL(), false);
            return false;
        }
        return true;
    }

    private void insertGWebCache(URL uRL) {
        ArrayList arrayList = this.allGWebCaches;
        synchronized (arrayList) {
            if (!this.uniqueGWebCaches.contains(uRL.toExternalForm())) {
                this.allGWebCaches.add(uRL);
                this.uniqueGWebCaches.add(uRL.toExternalForm());
            }
        }
    }

    private void removeGWebCache(URL uRL, boolean bl) {
        ArrayList arrayList = this.allGWebCaches;
        synchronized (arrayList) {
            if (this.allGWebCaches.size() > MIN_G_WEB_CACHES_SIZE || bl) {
                ((AbstractCollection)this.allGWebCaches).remove(uRL);
                ((AbstractCollection)this.functionalGWebCaches).remove(uRL);
                this.uniqueGWebCaches.remove(uRL.toExternalForm());
                this.saveGWebCacheToFile();
            }
        }
    }

    private void insertGWebCache(String string) {
        try {
            URL uRL = new URL(string);
            this.insertGWebCache(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.logMessage(Logger.FINE, (short)16, malformedURLException);
        }
    }

    private void ensureMinGWebCaches() {
        if (this.allGWebCaches.size() < 10) {
            this.insertGWebCache("http://www.gnucleus.net/gcache/gcache.php");
            this.insertGWebCache("http://www.cultiv8r.com/gcache/gcache.cfm");
            this.insertGWebCache("http://www.apexo.de/gnucache/gcache.php");
            this.insertGWebCache("http://www.php50.com/gwebcache/index.php");
            this.insertGWebCache("http://www.sven-herrmann.net/doetsch.info/gnucleus/gcache.php");
            this.insertGWebCache("http://tron.linux-site.net/gcache.php");
            this.insertGWebCache("http://www.padar.com/gwebcache/gcache.php");
            this.insertGWebCache("http://www.zero-g.net/gcache/gcache.php");
            this.insertGWebCache("http://www.techdudez.com/gcache.php");
            this.insertGWebCache("http://www.wgops.com/gwebcache/gcache.php");
            this.saveGWebCacheToFile();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadGWebCacheFromFile() {
        try {
            try {
                File file = new File(ServiceManager.getGWebCacheFilename());
                if (!file.exists()) {
                    Object var7_3 = null;
                    this.ensureMinGWebCaches();
                    return;
                }
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                ArrayList arrayList = this.allGWebCaches;
                synchronized (arrayList) {
                    while (true) {
                        String string;
                        if ((string = bufferedReader.readLine()) == null) {
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 6, 9] lbl14 : MonitorExitStatement: MONITOREXIT : arrayList
                            bufferedReader.close();
                            break;
                        }
                        if (string.startsWith("#")) continue;
                        this.insertGWebCache(string);
                    }
                }
            }
            catch (IOException iOException) {
                Logger.logWarning(iOException);
                Object var7_5 = null;
                this.ensureMinGWebCaches();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.ensureMinGWebCaches();
            throw throwable;
        }
        Object var7_4 = null;
        this.ensureMinGWebCaches();
    }

    private void saveGWebCacheToFile() {
        try {
            File file = new File(ServiceManager.getGWebCacheFilename());
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            ArrayList arrayList = this.allGWebCaches;
            synchronized (arrayList) {
                Iterator iterator = ((AbstractList)this.allGWebCaches).iterator();
                while (iterator.hasNext()) {
                    URL uRL = (URL)iterator.next();
                    bufferedWriter.write(uRL.toExternalForm());
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            Logger.logWarning(iOException);
        }
    }
}

