/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import phex.common.URN;
import phex.interfaces.IMsg;
import phex.msg.MsgHeader;
import phex.utils.IOUtil;
import phex.utils.Logger;

public class MsgQuery
implements IMsg {
    private MsgHeader mHeader;
    private Short minSpeed;
    private String searchString;
    private byte[] body;
    private boolean isParsed;
    private List queryURNList;

    public MsgQuery(byte by, String string, URN uRN) {
        this.mHeader = new MsgHeader();
        this.mHeader.setFunction(128);
        this.mHeader.setTTL(by);
        this.searchString = string;
        if (uRN != null) {
            this.queryURNList = new ArrayList(1);
            this.queryURNList.add(uRN);
        } else {
            this.queryURNList = Collections.EMPTY_LIST;
        }
        this.minSpeed = new Short(0);
        this.buildBody();
        this.mHeader.setDataLen(this.body.length);
    }

    public MsgQuery(MsgHeader msgHeader, byte[] byArray) {
        this.mHeader = msgHeader;
        this.mHeader.setFunction(128);
        this.body = byArray;
        this.parseBody();
    }

    public MsgHeader getHeader() {
        return this.mHeader;
    }

    public short getMinSpeed() {
        return this.minSpeed;
    }

    public Short getMinSpeedObject() {
        return this.minSpeed;
    }

    public URN[] getQueryURNs() {
        URN[] uRNArray = new URN[this.queryURNList.size()];
        return this.queryURNList.toArray(uRNArray);
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void computeHeaderLen() {
    }

    public int getSize() {
        return this.mHeader.getSize() + this.mHeader.getDataLen();
    }

    public void copy(MsgQuery msgQuery) {
        this.mHeader.copy(msgQuery.getHeader());
        this.minSpeed = msgQuery.minSpeed;
        this.searchString = msgQuery.searchString;
    }

    public int serialize(byte[] byArray, int n) throws Exception {
        n = this.mHeader.serialize(byArray, n);
        try {
            System.arraycopy(this.body, 0, byArray, n, this.mHeader.getDataLen());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Logger.logError((short)16, this.body.length + "  " + n + "  " + this.mHeader.getDataLen() + "  " + this.calculateBodySize() + "\n" + new String(this.body) + "\n" + new String(byArray) + "\n----");
            Logger.logError(arrayIndexOutOfBoundsException);
        }
        return n + this.mHeader.getDataLen();
    }

    public String toString() {
        return "[" + this.mHeader + " " + "MinSpeed=" + this.minSpeed + ", " + "SearchString=" + this.searchString + "]";
    }

    private void buildBody() {
        int n = this.calculateBodySize();
        this.body = new byte[n];
        IOUtil.serializeShortLE(this.minSpeed, this.body, 0);
        int n2 = IOUtil.serializeString(this.searchString, this.body, 2);
        this.body[n2++] = 0;
        if (this.queryURNList.size() == 0) {
            n2 = IOUtil.serializeString("urn:sha1", this.body, n2);
        } else {
            Iterator iterator = this.queryURNList.iterator();
            while (iterator.hasNext()) {
                URN uRN = (URN)iterator.next();
                n2 = IOUtil.serializeString(uRN.getAsString(), this.body, n2);
            }
        }
        this.body[n2++] = 0;
    }

    private int calculateBodySize() {
        int n = 2;
        n += this.searchString.length();
        n += 2;
        if (this.queryURNList.size() == 0) {
            n += 8;
        } else {
            Iterator iterator = this.queryURNList.iterator();
            while (iterator.hasNext()) {
                URN uRN = (URN)iterator.next();
                n += uRN.getAsString().length();
            }
        }
        return n;
    }

    private void parseBody() {
        int n = 0;
        this.minSpeed = new Short(IOUtil.deserializeShortLE(this.body, n));
        n += 2;
        StringBuffer stringBuffer = new StringBuffer();
        if ((n = IOUtil.deserializeString(this.body, n, stringBuffer)) < this.body.length && this.body[n] == 0) {
            ++n;
        }
        this.searchString = stringBuffer.toString();
        stringBuffer.setLength(0);
        n = IOUtil.deserializeString(this.body, n, stringBuffer);
        String string = stringBuffer.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u001c");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!URN.isValidURN(string2)) continue;
            URN uRN = new URN(string2);
            if (this.queryURNList == null) {
                this.queryURNList = new ArrayList(stringTokenizer.countTokens());
            }
            this.queryURNList.add(uRN);
        }
        if (this.queryURNList == null) {
            this.queryURNList = Collections.EMPTY_LIST;
        }
    }
}

