/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import phex.GUID;
import phex.ServiceManager;
import phex.host.HostAddress;
import phex.interfaces.IMsg;
import phex.msg.MsgHeader;
import phex.msg.MsgResRecord;
import phex.query.QueryConstants;
import phex.utils.HexConverter;
import phex.utils.IOUtil;
import phex.utils.Logger;

public class MsgQueryResponse
implements IMsg,
QueryConstants {
    private static final boolean INCLUDE_QHD = true;
    private static final byte PUSH_NEEDED_MASK = 1;
    private static final byte SERVER_BUSY_MASK = 4;
    private static final byte HAS_UPLOADED_MASK = 8;
    private static final byte UPLOAD_SPEED_MASK = 16;
    private MsgHeader mHeader;
    private byte[] body;
    private int mRemoteHostSpeed;
    private MsgResRecord[] mRecords;
    private HostAddress hostAddress;
    private GUID remoteClientID;
    private String vendorCode;
    private short pushNeededFlag;
    private short serverBusyFlag;
    private short hasUploadedFlag;
    private short uploadSpeedFlag;
    private boolean isParsed;

    private MsgQueryResponse() {
        throw new UnsupportedOperationException();
    }

    public MsgQueryResponse(MsgHeader msgHeader, GUID gUID, HostAddress hostAddress, int n, MsgResRecord[] msgResRecordArray) throws UnknownHostException {
        if (msgResRecordArray.length > 255) {
            throw new IllegalArgumentException("A maximum of 255 records can be associated with a single response: " + msgResRecordArray.length);
        }
        this.mHeader = msgHeader;
        this.mHeader.setFunction(129);
        this.remoteClientID = gUID;
        this.hostAddress = hostAddress;
        this.mRemoteHostSpeed = n;
        this.mRecords = msgResRecordArray;
        boolean bl = false;
        if (!ServiceManager.getListener().hasConnectedIncoming() || ServiceManager.sCfg.isBehindFirewall) {
            bl = true;
        }
        boolean bl2 = ServiceManager.getShareManager().isHostBusy();
        this.buildBody(bl, bl2);
        this.mHeader.setDataLen(this.body.length);
        this.isParsed = true;
    }

    public MsgQueryResponse(MsgHeader msgHeader, byte[] byArray) {
        this.mHeader = msgHeader;
        this.mHeader.setFunction(129);
        this.body = byArray;
        msgHeader.setDataLen(this.body.length);
        this.isParsed = false;
    }

    private void buildBody(boolean bl, boolean bl2) throws UnknownHostException {
        int n = this.calculateBodySize();
        this.body = new byte[n];
        int n2 = this.mRecords.length;
        this.body[0] = (byte)n2;
        IOUtil.serializeShortLE((short)this.hostAddress.getPort(), this.body, 1);
        byte[] byArray = this.hostAddress.getHostIP();
        this.body[3] = byArray[0];
        this.body[4] = byArray[1];
        this.body[5] = byArray[2];
        this.body[6] = byArray[3];
        IOUtil.serializeIntLE(this.mRemoteHostSpeed, this.body, 7);
        int n3 = 11;
        int n4 = 0;
        while (n4 < n2) {
            n3 = this.mRecords[n4].serialize(this.body, n3);
            ++n4;
        }
        this.body[n3++] = 80;
        this.body[n3++] = 72;
        this.body[n3++] = 69;
        this.body[n3++] = 88;
        this.body[n3++] = 2;
        int n5 = 0;
        if (bl) {
            n5 = 1;
        }
        int n6 = 0;
        if (bl2) {
            n6 = 4;
        }
        this.body[n3++] = (byte)(n5 | 4 | 0 | 0x10);
        this.body[n3++] = (byte)(1 | n6 | 0 | 0);
        n3 = this.remoteClientID.serialize(this.body, n3);
    }

    public MsgHeader getHeader() {
        return this.mHeader;
    }

    public short getRecordCount() {
        return (short)IOUtil.unsignedByte2int(this.body[0]);
    }

    public byte[] getHostIP() {
        byte[] byArray = new byte[]{this.body[3], this.body[4], this.body[5], this.body[6]};
        return byArray;
    }

    public HostAddress getHostAddress() {
        if (this.hostAddress == null) {
            short s = IOUtil.deserializeShortLE(this.body, 1);
            this.hostAddress = new HostAddress(this.getHostIP(), (int)s);
        }
        return this.hostAddress;
    }

    public int getRemoteHostSpeed() {
        this.parseBody();
        return this.mRemoteHostSpeed;
    }

    public String getVendorCode() {
        this.parseBody();
        return this.vendorCode;
    }

    public short getPushNeededFlag() {
        this.parseBody();
        return this.pushNeededFlag;
    }

    public short getServerBusyFlag() {
        this.parseBody();
        return this.serverBusyFlag;
    }

    public short getHasUploadedFlag() {
        this.parseBody();
        return this.hasUploadedFlag;
    }

    public short getUploadSpeedFlag() {
        this.parseBody();
        return this.uploadSpeedFlag;
    }

    public GUID getRemoteClientID() {
        if (this.remoteClientID == null) {
            this.parseRemoteClientID();
        }
        return this.remoteClientID;
    }

    public MsgResRecord getMsgRecord(int n) {
        this.parseBody();
        return this.mRecords[n];
    }

    public void computeHeaderLen() {
    }

    public int getSize() {
        return this.mHeader.getSize() + this.mHeader.getDataLen();
    }

    private int calculateBodySize() {
        int n = 11;
        n += this.getRecordLength();
        n = n + 4 + 1 + 2;
        return n += this.remoteClientID.getSize();
    }

    private int getRecordLength() {
        int n = 0;
        int n2 = this.mRecords.length;
        int n3 = 0;
        while (n3 < n2) {
            MsgResRecord msgResRecord = this.mRecords[n3];
            n += msgResRecord.getSize();
            ++n3;
        }
        return n;
    }

    public void copy(MsgQueryResponse msgQueryResponse) {
        this.mHeader.copy(msgQueryResponse.getHeader());
        this.hostAddress = msgQueryResponse.hostAddress;
        this.mRemoteHostSpeed = msgQueryResponse.mRemoteHostSpeed;
        this.remoteClientID = msgQueryResponse.remoteClientID;
        int n = msgQueryResponse.mRecords.length;
        this.mRecords = new MsgResRecord[n];
        int n2 = 0;
        while (n2 < n) {
            MsgResRecord msgResRecord = new MsgResRecord();
            msgResRecord.copy(msgQueryResponse.mRecords[n2]);
            this.mRecords[n2] = msgResRecord;
            ++n2;
        }
        this.body = msgQueryResponse.body;
    }

    public int serialize(byte[] byArray, int n) throws Exception {
        n = this.mHeader.serialize(byArray, n);
        try {
            System.arraycopy(this.body, 0, byArray, n, this.mHeader.getDataLen());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Logger.logError((short)16, this.body.length + "  " + n + "  " + this.mHeader.getDataLen() + "  " + this.calculateBodySize() + "\n" + new String(this.body) + "\n" + new String(byArray) + "\n----");
            Logger.logError(arrayIndexOutOfBoundsException);
        }
        return n;
    }

    private void parseBody() {
        byte by;
        if (this.isParsed) {
            return;
        }
        int n = 0;
        int n2 = (by = this.body[n++]) < 0 ? (int)(256 + by) : (int)by;
        n += 2;
        n += 4;
        try {
            Object object;
            int n3 = IOUtil.deserializeIntLE(this.body, n);
            if (n3 < 0) {
                n3 = Integer.MAX_VALUE;
            }
            this.mRemoteHostSpeed = n3;
            n += 4;
            this.mRecords = new MsgResRecord[n2];
            int n4 = 0;
            while (n4 < n2) {
                object = new MsgResRecord();
                n = ((MsgResRecord)object).deserialize(this.body, n);
                this.mRecords[n4] = object;
                ++n4;
            }
            this.pushNeededFlag = (short)-1;
            this.serverBusyFlag = (short)-1;
            this.hasUploadedFlag = (short)-1;
            this.uploadSpeedFlag = (short)-1;
            if (n <= this.mHeader.getDataLen() - 16 - 4 - 2) {
                this.vendorCode = new String(this.body, n, 4, "ISO-8859-1");
                if (!this.isVendorCodeValid(this.vendorCode)) {
                    object = HexConverter.toHexString(this.body, n, 4);
                    this.mHeader.getFromHost().log(Logger.WARNING, "Illegal QHD vendor code found: " + this.vendorCode + " (" + (String)object + "). Body: " + HexConverter.toHexString(this.body));
                    this.vendorCode = object;
                }
                int n5 = IOUtil.unsignedByte2int(this.body[n += 4]);
                ++n;
                if (n5 > 1) {
                    byte by2 = this.body[n];
                    byte by3 = this.body[n + 1];
                    if ((by3 & 1) != 0) {
                        this.pushNeededFlag = (by2 & 1) != 0 ? (short)1 : 0;
                    }
                    if ((by2 & 4) != 0) {
                        this.serverBusyFlag = (by3 & 4) != 0 ? (short)1 : 0;
                    }
                    if ((by2 & 8) != 0) {
                        this.hasUploadedFlag = (by3 & 8) != 0 ? (short)1 : 0;
                    }
                    if ((by2 & 0x10) != 0) {
                        this.uploadSpeedFlag = (by3 & 0x10) != 0 ? (short)1 : 0;
                    }
                }
                n += n5;
            }
            this.parseRemoteClientID();
            this.isParsed = true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
    }

    private void parseRemoteClientID() {
        if (this.remoteClientID == null) {
            this.remoteClientID = new GUID();
        }
        this.remoteClientID.deserialize(this.body, this.mHeader.getDataLen() - 16);
    }

    private boolean isVendorCodeValid(String string) {
        if (string.length() != 4) {
            return false;
        }
        int n = 0;
        while (n < 4) {
            if (!Character.isLetterOrDigit(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toString() {
        this.parseBody();
        String string = "[" + this.mHeader + " " + "NumRecords=" + this.mRecords.length + ", " + "RemoteHostAddress=" + this.hostAddress.getFullHostName() + ", " + "RemoteHostSpeed=" + this.mRemoteHostSpeed + ", " + "RemoteClientID=" + this.remoteClientID + ", " + "Records=";
        int n = 0;
        while (n < this.mRecords.length) {
            string = string + this.mRecords[n] + " ";
            ++n;
        }
        string = string + "]";
        return string;
    }
}

