/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.util.StringTokenizer;
import phex.common.URN;
import phex.utils.IOUtil;

public class MsgResRecord {
    private int mFileIndex = 0;
    private String fileName = "";
    private int mFileSize = 0;
    private URN urn;
    private String metaData;

    public MsgResRecord() {
    }

    public MsgResRecord(int n, URN uRN, int n2, String string) {
        this.mFileIndex = n;
        this.mFileSize = n2;
        this.fileName = string;
        this.urn = uRN;
    }

    public int getFileIndex() {
        return this.mFileIndex;
    }

    public int getFileSize() {
        return this.mFileSize;
    }

    public String getFilename() {
        return this.fileName;
    }

    public int getSize() {
        return 8 + this.fileName.length() + this.urn.getAsString().length() + 2;
    }

    public URN getURN() {
        return this.urn;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void copy(MsgResRecord msgResRecord) {
        this.mFileIndex = msgResRecord.mFileIndex;
        this.mFileSize = msgResRecord.mFileSize;
        this.fileName = msgResRecord.fileName;
    }

    public int serialize(byte[] byArray, int n) {
        n = IOUtil.serializeIntLE(this.mFileIndex, byArray, n);
        n = IOUtil.serializeIntLE(this.mFileSize, byArray, n);
        n = IOUtil.serializeString(this.fileName, byArray, n);
        byArray[n++] = 0;
        n = IOUtil.serializeString(this.urn.getAsString(), byArray, n);
        byArray[n++] = 0;
        return n;
    }

    public int deserialize(byte[] byArray, int n) {
        this.mFileIndex = IOUtil.deserializeIntLE(byArray, n);
        this.mFileSize = IOUtil.deserializeIntLE(byArray, n += 4);
        int n2 = n += 4;
        while (byArray[n2] != 0) {
            ++n2;
        }
        this.fileName = new String(byArray, n, n2 - n);
        int n3 = n2 + 1;
        while (byArray[n3] != 0) {
            ++n3;
        }
        String string = new String(byArray, n2 + 1, n3 - n2 - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u001c");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (URN.isValidURN(string2)) {
                this.urn = new URN(string2);
                continue;
            }
            this.metaData = string2;
        }
        n = n3 + 1;
        return n;
    }

    public String toString() {
        return "[FileIndex=" + this.mFileIndex + ", " + "FileSize=" + this.mFileSize + ", " + "Filename=" + this.fileName + "]";
    }
}

