/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.io.File;
import org.w3c.dom.Document;
import phex.ServiceManager;
import phex.xml.XMLBuilder;
import phex.xml.XMLPhex;
import phex.xml.XMLPhexXMLCodec;
import phex.xml.XMLResearchServiceConfig;

public class ResearchServiceConfig {
    private static final int DEFAULT_MIN_REMOTE_CANDIDATES_COUNT = 5;
    private static final long DEFAULT_RESEARCH_TIMEOUT = 120000L;
    private static final long DEFAULT_RESEARCH_INTERVAL_MILLIS = 300000L;
    private static final long DEFAULT_RESEARCH_TIME_PENALTY = 60000L;
    private static final long DEFAULT_MAX_RESEARCH_INTERVAL_MILLIS = 3600000L;
    private static final int DEFAULT_CANDIDATE_INTERVAL_THRESHOLD = 2;
    private long maxResearchIntervalMillis;
    private int minRemoteCandidatesCount;
    private long researchIntervalMillis;
    private long researchTimeout;
    private int candidatesIntervalThreshold;
    private long researchTimePenalty;
    private boolean isResearchEnabled;

    public ResearchServiceConfig() {
        this.loadXMLResearchServiceConfig();
        this.ensureDefaults();
    }

    public int getMinRemoteCandidatesCount() {
        return this.minRemoteCandidatesCount;
    }

    public long getResearchIntervalMillis() {
        return this.researchIntervalMillis;
    }

    public long getMaxResearchIntervalMillis() {
        return this.maxResearchIntervalMillis;
    }

    public int getCandidatesIntervalThreshold() {
        return this.candidatesIntervalThreshold;
    }

    public long getResearchTimePenalty() {
        return this.researchTimePenalty;
    }

    public long getResearchTimeout() {
        return this.researchTimeout;
    }

    public boolean isResearchEnabled() {
        return this.isResearchEnabled;
    }

    private void loadXMLResearchServiceConfig() {
        File file = new File(ServiceManager.getXMLResearchServiceFilename());
        if (!file.exists()) {
            return;
        }
        Document document = XMLBuilder.loadFromFile(file);
        XMLPhex xMLPhex = XMLPhexXMLCodec.decodeXML(document.getDocumentElement());
        XMLResearchServiceConfig xMLResearchServiceConfig = xMLPhex.getResearchServiceConfig();
        this.maxResearchIntervalMillis = xMLResearchServiceConfig.getMaxResearchIntervalMillis();
        this.minRemoteCandidatesCount = xMLResearchServiceConfig.getMinRemoteCandidatesCount();
        this.researchIntervalMillis = xMLResearchServiceConfig.getResearchIntervalMillis();
        this.researchTimeout = xMLResearchServiceConfig.getResearchTimeout();
        this.isResearchEnabled = xMLResearchServiceConfig.getResearchEnabled();
    }

    private void ensureDefaults() {
        if (this.maxResearchIntervalMillis == 0L) {
            this.maxResearchIntervalMillis = 3600000L;
        }
        if (this.minRemoteCandidatesCount == 0) {
            this.minRemoteCandidatesCount = 5;
        }
        if (this.researchIntervalMillis == 0L) {
            this.researchIntervalMillis = 300000L;
        }
        if (this.candidatesIntervalThreshold == 0) {
            this.candidatesIntervalThreshold = 2;
        }
        if (this.researchTimeout == 0L) {
            this.researchTimeout = 120000L;
        }
        if (this.researchTimePenalty == 0L) {
            this.researchTimePenalty = 60000L;
        }
    }
}

