/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import phex.GUID;
import phex.ServiceManager;
import phex.common.MediaType;
import phex.common.URN;
import phex.download.RemoteFile;
import phex.event.AsynchronousDispatcher;
import phex.event.NetworkHostsChangeListener;
import phex.event.SearchChangeEvent;
import phex.event.SearchChangeListener;
import phex.host.Host;
import phex.host.HostAddress;
import phex.msg.MsgManager;
import phex.msg.MsgQuery;
import phex.msg.MsgQueryResponse;
import phex.msg.MsgResRecord;
import phex.query.QueryHitHost;
import phex.utils.Logger;
import phex.utils.SearchEngine;

public class Search {
    public static final long DEFAULT_SEARCH_TIMEOUT = 300000L;
    private String fixedDisplayStr;
    private String searchString;
    private URN searchURN;
    private SearchFilterConstraints searchFilterConstraints;
    private MsgQuery queryMsg;
    private ArrayList queryHitList;
    private ArrayList filteredQueryHitList;
    private boolean isPermanentlyFiltered;
    private boolean isSearching = false;
    private long startTime;
    private long searchTimeout;
    private NewConnectedHostListener newHostListener;
    private ArrayList listenerList = new ArrayList(2);

    public Search(String string) {
        this(string, null, 300000L);
    }

    public Search(String string, URN uRN, long l) {
        this.queryHitList = new ArrayList();
        this.filteredQueryHitList = new ArrayList();
        this.searchString = string;
        this.searchURN = uRN;
        this.searchTimeout = l;
        this.queryMsg = new MsgQuery((byte)ServiceManager.sCfg.mNetTTL, this.searchString, this.searchURN);
        this.fixedDisplayStr = '\'' + this.searchString + '\'';
        this.newHostListener = new NewConnectedHostListener();
        this.searchFilterConstraints = new SearchFilterConstraints();
    }

    public void updateSearchFilterConstraints(String string, int n, MediaType mediaType, int n2, long l) {
        ArrayList arrayList = this.filteredQueryHitList;
        synchronized (arrayList) {
            this.searchFilterConstraints.setFilterString(string);
            this.searchFilterConstraints.minSpeed = n;
            this.searchFilterConstraints.mediaType = mediaType;
            this.searchFilterConstraints.maxResults = n2;
            this.searchFilterConstraints.minFileSize = l;
            this.updateFilteredQueryList();
        }
    }

    public void updateSearchFilterConstraints(long l, long l2) {
        ArrayList arrayList = this.filteredQueryHitList;
        synchronized (arrayList) {
            this.searchFilterConstraints.minFileSize = l;
            this.searchFilterConstraints.maxFileSize = l2;
            this.updateFilteredQueryList();
        }
    }

    public void setPermanentlyFilter(boolean bl) {
        this.isPermanentlyFiltered = bl;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public int getQueryHitCount() {
        ArrayList arrayList = this.filteredQueryHitList;
        synchronized (arrayList) {
            int n = this.filteredQueryHitList.size();
            return n;
        }
    }

    public RemoteFile getQueryHit(int n) {
        ArrayList arrayList = this.filteredQueryHitList;
        synchronized (arrayList) {
            RemoteFile remoteFile = (RemoteFile)this.filteredQueryHitList.get(n);
            return remoteFile;
        }
    }

    public int getLocallyFilteredCount() {
        ArrayList arrayList = this.queryHitList;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.filteredQueryHitList;
            synchronized (arrayList2) {
                int n = this.queryHitList.size() - this.filteredQueryHitList.size();
                return n;
            }
        }
    }

    public boolean isSearching() {
        return this.isSearching;
    }

    public String getDisplayStr() {
        return this.fixedDisplayStr + " - (" + this.getQueryHitCount() + ')';
    }

    public void checkForSearchTimeout(long l) {
        if (l > this.startTime + this.searchTimeout) {
            this.stopSearching();
        }
    }

    public void startSearching() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                ServiceManager.getHostManager().addNetworkHostsChangeListener(Search.this.newHostListener);
                Logger.logMessage(Logger.FINER, (short)8, "Sending Query " + Search.this.queryMsg);
                MsgManager msgManager = ServiceManager.getMsgManager();
                msgManager.checkAndAddMsgSeen(Search.this.queryMsg.getHeader());
                msgManager.sendMsgToHosts(Search.this.queryMsg);
                Search.this.isSearching = true;
                Search.this.startTime = System.currentTimeMillis();
                Search.this.fireSearchStarted();
            }
        });
    }

    public void stopSearching() {
        if (!this.isSearching) {
            return;
        }
        this.isSearching = false;
        ServiceManager.getHostManager().removeNetworkHostsChangeListener(this.newHostListener);
        this.fireSearchStoped();
    }

    public void processResponse(MsgQueryResponse msgQueryResponse) {
        if (!this.isSearching) {
            return;
        }
        if (!msgQueryResponse.getHeader().getMsgID().equals(this.queryMsg.getHeader().getMsgID())) {
            return;
        }
        int n = msgQueryResponse.getRemoteHostSpeed();
        GUID gUID = msgQueryResponse.getRemoteClientID();
        HostAddress hostAddress = msgQueryResponse.getHostAddress();
        QueryHitHost queryHitHost = new QueryHitHost(gUID, hostAddress, n);
        queryHitHost.setVendorCode(msgQueryResponse.getVendorCode());
        queryHitHost.setQHDFlags(msgQueryResponse.getPushNeededFlag(), msgQueryResponse.getServerBusyFlag(), msgQueryResponse.getHasUploadedFlag(), msgQueryResponse.getUploadSpeedFlag());
        int n2 = this.queryHitList.size();
        int n3 = 0;
        while (n3 < msgQueryResponse.getRecordCount()) {
            MsgResRecord msgResRecord = msgQueryResponse.getMsgRecord(n3);
            if (this.searchURN == null || msgResRecord.getURN() == null || this.searchURN.equals(msgResRecord.getURN())) {
                ArrayList arrayList = this.filteredQueryHitList;
                synchronized (arrayList) {
                    boolean bl = this.searchFilterConstraints.isMsgResRecordFiltered(msgResRecord, n);
                    if (bl && this.isPermanentlyFiltered) {
                    } else {
                        String string = msgResRecord.getFilename();
                        long l = msgResRecord.getFileSize();
                        short s = Search.calculateSearchScore(this.searchString, string);
                        RemoteFile remoteFile = new RemoteFile(queryHitHost, msgResRecord.getFileIndex(), string, l, msgResRecord.getURN(), msgResRecord.getMetaData(), s);
                        this.queryHitList.add(remoteFile);
                        if (!bl) {
                            this.filteredQueryHitList.add(remoteFile);
                        }
                    }
                }
            }
            ++n3;
        }
        int n4 = this.queryHitList.size();
        if (n4 > n2) {
            this.fireSearchHitsAdded(n2, n4);
        }
    }

    private void updateFilteredQueryList() {
        ArrayList arrayList = this.filteredQueryHitList;
        synchronized (arrayList) {
            this.filteredQueryHitList.clear();
            Iterator iterator = ((AbstractList)this.queryHitList).iterator();
            while (iterator.hasNext()) {
                RemoteFile remoteFile = (RemoteFile)iterator.next();
                if (this.searchFilterConstraints.isRemoteFileFiltered(remoteFile)) continue;
                this.filteredQueryHitList.add(remoteFile);
            }
            this.fireSearchFiltered();
        }
    }

    public static short calculateSearchScore(String string, String string2) {
        double d = 0.0;
        double d2 = 0.0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.setText(string2, false);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            d += 1.0;
            searchEngine.setPattern(string3, false);
            if (!searchEngine.match()) continue;
            d2 += 1.0;
        }
        double d3 = d2 / d * 100.0;
        return (short)d3;
    }

    public void addSearchChangeListener(SearchChangeListener searchChangeListener) {
        this.listenerList.add(searchChangeListener);
    }

    public void removeSearchChangeListener(SearchChangeListener searchChangeListener) {
        ((AbstractCollection)this.listenerList).remove(searchChangeListener);
    }

    private void fireSearchStarted() {
        SearchChangeEvent searchChangeEvent = new SearchChangeEvent(this, 0);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    private void fireSearchStoped() {
        SearchChangeEvent searchChangeEvent = new SearchChangeEvent(this, 3);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    private void fireSearchFiltered() {
        SearchChangeEvent searchChangeEvent = new SearchChangeEvent(this, 2);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    private void fireSearchHitsAdded(int n, int n2) {
        SearchChangeEvent searchChangeEvent = new SearchChangeEvent(this, 1, n, n2);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    private void fireSearchChangeEvent(final SearchChangeEvent searchChangeEvent) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = Search.this.listenerList.toArray();
                int n = objectArray.length - 1;
                while (n >= 0) {
                    SearchChangeListener searchChangeListener = (SearchChangeListener)objectArray[n];
                    searchChangeListener.searchChanged(searchChangeEvent);
                    --n;
                }
            }
        });
    }

    private class SearchFilterConstraints {
        private List filterTokens = new ArrayList();
        int minSpeed = 0;
        MediaType mediaType = MediaType.getMediaTypeAny();
        int maxResults = Integer.MAX_VALUE;
        long minFileSize = 0L;
        long maxFileSize = Long.MAX_VALUE;

        public void setFilterString(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            this.filterTokens.clear();
            while (stringTokenizer.hasMoreTokens()) {
                this.filterTokens.add(stringTokenizer.nextToken().toLowerCase());
            }
        }

        public boolean isMsgResRecordFiltered(MsgResRecord msgResRecord, int n) {
            if (Search.this.filteredQueryHitList.size() > this.maxResults) {
                return true;
            }
            long l = msgResRecord.getFileSize();
            if (l < this.minFileSize || l > this.maxFileSize) {
                return true;
            }
            if (!this.mediaType.isFilenameOf(msgResRecord.getFilename())) {
                return true;
            }
            if (this.minSpeed > n) {
                return true;
            }
            return this.isFilenameFiltered(msgResRecord.getFilename());
        }

        public boolean isRemoteFileFiltered(RemoteFile remoteFile) {
            if (Search.this.filteredQueryHitList.size() >= this.maxResults) {
                return true;
            }
            long l = remoteFile.getFileSize();
            if (l < this.minFileSize || l > this.maxFileSize) {
                return true;
            }
            if (!this.mediaType.isExtensionOf(remoteFile.getFileExt())) {
                return true;
            }
            if (this.minSpeed > remoteFile.getSpeed()) {
                return true;
            }
            return this.isFilenameFiltered(remoteFile.getFilename());
        }

        private boolean isFilenameFiltered(String string) {
            if (this.filterTokens == null || this.filterTokens.size() == 0) {
                return false;
            }
            string = string.toLowerCase();
            Iterator iterator = this.filterTokens.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string.indexOf(string2) != -1) continue;
                return true;
            }
            return false;
        }
    }

    private class NewConnectedHostListener
    implements NetworkHostsChangeListener {
        private NewConnectedHostListener() {
        }

        public void networkHostChanged(int n) {
            if (!Search.this.isSearching) {
                return;
            }
            Host host = ServiceManager.getHostManager().getConnectedHostAt(n);
            if (host == null || !host.isConnectionStable()) {
                return;
            }
            Logger.logMessage(Logger.FINER, (short)8, "Forwarding search: " + Search.this.getDisplayStr() + " to: " + host);
            ServiceManager.getMsgManager().sendMsgToHost(Search.this.queryMsg, host);
        }

        public void networkHostAdded(int n) {
        }

        public void networkHostRemoved(int n) {
        }
    }
}

