/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Document;
import phex.Res;
import phex.ServiceManager;
import phex.common.URN;
import phex.config.Cfg;
import phex.event.AsynchronousDispatcher;
import phex.event.SharedFilesChangeListener;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.utils.FileUtils;
import phex.utils.Logger;
import phex.utils.ReadWriteLock;
import phex.xml.XMLBuilder;
import phex.xml.XMLException;
import phex.xml.XMLPhex;
import phex.xml.XMLPhexXMLCodec;
import phex.xml.XMLSharedFile;
import phex.xml.XMLSharedLibrary;

public class FileAdministration {
    private static final String aliasFile = "filealias";
    private static final String aliasFilename = "filealias.txt";
    private ReadWriteLock rwLock;
    private ArrayList sharedDirectories;
    private ArrayList sharedFiles;
    private ArrayList indexedSharedFiles;
    private HashMap urnToFileMap;
    private HashMap nameToFileMap;
    private ArrayList fileExclusionList;
    private ArrayList fileInclusionList;
    private int totalFileSizeKb;
    private ShareManager shareManager;
    private Thread rescanThread;
    private ArrayList listenerList = new ArrayList(2);

    public FileAdministration(ShareManager shareManager) {
        this.rwLock = new ReadWriteLock();
        this.shareManager = shareManager;
        this.sharedDirectories = new ArrayList(1);
        this.sharedFiles = new ArrayList();
        this.indexedSharedFiles = new ArrayList();
        this.urnToFileMap = new HashMap();
        this.fileExclusionList = new ArrayList();
        this.fileInclusionList = new ArrayList();
        this.nameToFileMap = new HashMap();
        this.totalFileSizeKb = 0;
    }

    /*
     * Loose catch block
     */
    public ShareFile getFileAt(int n) {
        ShareFile shareFile;
        this.rwLock.readLock();
        if (n < this.sharedFiles.size()) break block6;
        ShareFile shareFile2 = null;
        Object var4_4 = null;
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        {
            block6: {
                return shareFile2;
            }
            shareFile = (ShareFile)this.sharedFiles.get(n);
        }
        Object var4_5 = null;
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return shareFile;
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
    }

    public ShareFile[] getSharedFiles() {
        ShareFile[] shareFileArray;
        this.rwLock.readLock();
        try {
            ShareFile[] shareFileArray2 = new ShareFile[this.sharedFiles.size()];
            shareFileArray = shareFileArray2 = this.sharedFiles.toArray(shareFileArray2);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return shareFileArray;
    }

    public File[] getSharedDirectories() {
        File[] fileArray;
        this.rwLock.readLock();
        try {
            File[] fileArray2 = new File[this.sharedDirectories.size()];
            this.sharedDirectories.toArray(fileArray2);
            fileArray = fileArray2;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return fileArray;
    }

    public int getFileCount() {
        int n;
        this.rwLock.readLock();
        try {
            n = this.sharedFiles.size();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return n;
    }

    public List getFilesByURNs(URN[] uRNArray) {
        ArrayList arrayList = new ArrayList(uRNArray.length);
        int n = 0;
        while (n < uRNArray.length) {
            Object v = this.urnToFileMap.get(uRNArray[n]);
            if (v != null) {
                arrayList.add(v);
            }
            ++n;
        }
        return arrayList;
    }

    public ShareFile getFileByName(String string) {
        ShareFile shareFile;
        this.rwLock.readLock();
        try {
            shareFile = (ShareFile)this.nameToFileMap.get(string);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return shareFile;
    }

    /*
     * Loose catch block
     */
    public ShareFile getFileByIndex(int n) throws IndexOutOfBoundsException {
        ShareFile shareFile;
        this.rwLock.readLock();
        if (n < this.indexedSharedFiles.size()) break block6;
        ShareFile shareFile2 = null;
        Object var4_4 = null;
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        {
            block6: {
                return shareFile2;
            }
            shareFile = (ShareFile)this.indexedSharedFiles.get(n);
        }
        Object var4_5 = null;
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return shareFile;
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public ShareFile getFileByURN(URN uRN) throws IndexOutOfBoundsException {
        ShareFile shareFile;
        this.rwLock.readLock();
        if (uRN != null) break block6;
        ShareFile shareFile2 = null;
        Object var4_4 = null;
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        {
            block6: {
                return shareFile2;
            }
            shareFile = (ShareFile)this.urnToFileMap.get(uRN);
        }
        Object var4_5 = null;
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return shareFile;
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
    }

    public int getTotalFileSizeInKb() {
        int n;
        this.rwLock.readLock();
        try {
            n = this.totalFileSizeKb;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return n;
    }

    public void rescan(boolean bl) {
        if (this.rescanThread == null || !this.rescanThread.isAlive()) {
            FileRescanRunner fileRescanRunner = new FileRescanRunner(bl);
            this.rescanThread = new Thread(fileRescanRunner);
            this.rescanThread.setDaemon(true);
            this.rescanThread.setPriority(1);
            this.rescanThread.start();
        }
    }

    /*
     * Loose catch block
     */
    public boolean isFileInvalid(File file) {
        block12: {
            block10: {
                boolean bl;
                if (file.getName().toLowerCase().endsWith(".dl")) {
                    return true;
                }
                if (file.getName().equals("files.idx")) {
                    return true;
                }
                if (file.getName().equals(aliasFilename)) {
                    return true;
                }
                this.rwLock.readLock();
                if (this.isIncluded(file)) break block11;
                boolean bl2 = true;
                Object var4_4 = null;
                try {
                    this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                {
                    block11: {
                        return bl2;
                    }
                    if (!this.isExcluded(file)) break block10;
                    bl = true;
                }
                Object var4_5 = null;
                try {
                    this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                return bl;
            }
            Object var4_6 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            break block12;
            catch (Throwable throwable) {
                Object var4_7 = null;
                try {
                    this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                throw throwable;
            }
        }
        return false;
    }

    private XMLSharedLibrary loadSharedLibrary() {
        File file = new File(ServiceManager.getXMLSharedLibraryFilename());
        if (!file.exists()) {
            Logger.logMessage(Logger.FINE, (short)2, "No shared library configuration file found.");
            return new XMLSharedLibrary();
        }
        Logger.logMessage(Logger.FINE, (short)2, "Load shared library configuration file.");
        Document document = null;
        document = XMLBuilder.loadFromFile(file);
        if (document == null) {
            Logger.logMessage(Logger.SEVERE, (short)2, "Error while parsing shared library xml file.");
            return new XMLSharedLibrary();
        }
        XMLPhex xMLPhex = XMLPhexXMLCodec.decodeXML(document.getDocumentElement());
        XMLSharedLibrary xMLSharedLibrary = xMLPhex.getSharedLibrary();
        return xMLSharedLibrary;
    }

    public void saveSharedLibrary() {
        try {
            XMLPhex xMLPhex = new XMLPhex();
            XMLSharedLibrary xMLSharedLibrary = this.createXMLSharedLibrary();
            xMLPhex.setSharedLibrary(xMLSharedLibrary);
            xMLPhex.setPhexVersion(Res.getStr("Program.Version"));
            XmlDocument xmlDocument = XMLPhexXMLCodec.encodeXML(xMLPhex);
            File file = new File(ServiceManager.getXMLSharedLibraryFilename());
            XMLBuilder.saveToFile(file, xmlDocument);
        }
        catch (XMLException xMLException) {
            Logger.logError(xMLException);
        }
    }

    private XMLSharedLibrary createXMLSharedLibrary() {
        XMLSharedLibrary xMLSharedLibrary = new XMLSharedLibrary();
        this.rwLock.readLock();
        try {
            Iterator iterator = ((AbstractList)this.sharedFiles).iterator();
            while (iterator.hasNext()) {
                ShareFile shareFile = (ShareFile)iterator.next();
                if (shareFile.getURN() == null) continue;
                XMLSharedFile xMLSharedFile = new XMLSharedFile();
                xMLSharedFile.setFileName(shareFile.getFile().getAbsolutePath());
                xMLSharedFile.setSha1(shareFile.getSHA1());
                xMLSharedFile.setLastModified(shareFile.getFile().lastModified());
                xMLSharedFile.setHitCount(shareFile.getSearchCount());
                xMLSharedFile.setUploadCount(shareFile.getUploadCount());
                xMLSharedLibrary.addXMLSharedFile(xMLSharedFile);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.logError(illegalAccessException);
        }
        return xMLSharedLibrary;
    }

    private void addSharedFile(ShareFile shareFile) {
        File file = shareFile.getFile();
        if (this.nameToFileMap.containsKey(file.getAbsolutePath())) {
            return;
        }
        this.rwLock.writeLock();
        try {
            int n = this.indexedSharedFiles.size();
            shareFile.setFileIndex(n);
            this.indexedSharedFiles.add(n, shareFile);
            n = this.sharedFiles.size();
            this.sharedFiles.add(n, shareFile);
            this.urnToFileMap.put(shareFile.getURN(), shareFile);
            this.nameToFileMap.put(file.getAbsolutePath(), shareFile);
            this.totalFileSizeKb = (int)((long)this.totalFileSizeKb + file.length() / 1024L);
            this.fireSharedFileAdded(n);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.rwLock.writeUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    private void removeSharedFile(ShareFile shareFile) {
        this.rwLock.writeLock();
        try {
            int n = shareFile.getFileIndex();
            this.indexedSharedFiles.set(shareFile.getFileIndex(), null);
            File file = shareFile.getFile();
            this.urnToFileMap.remove(shareFile.getURN());
            this.nameToFileMap.remove(file.getAbsolutePath());
            int n2 = this.sharedFiles.indexOf(shareFile);
            if (n2 != -1) {
                this.sharedFiles.remove(n2);
                this.totalFileSizeKb = (int)((long)this.totalFileSizeKb - shareFile.getFileSize() / 1024L);
                this.fireSharedFileRemoved(n2);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.rwLock.writeUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    private void clearSharedFiles() {
        this.rwLock.writeLock();
        try {
            this.sharedFiles.clear();
            this.indexedSharedFiles.clear();
            this.urnToFileMap.clear();
            this.nameToFileMap.clear();
            this.totalFileSizeKb = 0;
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.rwLock.writeUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        this.fireAllSharedFilesChanged();
    }

    private void setInclusions(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        this.fileInclusionList.clear();
        while (stringTokenizer.hasMoreTokens()) {
            this.fileInclusionList.add(stringTokenizer.nextToken().trim().toLowerCase());
        }
    }

    private boolean isIncluded(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = file.getName().toLowerCase();
        int n = 0;
        while (n < this.fileInclusionList.size()) {
            String string2 = (String)this.fileInclusionList.get(n);
            if (string2.equals("*")) {
                return true;
            }
            if (string2.equals("*.*")) {
                return true;
            }
            if (string2.startsWith("*")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith("*")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string.indexOf(string2) != -1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void setExclusions(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        this.fileExclusionList.clear();
        while (stringTokenizer.hasMoreTokens()) {
            this.fileExclusionList.add(stringTokenizer.nextToken().trim().toLowerCase());
        }
    }

    private boolean isExcluded(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String string = file.getName().toLowerCase();
        if (string.indexOf(aliasFile) != -1) {
            return true;
        }
        int n = 0;
        while (n < this.fileExclusionList.size()) {
            String string2 = (String)this.fileExclusionList.get(n);
            if (string.indexOf(string2) != -1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void setSharedDirectories(String string) {
        this.rwLock.writeLock();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            int n = stringTokenizer.countTokens();
            this.sharedDirectories.clear();
            this.sharedDirectories.ensureCapacity(n);
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken().trim());
                if (this.sharedDirectories.contains(file)) continue;
                this.sharedDirectories.add(file);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.rwLock.writeUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    public void addSharedFilesChangeListener(SharedFilesChangeListener sharedFilesChangeListener) {
        this.listenerList.add(sharedFilesChangeListener);
    }

    public void removeSharedFilesChangeListener(SharedFilesChangeListener sharedFilesChangeListener) {
        ((AbstractCollection)this.listenerList).remove(sharedFilesChangeListener);
    }

    private void fireSharedFileChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = FileAdministration.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    SharedFilesChangeListener sharedFilesChangeListener = (SharedFilesChangeListener)objectArray[n2];
                    sharedFilesChangeListener.sharedFileChanged(n);
                    --n2;
                }
            }
        });
    }

    private void fireSharedFileAdded(int n) {
        Object[] objectArray = this.listenerList.toArray();
        int n2 = objectArray.length - 1;
        while (n2 >= 0) {
            SharedFilesChangeListener sharedFilesChangeListener = (SharedFilesChangeListener)objectArray[n2];
            sharedFilesChangeListener.sharedFileAdded(n);
            --n2;
        }
    }

    private void fireSharedFileRemoved(int n) {
        Object[] objectArray = this.listenerList.toArray();
        int n2 = objectArray.length - 1;
        while (n2 >= 0) {
            SharedFilesChangeListener sharedFilesChangeListener = (SharedFilesChangeListener)objectArray[n2];
            sharedFilesChangeListener.sharedFileRemoved(n);
            --n2;
        }
    }

    private void fireAllSharedFilesChanged() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = FileAdministration.this.listenerList.toArray();
                int n = objectArray.length - 1;
                while (n >= 0) {
                    SharedFilesChangeListener sharedFilesChangeListener = (SharedFilesChangeListener)objectArray[n];
                    sharedFilesChangeListener.allSharedFilesChanged();
                    --n;
                }
            }
        });
    }

    public void fireSharedFileChanged(ShareFile shareFile) {
        int n = this.sharedFiles.indexOf(shareFile);
        if (n >= 0) {
            this.fireSharedFileChanged(n);
        }
    }

    private class FileRescanRunner
    implements Runnable {
        private boolean isInitialRescan;
        private HashMap sharedFilesCache;

        public FileRescanRunner(boolean bl) {
            this.isInitialRescan = bl;
        }

        public void run() {
            Logger.logMessage(Logger.FINEST, (short)4, "Staring file rescan (Initial: " + this.isInitialRescan + ").");
            Cfg cfg = ServiceManager.sCfg;
            FileAdministration.this.setSharedDirectories(cfg.mUploadDir);
            FileAdministration.this.setExclusions(cfg.mUploadFileExclusions);
            FileAdministration.this.setInclusions(cfg.mUploadFileInclusions);
            if (this.isInitialRescan) {
                FileAdministration.this.clearSharedFiles();
                this.buildSharedFilesCache();
            } else {
                this.removeUnsharedFiles();
            }
            FileAdministration.this.rwLock.readLock();
            try {
                Iterator iterator = ((AbstractList)FileAdministration.this.sharedDirectories).iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    this.scanDir(file, ServiceManager.sCfg.mUploadScanRecursively);
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    FileAdministration.this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                throw throwable;
            }
            try {
                FileAdministration.this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            FileAdministration.this.saveSharedLibrary();
        }

        private void buildSharedFilesCache() {
            this.sharedFilesCache = new HashMap();
            XMLSharedLibrary xMLSharedLibrary = FileAdministration.this.loadSharedLibrary();
            Iterator iterator = xMLSharedLibrary.createXMLSharedFileIterator();
            while (iterator.hasNext()) {
                XMLSharedFile xMLSharedFile = (XMLSharedFile)iterator.next();
                this.sharedFilesCache.put(xMLSharedFile.getFileName(), xMLSharedFile);
            }
        }

        private void scanDir(File file, boolean bl) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                Logger.logError((short)4, "'" + file + "' is not a directory.");
                return;
            }
            int n = 0;
            while (n < fileArray.length) {
                if (!FileAdministration.this.isFileInvalid(fileArray[n])) {
                    if (fileArray[n].isFile()) {
                        this.handleScannedFile(fileArray[n]);
                    } else if (fileArray[n].isDirectory() && bl) {
                        this.scanDir(fileArray[n], bl);
                    }
                }
                ++n;
            }
        }

        private void handleScannedFile(File file) {
            boolean bl = false;
            if (this.isInitialRescan) {
                ShareFile shareFile = new ShareFile(file);
                XMLSharedFile xMLSharedFile = (XMLSharedFile)this.sharedFilesCache.get(file.getAbsolutePath());
                if (xMLSharedFile != null && xMLSharedFile.getLastModified() == file.lastModified()) {
                    shareFile.updateFromCache(xMLSharedFile);
                } else {
                    shareFile.calculateURN();
                    bl = true;
                }
                FileAdministration.this.addSharedFile(shareFile);
            } else {
                ShareFile shareFile = FileAdministration.this.getFileByName(file.getAbsolutePath());
                if (shareFile == null) {
                    shareFile = new ShareFile(file);
                    shareFile.calculateURN();
                    bl = true;
                    FileAdministration.this.addSharedFile(shareFile);
                }
            }
            if (bl) {
                FileAdministration.this.saveSharedLibrary();
            }
        }

        private void removeUnsharedFiles() {
            FileAdministration.this.rwLock.readLock();
            try {
                int n = FileAdministration.this.sharedFiles.size() - 1;
                while (n >= 0) {
                    ShareFile shareFile = (ShareFile)FileAdministration.this.sharedFiles.get(n);
                    File file = shareFile.getFile();
                    if (!this.isInSharedDirectory(file) || !file.exists()) {
                        FileAdministration.this.removeSharedFile(shareFile);
                    }
                    --n;
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    FileAdministration.this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                throw throwable;
            }
            try {
                FileAdministration.this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }

        private boolean isInSharedDirectory(File file) {
            Iterator iterator = ((AbstractList)FileAdministration.this.sharedDirectories).iterator();
            while (iterator.hasNext()) {
                File file2 = (File)iterator.next();
                if (!FileUtils.isChildOfDir(file, file2)) continue;
                return true;
            }
            return false;
        }
    }
}

