/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import com.bitzi.bitprint.Base32;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import phex.ServiceManager;
import phex.common.URN;
import phex.share.FileAdministration;
import phex.utils.Logger;
import phex.utils.StrUtil;
import phex.xml.XMLSharedFile;

public class ShareFile {
    private static final String PHEX_FILE_NAME = StrUtil.getAppNameVersion();
    private int mFileIndex;
    private FileAdministration shareFileAdmin;
    private File file;
    private String fileName;
    private URN urn;
    private char[] searchCompareTerm;
    private Long fileSize;
    private Integer searchCount;
    private Integer uploadCount;

    private ShareFile() {
    }

    public ShareFile(File file) {
        this.file = file;
        if (this.file == null) {
            this.mFileIndex = -1;
            this.fileName = PHEX_FILE_NAME;
            this.fileSize = new Long(0L);
        } else {
            this.shareFileAdmin = ServiceManager.getShareManager().getFileAdministration();
            this.searchCount = new Integer(0);
            this.uploadCount = new Integer(0);
            this.fileName = this.file.getName();
            this.searchCompareTerm = this.file.getAbsolutePath().toLowerCase().toCharArray();
            this.fileSize = new Long(this.file.length());
        }
    }

    public URN getURN() {
        return this.urn;
    }

    public String getSHA1() {
        if (this.urn == null || !this.urn.isSha1Nid()) {
            return "";
        }
        return this.urn.getNamespaceSpecificString();
    }

    public File getFile() {
        return this.file;
    }

    public int getFileIndex() {
        return this.mFileIndex;
    }

    public void setFileIndex(int n) {
        this.mFileIndex = n;
    }

    public Long getFileSizeObject() {
        return this.fileSize;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public Integer getSearchCountObject() {
        return this.searchCount;
    }

    public int getSearchCount() {
        return this.searchCount;
    }

    public void incSearchCount() {
        this.searchCount = new Integer(this.searchCount + 1);
        this.shareFileAdmin.fireSharedFileChanged(this);
    }

    public Integer getUploadCountObject() {
        return this.uploadCount;
    }

    public int getUploadCount() {
        return this.uploadCount;
    }

    public void incUploadCount() {
        this.uploadCount = new Integer(this.uploadCount + 1);
        this.shareFileAdmin.fireSharedFileChanged(this);
    }

    public String getEffectiveName() {
        return this.fileName;
    }

    public char[] getSearchCompareTerm() {
        return this.searchCompareTerm;
    }

    public String toString() {
        return super.toString() + " " + this.fileName + "  " + this.mFileIndex;
    }

    public void updateFromCache(XMLSharedFile xMLSharedFile) {
        this.searchCount = new Integer(xMLSharedFile.getHitCount());
        this.uploadCount = new Integer(xMLSharedFile.getUploadCount());
        this.urn = new URN("urn:sha1:" + xMLSharedFile.getSha1());
    }

    public void calculateURN() {
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(this.file);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            byte[] byArray = new byte[65536];
            long l = System.currentTimeMillis();
            while ((n = fileInputStream.read(byArray)) != -1) {
                long l2 = System.currentTimeMillis();
                messageDigest.update(byArray, 0, n);
                long l3 = System.currentTimeMillis();
                try {
                    Thread.currentThread();
                    Thread.sleep((l3 - l2) * 2L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            fileInputStream.close();
            byte[] byArray2 = messageDigest.digest();
            long l4 = System.currentTimeMillis();
            this.urn = new URN("urn:sha1:" + Base32.encode(byArray2));
            Logger.logMessage(Logger.FINEST, (short)4, "SHA1 time: " + (l4 - l) + " size: " + this.file.length());
        }
        catch (IOException iOException) {
            Logger.logMessage(Logger.FINE, (short)4, iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Logger.logMessage(Logger.FINE, (short)4, noSuchAlgorithmException);
        }
    }
}

