/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import phex.ServiceManager;
import phex.common.TransferDataProvider;
import phex.host.Host;
import phex.share.UploadFileContainer;

public class UploadFile
implements TransferDataProvider {
    public static final int sIdle = 0;
    public static final int sQueued = 1;
    public static final int sUploading = 3;
    public static final int sCompleted = 4;
    public static final int sError = 5;
    public static final int sAborted = 6;
    private File mFile;
    private String mFilename;
    private Host mRemoteHost;
    private long mTransferLength;
    private long mFileSize;
    private String mRemoteAppName;
    private int mStatus = 0;
    private String mStatusText = "";
    private long mStatusTime;
    private String mLog = "";
    private long mTransferredSize = 0L;
    private int transferRate;
    private long startTime;
    private long stopTime;
    private long transferRateTimestamp;
    private int transferRateBytes;
    private UploadFileContainer uploadContainer;
    private Integer currentProgress;

    public UploadFile(File file, Host host, long l, String string) {
        this.mFile = file;
        this.mRemoteHost = host;
        this.mTransferLength = l;
        this.mRemoteAppName = string;
        this.transferRate = 0;
        this.transferRateTimestamp = 0L;
        this.transferRateBytes = 0;
        this.startTime = 0L;
        this.mFilename = this.mFile.getName();
        this.mFileSize = this.mFile.length();
        this.uploadContainer = ServiceManager.getShareManager().getUploadFileContainer();
        this.currentProgress = new Integer(0);
    }

    public File getFile() {
        return this.mFile;
    }

    public String getFilename() {
        return this.mFilename;
    }

    public Host getRemoteHost() {
        return this.mRemoteHost;
    }

    public long getTransferDataSize() {
        return this.mTransferLength;
    }

    public long getTotalDataSize() {
        return this.getTransferDataSize();
    }

    public Integer getProgress() {
        int n;
        if (this.mStatus == 4) {
            n = 100;
        } else {
            long l = this.getTransferDataSize();
            n = (int)(this.getTransferredDataSize() * 100L / (l == 0L ? 1L : l));
        }
        if (this.currentProgress != n) {
            this.currentProgress = new Integer(n);
        }
        return this.currentProgress;
    }

    public String getRemoteAppName() {
        return this.mRemoteAppName;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public short getDataTransferStatus() {
        switch (this.mStatus) {
            case 3: {
                return 10;
            }
            case 5: 
            case 6: {
                return 13;
            }
            case 4: {
                return 12;
            }
        }
        return 11;
    }

    public String getStatusName() {
        switch (this.mStatus) {
            case 0: {
                return "Idle";
            }
            case 1: {
                return "Queued";
            }
            case 3: {
                return "Uploading";
            }
            case 4: {
                return "Completed";
            }
            case 5: {
                return "Error " + this.mStatusText;
            }
            case 6: {
                return "Aborted";
            }
        }
        return "Unknown";
    }

    public void setStatus(int n) {
        this.setStatus(n, "");
    }

    public void setStatus(int n, String string) {
        this.mStatus = n;
        this.mStatusText = string;
        this.mStatusTime = System.currentTimeMillis();
        this.uploadContainer.fireUploadFileChanged(this);
    }

    public void setLog(String string) {
        this.mLog = string;
    }

    public void appendLog(String string) {
        this.mLog = this.mLog != null ? this.mLog + string + "\n" : string + "\n";
    }

    public String getLog() {
        return this.mLog;
    }

    public void setStartingTime(long l) {
        this.transferRateTimestamp = l;
        this.startTime = l;
        this.stopTime = 0L;
    }

    public void setStoppingTime(long l) {
        if (this.stopTime == 0L) {
            this.stopTime = l;
        }
    }

    public long getTransferredDataSize() {
        return this.mTransferredSize;
    }

    public long getTransferTimeInSeconds() {
        if (this.stopTime != 0L) {
            return (this.stopTime - this.startTime) / 1000L;
        }
        return (System.currentTimeMillis() - this.startTime) / 1000L;
    }

    public int getLongTermTransferRate() {
        long l = this.stopTime != 0L ? (this.stopTime - this.startTime) / 1000L : (System.currentTimeMillis() - this.startTime) / 1000L;
        return (int)(this.getTransferredDataSize() / (l + 1L));
    }

    public void setTransferredDataSize(long l) {
        long l2 = l - this.mTransferredSize;
        this.transferRateBytes = (int)((long)this.transferRateBytes + l2);
        this.mTransferredSize = l;
        this.uploadContainer.fireUploadFileChanged(this);
    }

    public void setTransferRateTimestamp(long l) {
        this.transferRateTimestamp = l;
        this.transferRateBytes = 0;
    }

    public int getShortTermTransferRate() {
        if (this.transferRateTimestamp != 0L) {
            double d = (double)(System.currentTimeMillis() - this.transferRateTimestamp) / 1000.0;
            if ((this.transferRateBytes > 0 || d > 1.0) && d != 0.0) {
                this.transferRate = (int)((double)this.transferRateBytes / d);
            }
        }
        return this.transferRate;
    }

    public synchronized void abortUpload() {
        this.setStatus(6);
        this.mRemoteHost.disconnect();
    }
}

