/*
 * Decompiled with CFR 0.152.
 */
package phex.update;

import java.net.MalformedURLException;
import java.net.URL;
import phex.Res;
import phex.ServiceManager;
import phex.connection.HTTPURLRequest;
import phex.event.UpdateNotificationListener;
import phex.utils.VersionUtils;

public class UpdateChecker {
    private static final long ONE_WEEK_MILLIS = 604800000L;
    private static final String updateURL = "http://www.kouk.de/phex/update.cfg";
    private String updateVersion;
    private UpdateNotificationListener listener;

    public UpdateChecker(UpdateNotificationListener updateNotificationListener) {
        this.listener = updateNotificationListener;
    }

    public void setShowUpdateNotification(boolean bl) {
        if (ServiceManager.sCfg.showUpdateNotification != bl) {
            ServiceManager.sCfg.showUpdateNotification = bl;
            ServiceManager.sCfg.save();
        }
    }

    public String getUpdateVersion() {
        return this.updateVersion;
    }

    public void checkForUpdate() {
        if (ServiceManager.sCfg.lastUpdateCheckTime > System.currentTimeMillis() - 604800000L) {
            return;
        }
        Thread thread = new Thread((Runnable)new UpdateCheckRunner(), "UpdateCheckRunner");
        thread.setDaemon(true);
        thread.start();
    }

    private void fireUpdateNotification() {
        this.listener.updateNotification(this);
    }

    private class UpdateCheckRunner
    implements Runnable {
        private UpdateCheckRunner() {
        }

        public void run() {
            URL uRL;
            try {
                uRL = new URL(UpdateChecker.updateURL);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                throw new RuntimeException();
            }
            String string = HTTPURLRequest.loadPage(uRL);
            if (string == null) {
                return;
            }
            if ((string = string.trim()).length() == 0) {
                return;
            }
            UpdateChecker.this.updateVersion = string;
            ServiceManager.sCfg.lastUpdateCheckTime = System.currentTimeMillis();
            int n = VersionUtils.compare(UpdateChecker.this.updateVersion, Res.getStr("Program.Version"));
            if (n <= 0 || !ServiceManager.sCfg.showUpdateNotification) {
                ServiceManager.sCfg.save();
                return;
            }
            n = VersionUtils.compare(UpdateChecker.this.updateVersion, ServiceManager.sCfg.lastUpdateCheckVersion);
            if (n > 0) {
                ServiceManager.sCfg.lastUpdateCheckVersion = UpdateChecker.this.updateVersion;
                UpdateChecker.this.fireUpdateNotification();
            }
            ServiceManager.sCfg.save();
        }
    }
}

