/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.NoSuchElementException;

public class CircularQueue {
    private int size;
    private Object[] elements;
    private int headIdx;
    private int tailIdx;

    public CircularQueue(int n) {
        if (n < 1) {
            throw new RuntimeException("Min size of the CircularQueue is 1");
        }
        this.size = n + 1;
        this.elements = new Object[this.size];
        this.tailIdx = 0;
        this.headIdx = 0;
    }

    public void addToTail(Object object) {
        if (this.isFull()) {
            this.removeFromHead();
        }
        this.elements[this.tailIdx] = object;
        this.tailIdx = this.nextIndex(this.tailIdx);
    }

    public void addToHead(Object object) {
        if (this.isFull()) {
            this.removeFromTail();
        }
        this.headIdx = this.prevIndex(this.headIdx);
        this.elements[this.headIdx] = object;
    }

    public void clear() {
        this.headIdx = 0;
        this.tailIdx = 0;
    }

    public Object getFirst() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements[this.headIdx];
    }

    public Object getLast() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int n = this.prevIndex(this.tailIdx);
        return this.elements[n];
    }

    public Object get(int n) throws IndexOutOfBoundsException {
        int n2 = this.mapIndex(n);
        return this.elements[n2];
    }

    public int getSize() {
        if (this.headIdx <= this.tailIdx) {
            return this.tailIdx - this.headIdx;
        }
        return this.size - this.headIdx + this.tailIdx;
    }

    public int getCapacity() {
        return this.size - 1;
    }

    public boolean isEmpty() {
        return this.headIdx == this.tailIdx;
    }

    public boolean isFull() {
        return this.nextIndex(this.tailIdx) == this.headIdx;
    }

    public Object removeFromHead() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object object = this.elements[this.headIdx];
        this.headIdx = this.nextIndex(this.headIdx);
        return object;
    }

    public Object removeFromTail() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.tailIdx = this.prevIndex(this.tailIdx);
        Object object = this.elements[this.tailIdx];
        return object;
    }

    private int mapIndex(int n) throws IndexOutOfBoundsException {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return (n + this.headIdx) % this.size;
    }

    private int nextIndex(int n) {
        if (n == this.size - 1) {
            return 0;
        }
        return n + 1;
    }

    private int prevIndex(int n) {
        if (n == 0) {
            return this.size - 1;
        }
        return n - 1;
    }
}

