/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import phex.common.FileHandlingException;
import phex.utils.StrUtil;

public final class FileUtils {
    private static final int BUFFER_LENGTH = 1024;

    private FileUtils() {
    }

    public static String convertToLocalSystemFilename(String string) {
        string = StrUtil.replaceAllChar(string, '/', "_");
        return StrUtil.makeShortName(string, 255);
    }

    public static void appendFile(File file, File file2) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        randomAccessFile.seek(randomAccessFile.length());
        byte[] byArray = new byte[1024];
        while ((n = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
            randomAccessFile.write(byArray, 0, n);
        }
        randomAccessFile.close();
        bufferedInputStream.close();
        file2.delete();
    }

    public static void copyFile(File file, File file2) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        byte[] byArray = new byte[1024];
        while ((n = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.close();
        bufferedInputStream.close();
    }

    public static void renameLocalFile(File file, File file2) throws FileHandlingException {
        if (file2.exists()) {
            throw new FileHandlingException(1);
        }
        if (file.exists() && !file.renameTo(file2)) {
            throw new FileHandlingException(0);
        }
    }

    public static void truncateFile(File file, long l) throws IOException {
        if (file.exists() && file.length() > l) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rwd");
            randomAccessFile.setLength(l);
            randomAccessFile.close();
        }
    }

    public static boolean isChildOfDir(File file, File file2) {
        if (!file.getAbsolutePath().startsWith(file2.getAbsolutePath())) {
            return false;
        }
        return FileUtils.isChildOfDirInternal(file, file2);
    }

    private static boolean isChildOfDirInternal(File file, File file2) {
        File file3 = file.getParentFile();
        if (file3 == null) {
            return false;
        }
        if (file3.equals(file2)) {
            return true;
        }
        return FileUtils.isChildOfDirInternal(file3, file2);
    }
}

