<?php
  /**************************************************************************\
  * phpGroupWare - DJ mp3 directories                                        *
  * http://www.phpgroupware.org                                              *
  * Written by Bettina Gille [ceb@phpgroupware.org]                          *
  * -----------------------------------------------                          *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/
  /* $Id: directories.php,v 1.3 2001/05/11 15:01:03 milosch Exp $ */

	$phpgw_info["flags"] = array(
		'currentapp' => 'dj',
		'enable_nextmatchs_class' => True
	);

	include('../header.inc.php');

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);

	$t->set_file(array('dir_list_t'   => 'listdirectories.tpl'));
	$t->set_block('dir_list_t','dir_list','list');

	$common_hidden_vars = "<input type=\"hidden\" name=\"sort\" value=\"$sort\">\n"
		. "<input type=\"hidden\" name=\"order\" value=\"$order\">\n"
		. "<input type=\"hidden\" name=\"query\" value=\"$query\">\n"
		. "<input type=\"hidden\" name=\"start\" value=\"$start\">\n"
		. "<input type=\"hidden\" name=\"filter\" value=\"$filter\">\n";

	$t->set_var('lang_action',lang('Directory List'));
	$t->set_var('add_action',$phpgw->link('/dj/adddirectory.php'));
	$t->set_var('lang_add',lang('Add'));
	$t->set_var('title_directories',lang('Directories'));
	$t->set_var('lang_search',lang('Search'));
	$t->set_var('actionurl',$phpgw->link('/dj/directories.php'));
	$t->set_var('lang_done',lang('Done'));
	$t->set_var('doneurl',$phpgw->link('/preferences/index.php'));

	if (! $start) { $start = 0; }

	if($phpgw_info["user"]["preferences"]["common"]["maxmatchs"] && $phpgw_info["user"]["preferences"]["common"]["maxmatchs"] > 0)
	{
		$limit = $phpgw_info["user"]["preferences"]["common"]["maxmatchs"];
	}
	else
	{
		$limit = 15;
	}

	if (!$sort) { $sort = "ASC";  }

	if ($query)
	{
		$querymethod = " WHERE dir_name like '%$query%'";
	}

	$db2 = $phpgw->db;

	$sql = "SELECT * FROM phpgw_dj_directories $querymethod  order by dir_name $sort";
	$db2->query($sql,__LINE__,__FILE__);
	$total_records = $db2->num_rows();
	$phpgw->db->query($sql . " " . $phpgw->db->limit($start),__LINE__,__FILE__);
	while ($phpgw->db->next_record())
	{
		$directory[] = array(
			'dir_id'   => $phpgw->db->f('dir_id'),
			'dir_name' => $phpgw->db->f('dir_name')
		);
	}

	//--------------------------------- nextmatch --------------------------------------------
	$left = $phpgw->nextmatchs->left('/dj/directories.php',$start,$total_records);
	$right = $phpgw->nextmatchs->right('/dj/directories.php',$start,$total_records);
	$t->set_var('left',$left);
	$t->set_var('right',$right);

	if ($total_records > $limit)
	{
		$t->set_var('lang_showing',lang("showing x - x of x",($start + 1),($start + $limit),$total_records));
	}
	else
	{
		$t->set_var('lang_showing',lang("showing x",$total_records));
	}

	//------------------------------ end nextmatch ------------------------------------------

	//------------------- list header variable template-declarations ------------------------- 
	$t->set_var('th_bg',$phpgw_info["theme"][th_bg]);
	$t->set_var('name',lang('Directory Name'));
	$t->set_var('lang_edit',lang('Edit'));
	$t->set_var('lang_delete',lang('Delete'));

	//-------------------------- end header declaration --------------------------------------
	@reset($directory);
	while (list($key,$dirinfo) = @each($directory))
	{
		$tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);
		$t->set_var(tr_color,$tr_color);
		$dir_id = $dirinfo['dir_id'];
		$dir_name = $phpgw->strip_html($dirinfo['dir_name']);
		//-------------------------- template declaration for list records ---------------------------
		$t->set_var('dir_name',$dir_name);

		$t->set_var('edit',$phpgw->link('/dj/editdirectory.php',"dir_id=$dir_id&start=$start&query=$query&sort=$sort&order=$order&filter=$filter"));
		$t->set_var('lang_edit_entry',lang('Edit'));

		$t->set_var('delete',$phpgw->link('/dj/deletedirectory.php',"dir_id=$dir_id&start=$start&query=$query&sort=$sort&order=$order&filter=$filter"));
		$t->set_var('lang_delete_entry',lang('Delete'));
		$t->parse('list','dir_list',True);
	}
	// ---------------------------- end record declaration -----------------------------------------

	$t->parse('out','dir_list_t',True);
	$t->p('out');

	$phpgw->common->phpgw_footer();
?>
