<?php
   /**
    **  index.php
    **
    **  Copyright (c) 1999-2000 The SquirrelMail development team
    **  Licensed under the GNU GPL. For full terms see the file COPYING.
    **
    **  This is where the mailboxes are listed.  This controls most of what
    **  goes on in SquirrelMail.
    **
    **  $Id: index.php,v 1.11 2001/05/21 03:35:43 skeeter Exp $
    **/

   $enablePHPGW = 1;

	// store the value of $mailbox, because it will overwriten
	$MAILBOX = $mailbox;
	$phpgw_info["flags"] = array("currentapp" => "squirrelmail", "enable_network_class" => True, "enable_nextmatchs_class" => True);
	include("../header.inc.php");
	$mailbox = $MAILBOX;
	$show_num = $phpgw_info['user']['preferences']['common']['maxmatchs'];

	$phpgw->session->restore();

	// to be fixed
	#$base_uri = PHPGW_APP_ROOT;
	#$phpgw->session->register("base_uri");

   if (!isset($i18n_php))
      include(PHPGW_APP_ROOT . "/inc/i18n.php");
   if (!isset($strings_php))
      include(PHPGW_APP_ROOT . "/inc/strings.php");
   if (!isset($config_php))
      include(PHPGW_APP_ROOT . "/config/config.php");

	$key      = $phpgw_info["user"]["preferences"]["email"]["passwd"];
	$username = $phpgw_info["user"]["preferences"]["email"]["userid"];

   if (!isset($imap_php))
      include(PHPGW_APP_ROOT . "/inc/imap.php");
   if (!isset($date_php))
      include(PHPGW_APP_ROOT . "/inc/date.php");
   if (!isset($page_header_php))
      include(PHPGW_APP_ROOT . "/inc/page_header.php");
   if (!isset($array_php))
      include(PHPGW_APP_ROOT . "/inc/array.php");
   if (!isset($mime_php))
      include(PHPGW_APP_ROOT . "/inc/mime.php");
   if (!isset($mailbox_display_php))
      include(PHPGW_APP_ROOT . "/inc/mailbox_display.php");
   if (!isset($display_messages_php))
      include(PHPGW_APP_ROOT . "/inc/display_messages.php");
?>
<?php
   /////////////////////////////////////////////////////////////////////////////////
   //
   // incoming variables from URL:
   //    $sort             Direction to sort by date
   //                         values:  0  -  descending order
   //                         values:  1  -  ascending order
   //    $startMessage     Message to start at
   //    $mailbox          Full Mailbox name
   //
   // incoming from cookie:
   //    $username         duh
   //    $key              pass
   //
   /////////////////////////////////////////////////////////////////////////////////


   // open a connection on the imap port (143)
   $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
   /** If it was a successful login, lets load their preferences **/
   include(PHPGW_APP_ROOT . "/src/load_prefs.php");

   if (isset($newsort) && $newsort != $sort) {
      setPref($data_dir, $username, "sort", $newsort);
   }

   // If the page has been loaded without a specific mailbox,
   //   send them to the inbox
   if (!isset($mailbox)) {
      $mailbox = "INBOX";
      $startMessage = 1;
   }

   // compensate for the UW vulnerability
   if ($imap_server_type == "uw" && strstr($mailbox, "../")) {
      $mailbox = "INBOX";
   }

   sqimap_mailbox_select($imapConnection, $mailbox);
   displayPageHeader($color, $mailbox);

   do_hook("right_main_after_header");
   
   if (isset($just_logged_in) && $just_logged_in == 1 && 
       strlen(trim($motd)) > 0) {
      echo "<center><br>\n";
      echo "<table width=70% cellpadding=0 cellspacing=0 border=0><tr><td bgcolor=\"$color[9]\">\n";
      echo "<table width=100% cellpadding=5 cellspacing=1 border=0><tr><td bgcolor=\"$color[4]\">\n";
      echo "$motd\n";
      echo "</td></tr></table>\n";
      echo "</td></tr></table>\n";
      echo "</center><br>\n";
   }

	if (isset($newsort)) {
		$sort = $newsort;
		if ($enablePHPGW)
		{
			$phpgw->session->register("sort");
		}
		else
		{
			session_register("sort");
		}
	}	

   // Check to see if we can use cache or not.  Currently the only time when you wont use it is
   //    when a link on the left hand frame is used.  Also check to make sure we actually have the
   //    array in the registered session data.  :)
   if (! isset($use_mailbox_cache))
       $use_mailbox_cache = 0;
   if (!$enablePHPGW)
   {
   	if ($use_mailbox_cache && session_is_registered("msgs")) 
   	{
   		showMessagesForMailbox($imapConnection, $mailbox, $numMessages, $startMessage, $sort, $color, $show_num, $use_mailbox_cache);
   	} 
   	else 
   	{
   	   	if (session_is_registered("msgs")) 
   	   		unset($msgs);
   	   	if (session_is_registered("msort"))
   		      	unset($msort);
		if (session_is_registered("numMessages"))
			unset($numMessages);

      		$numMessages = sqimap_get_num_messages ($imapConnection, $mailbox);

      		showMessagesForMailbox($imapConnection, $mailbox, $numMessages, $startMessage, $sort, $color, $show_num, $use_mailbox_cache);
      
      		if (session_is_registered("msgs") && isset($msgs))
      	   		session_register("msgs");
      		if (session_is_registered("msort") && isset($msort))
      	   		session_register("msort");
      		session_register("numMessages");
   	}
   }
   else
   {
   	if ($use_mailbox_cache && $phpgw->session->is_registered("msgs")) 
   	{
   		showMessagesForMailbox($imapConnection, $mailbox, $numMessages, $startMessage, $sort, $color, $show_num, $use_mailbox_cache);
   	} 
   	else 
   	{
   	   	if ($phpgw->session->is_registered("msgs")) 
   	   		unset($msgs);
   	   	if ($phpgw->session->is_registered("msort"))
   		      	unset($msort);
		if ($phpgw->session->is_registered("numMessages"))
			unset($numMessages);

      		$numMessages = sqimap_get_num_messages ($imapConnection, $mailbox);

      		showMessagesForMailbox($imapConnection, $mailbox, $numMessages, $startMessage, $sort, $color, $show_num, $use_mailbox_cache);

      		if ($phpgw->session->is_registered("msgs") && isset($msgs))
      	   		$phpgw->session->register("msgs");
      		if ($phpgw->session->is_registered("msort") && isset($msort))
      	   		$phpgw->session->register("msort");
      		$phpgw->session->register("numMessages");
   	}
   }

   do_hook("right_main_bottom");
   sqimap_logout ($imapConnection);

	$phpgw->session->save();
	$phpgw->common->phpgw_footer();

?>
