<?php
  /**************************************************************************\
  * phpGroupWare - Calendar                                                  *
  * http://www.phpgroupware.org                                              *
  * Based on Webcalendar by Craig Knudsen <cknudsen@radix.net>               *
  *          http://www.radix.net/~cknudsen                                  *
  * Modified by Mark Peters <skeeter@phpgroupware.org>                       *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

	/* $Id: search.php,v 1.24 2001/05/21 11:12:58 skeeter Exp $ */

	$phpgw_flags = Array(
		'currentapp'		=>	'calendar',
		'enable_nextmatchs_class'	=>	True,
		'noheader'	=> True,
		'nonavbar'	=> True
	);
	$phpgw_info['flags'] = $phpgw_flags;
	include('../header.inc.php');
	if (! $keywords)
	{
		// If we reach this, it is because they didn't search for anything,
		// attempt to send them back to where they where.
		Header('Location: ' . $phpgw->link($from,'owner='.$owner.'&month='.$month.'&day='.$day.'&year='.$year));
	}
	else
	{
		$phpgw->common->phpgw_header();
		echo parse_navbar();
	}
	
	$error = '';

	if (strlen($keywords) == 0)
	{
		echo '<b>'.lang('Error').':</b>';
		echo lang('You must enter one or more search keywords.');
		$phpgw->common->phpgw_footer();
		$phpgw->common->phpgw_exit();
	}
	
	$matches = 0;

	$phpgw->calendar->set_filter();

	// There is currently a problem searching in with repeated events.
	// It spits back out the date it was entered.  I would like to to say that
	// it is a repeated event.
	$ids = array();
	$words = split(' ',$keywords);
	for ($i=0;$i<count($words);$i++)
	{
		$sql = "AND (UPPER(phpgw_cal.title) LIKE UPPER('%".$words[$i]."%') OR "
				. " UPPER(phpgw_cal.description) LIKE UPPER('%".$words[$i]."%')) ";

// Private
		if(strpos($phpgw->calendar->filter,'private'))
		{
			$sql .= "AND phpgw_cal.is_public=0 ";
		}
		
		$sql .= 'ORDER BY phpgw_cal.datetime ASC, phpgw_cal.edatetime ASC, phpgw_cal.priority ASC';

		$events = $phpgw->calendar->get_event_ids(False,$sql);

		if($events == False)
		{
			$matches = 0;
		}
		else
		{
			$phpgw->calendar->open('INBOX',intval($owner),'');
			for($i=0;$i<count($events);$i++)
			{
				$event = $phpgw->calendar->fetch_event($events[$i]);
				
				$datetime = mktime($event->start->hour,$event->start->min,$event->start->sec,$event->start->month,$event->start->mday,$event->start->year) - $phpgw->calendar->datetime->tz_offset;
				
				$ids[strval($event->id)]++;
				$info[strval($event->id)] = $phpgw->common->show_date($datetime).$phpgw->calendar->link_to_entry($event,$event->start->month,$event->start->mday,$event->start->year);

			}
			$matches = count($events);
		}
	}

	if ($matches > 0)
	{
		$matches = count($ids);
	}

	if ($matches == 1)
	{
		$quantity = lang('1 match found').'.';
	}
	elseif ($matches > 0)
	{
		$quantity = lang('x matches found',$matches).'.';
	}
	else
	{
		echo '<b>'.lang('Error').':</b>';
		echo lang('no matches found.');
		$phpgw->common->phpgw_footer();
		$phpgw->common->phpgw_exit();
	}

	$p = CreateObject('phpgwapi.Template',$phpgw->calendar->template_dir);
	$templates = Array(
		'search_form'		=>	'search.tpl'
	);
	$p->set_file($templates);
	$p->set_block('search_form','search','search');
	$p->set_block('search_form','search_list_header','search_list_header');
	$p->set_block('search_form','search_list','search_list');
	$p->set_block('search_form','search_list_footer','search_list_footer');
	
	$var = Array(
		'color'		=>	$phpgw_info['theme']['bg_text'],
		'search_text'	=>	lang('Search Results'),
		'quantity'	=>	$quantity
	);

	$p->set_var($var);

	if($matches > 0)
	{
		$p->parse('rows','search_list_header',True);
	}
	// now sort by number of hits
	arsort($ids);
	for(reset($ids);$key=key($ids);next($ids))
	{
		$p->set_var('result_desc',$info[$key]);
		$p->parse('rows','search_list',True);
	}
	
	if($matches > 0)
	{
		$p->parse('rows','search_list_footer',True);
	}

	$p->pparse('out','search');

	$phpgw->common->phpgw_footer();
?>
