<?php
  /**************************************************************************\
  * phpGroupWare - Preferences - categories                                  *
  * http://www.phpgroupware.org                                              *
  * Written by Bettina Gille [ceb@phpgroupware.org]                          *
  * -----------------------------------------------                          *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/
  /* $Id: class.uicategories.inc.php,v 1.2.2.7 2002/10/30 16:59:46 ralfbecker Exp $ */

	class uicategories
	{
		var $bo;
		var $t;

		var $start;
		var $query;
		var $sort;
		var $order;
		var $cat_id;

		var $public_functions = array
		(
			'index'  => True,
			'add'    => True,
			'edit'   => True,
			'delete' => True
		);

		function uicategories()
		{
			//$this->bo       = CreateObject('preferences.bocategories',$cats_app);
			$this->bo         = CreateObject('preferences.bocategories');
			$this->t          = $GLOBALS['phpgw']->template;
			$this->nextmatchs = CreateObject('phpgwapi.nextmatchs');
			$this->account    = $GLOBALS['phpgw_info']['user']['account_id'];
			$this->user       = $GLOBALS['phpgw_info']['user']['fullname'];

			$this->start = $this->bo->start;
			$this->query = $this->bo->query;
			$this->sort  = $this->bo->sort;
			$this->order = $this->bo->order;
		}

		function save_sessiondata($cats_app)
		{
			$data = array
			(
				'start' => $this->start,
				'query' => $this->query,
				'sort'  => $this->sort,
				'order' => $this->order
			);
			$this->bo->save_sessiondata($data,$cats_app);
		}

		function set_langs()
		{
			$this->t->set_var('th_bg',$GLOBALS['phpgw_info']['theme']['th_bg']);
			$this->t->set_var('lang_access',lang('Private'));
			$this->t->set_var('lang_save',lang('Save'));
			$this->t->set_var('user_name',$this->user);
			$this->t->set_var('lang_search',lang('Search'));
			$this->t->set_var('lang_done',lang('Done'));
			$this->t->set_var('lang_sub',lang('Add sub'));
			$this->t->set_var('lang_edit',lang('Edit'));
			$this->t->set_var('lang_delete',lang('Delete'));
			$this->t->set_var('lang_parent',lang('Parent category'));
			$this->t->set_var('lang_none',lang('None'));
			$this->t->set_var('lang_name',lang('Name'));
			$this->t->set_var('lang_descr',lang('Description'));
			$this->t->set_var('lang_add',lang('Add'));
			$this->t->set_var('lang_reset',lang('Clear Form'));
		}

		function cat_data($edata,$data)
		{
			for ($j=0;$j<count($edata);$j++)
			{
				$td_data .= '<td>' . $data[$edata[$j]] . '</td>' . "\n";
			}
			return $td_data;
		}

		function index()
		{
			$cats_app    = $GLOBALS['HTTP_GET_VARS']['cats_app'] ? $GLOBALS['HTTP_GET_VARS']['cats_app'] : $GLOBALS['HTTP_POST_VARS']['cats_app'];
			$extra       = $GLOBALS['HTTP_GET_VARS']['extra'] ? $GLOBALS['HTTP_GET_VARS']['extra'] : $GLOBALS['HTTP_POST_VARS']['extra'];
			$global_cats = $GLOBALS['HTTP_GET_VARS']['global_cats'] ? $GLOBALS['HTTP_GET_VARS']['global_cats'] : $GLOBALS['HTTP_POST_VARS']['global_cats'];
			$cats_level  = $GLOBALS['HTTP_GET_VARS']['cats_level'] ? $GLOBALS['HTTP_GET_VARS']['cats_level'] : $GLOBALS['HTTP_POST_VARS']['global_cats'];

			$link_data = array
			(
				'menuaction'  => 'preferences.uicategories.index',
				'cats_app'    => $cats_app,
				'extra'       => $extra,
				'global_cats' => $global_cats,
				'cats_level'  => $cats_level
			);

			if($extra)
			{
				$edata = explode(',',$extra);
			}

			$GLOBALS['phpgw']->common->phpgw_header();
			echo parse_navbar();

			$this->t->set_file(array(
				'cat_list_t'  => 'listcats.tpl',
				'data_column' => 'listcats.tpl'
			));
			$this->t->set_block('cat_list_t','data_column','column');
			$this->t->set_block('cat_list_t','cat_list','list');

			$this->set_langs();

			$this->t->set_var('title_categories',lang('categories for'));
			$this->t->set_var('lang_app',lang($cats_app));
			$this->t->set_var('actionurl',$GLOBALS['phpgw']->link('/index.php',$link_data));
			$this->t->set_var('doneurl',$GLOBALS['phpgw']->link('/preferences/index.php'));

			if(!$this->start)
			{
				$this->start = 0;
			}

			if(!$global_cats)
			{
				$global_cats = False;
			}

			$this->bo->cats->app_name = $cats_app;
			$cats = $this->bo->get_list($global_cats);

//--------------------------------- nextmatch --------------------------------------------

			$left  = $this->nextmatchs->left('/index.php',$this->start,$this->bo->cats->total_records,$link_data);
			$right = $this->nextmatchs->right('/index.php',$this->start,$this->bo->cats->total_records,$link_data);
			$this->t->set_var('left',$left);
			$this->t->set_var('right',$right);

			$this->t->set_var('lang_showing',$this->nextmatchs->show_hits($this->bo->cats->total_records,$this->start));

// ------------------------------ end nextmatch ------------------------------------------

//------------------- list header variable template-declarations ------------------------- 

			$this->t->set_var('sort_name',$this->nextmatchs->show_sort_order($this->sort,'cat_name',$this->order,'/index.php',lang('Name'),$link_data));
			$this->t->set_var('sort_description',$this->nextmatchs->show_sort_order($this->sort,'cat_description',$this->order,'/index.php',lang('Description'),$link_data));

			if (is_array($edata))
			{
				for($i=0;$i<count($edata);$i++)
				{
					$this->t->set_var('th_data','<td bgcolor="' . $GLOBALS['phpgw_info']['theme']['th_bg'] . '">' . lang($edata[$i]) . '</td>');
					$this->t->fp('column','data_column',True);
				}
			}
			else
			{
				$this->t->set_var('th_data','');
			}

// -------------------------- end header declaration --------------------------------------

			for ($i=0;$i<count($cats);$i++)
			{
				$this->nextmatchs->template_alternate_row_color(&$this->t);

				if ($cats[$i]['app_name'] == 'phpgw')
				{
					$appendix = '&lt;' . lang('Global') . '&gt;';
				}
				elseif ($cats[$i]['owner'] == '-1')
				{
					$appendix = '&lt;' . lang('Global') . '&nbsp;' . $GLOBALS['phpgw_info']['apps'][$cats_app]['title'] . '&gt;';
				}
				else
				{
					$appendix = '';
				}

				$level = $cats[$i]['level'];

				if ($level > 0)
				{
					$space = '&nbsp;&nbsp;';
					$spaceset = str_repeat($space,$level);
					$name = $spaceset . $GLOBALS['phpgw']->strip_html($cats[$i]['name']) . $appendix;
				}

				$descr = $GLOBALS['phpgw']->strip_html($cats[$i]['description']);
				if (!$descr) { $descr = '&nbsp;'; }

				if (is_array($edata))
				{
					$data = unserialize($cats[$i]['data']);
					if (! is_array($data))
					{
						$holder = '<td>&nbsp;</td>' . "\n";
						$placeholder = str_repeat($holder,count($edata));
						$this->t->set_var('td_data',$placeholder);
					}
					else
					{
						$this->t->set_var('td_data',$this->cat_data($edata,$data));
					}
				}

				if ($level == 0)
				{
					$name = '<font color="FF0000"><b>' . $GLOBALS['phpgw']->strip_html($cats[$i]['name']) . '</b></font>' . $appendix;
					$descr = '<font color="FF0000"><b>' . $descr . '</b></font>';
				}

				$this->t->set_var(array(
					'name'  => $name,
					'descr' => $descr
				));

				$this->t->set_var('app_url',$GLOBALS['phpgw']->link('/' . $cats_app . '/index.php','cat_id=' . $cats[$i]['id']));

				if ($cats_level || ($level == 0))
				{
					if ($cats[$i]['owner'] == $this->account || $cats[$i]['app_name'] == 'phpgw')
					{
						$link_data['menuaction'] = 'preferences.uicategories.add';
						$link_data['cat_parent'] = $cats[$i]['id'];
						$this->t->set_var('add_sub',$GLOBALS['phpgw']->link('/index.php',$link_data));
						$this->t->set_var('lang_sub_entry',lang('Add sub'));
					}
				}
				else
				{
					$this->t->set_var('add_sub','');
					$this->t->set_var('lang_sub_entry','&nbsp;');
				}

				$link_data['cat_id'] = $cats[$i]['id'];
				if ($cats[$i]['owner'] == $this->account && $cats[$i]['app_name'] != 'phpgw')
				{
					$link_data['menuaction'] = 'preferences.uicategories.edit';
					$this->t->set_var('edit',$GLOBALS['phpgw']->link('/index.php',$link_data));
					$this->t->set_var('lang_edit_entry',lang('Edit'));

					$link_data['menuaction'] = 'preferences.uicategories.delete';
					$this->t->set_var('delete',$GLOBALS['phpgw']->link('/index.php',$link_data));
					$this->t->set_var('lang_delete_entry',lang('Delete'));
				}
				else
				{
					$this->t->set_var('edit','');
					$this->t->set_var('lang_edit_entry','&nbsp;');

					$this->t->set_var('delete','');
					$this->t->set_var('lang_delete_entry','&nbsp;');
				}
				$this->t->fp('list','cat_list',True);
			}
			$link_data['menuaction'] = 'preferences.uicategories.add';
			$this->t->set_var('add_action',$GLOBALS['phpgw']->link('/index.php',$link_data));
			$this->save_sessiondata($cats_app);

			$this->t->pfp('out','cat_list_t',True);
		}

		function add()
		{
			$cats_app    = $GLOBALS['HTTP_GET_VARS']['cats_app'] ? $GLOBALS['HTTP_GET_VARS']['cats_app'] : $GLOBALS['HTTP_POST_VARS']['cats_app'];
			$extra       = $GLOBALS['HTTP_GET_VARS']['extra'] ? $GLOBALS['HTTP_GET_VARS']['extra'] : $GLOBALS['HTTP_POST_VARS']['extra'];
			$global_cats = $GLOBALS['HTTP_GET_VARS']['global_cats'] ? $GLOBALS['HTTP_GET_VARS']['global_cats'] : $GLOBALS['HTTP_POST_VARS']['global_cats'];
			$cats_level  = $GLOBALS['HTTP_GET_VARS']['cats_level'] ? $GLOBALS['HTTP_GET_VARS']['cats_level'] : $GLOBALS['HTTP_POST_VARS']['global_cats'];

			$link_data = array
			(
				'menuaction'  => 'preferences.uicategories.add',
				'cats_app'    => $cats_app,
				'extra'       => $extra,
				'global_cats' => $global_cats,
				'cats_level'  => $cats_level
			);

			$GLOBALS['phpgw']->common->phpgw_header();
			echo parse_navbar();

			$new_parent      = $GLOBALS['HTTP_POST_VARS']['new_parent'];
			$submit          = $GLOBALS['HTTP_POST_VARS']['submit'];
			$cat_parent      = $GLOBALS['HTTP_POST_VARS']['cat_parent'] ? $GLOBALS['HTTP_POST_VARS']['cat_parent'] : $GLOBALS['HTTP_GET_VARS']['cat_parent'];
			$cat_name        = $GLOBALS['HTTP_POST_VARS']['cat_name'];
			$cat_description = $GLOBALS['HTTP_POST_VARS']['cat_description'];
			$cat_data        = $GLOBALS['HTTP_POST_VARS']['cat_data'];
			$cat_access      = $GLOBALS['HTTP_POST_VARS']['cat_access'];

			$this->t->set_file(array('form' => 'category_form.tpl'));
			$this->t->set_block('form','data_row','row');
			$this->t->set_block('form','add','addhandle');
			$this->t->set_block('form','edit','edithandle');

			$this->set_langs();

			$this->bo->cats->app_name = $cats_app;

			if ($new_parent)
			{
				$cat_parent = $new_parent;
			}

			if (!$global_cats)
			{
				$global_cats = False;
			}

			if ($submit)
			{
				$data = serialize($cat_data);

				$values = array
				(
					'parent' => $cat_parent,
					'descr'  => $cat_description,
					'name'   => $cat_name,
					'access' => $cat_access,
					'data'   => $data
				);

				$error = $this->bo->check_values($values);
				if (is_array($error))
				{
					$this->t->set_var('message',$GLOBALS['phpgw']->common->error_list($error));
				}
				else
				{
					$this->bo->save_cat($values);
					$this->t->set_var('message',lang('Category x has been added !', $cat_name));
				}
			}

			$this->t->set_var('title_categories',lang('Add x category for',lang($cats_app)));
			$this->t->set_var('lang_app',lang($cats_app));
			$this->t->set_var('actionurl',$GLOBALS['phpgw']->link('/index.php',$link_data));

			if ($cats_level)
			{
				$type = 'all';
			}
			else
			{
				$type = 'mains';
			}

			$this->t->set_var('category_list',$this->bo->cats->formated_list('select',$type,$cat_parent,$global_cats));
			$this->t->set_var('cat_name',$cat_name);
			$this->t->set_var('cat_description',$cat_description);

			$this->t->set_var('access','<input type="checkbox" name="cat_access" value="True"'
				. ($cat_access == True ?' checked':'') . '>');

			if ($extra)
			{
				$edata = explode(',',$extra);
				for($i=0;$i<count($edata);$i++)
				{
					$this->t->set_var('td_data','<input name="cat_data[' . $edata[$i] . ']" size="50" value="' . $cat_data[$edata[$i]] . '">');
					$this->t->set_var('lang_data',lang($edata[$i]));
					$this->t->fp('row','data_row',True);
				}
			}

			$link_data['menuaction'] = 'preferences.uicategories.index';
			$this->t->set_var('doneurl',$GLOBALS['phpgw']->link('/index.php',$link_data));
			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','form');
			$this->t->pfp('addhandle','add');
		}

		function edit()
		{
			$cats_app		= $GLOBALS['HTTP_GET_VARS']['cats_app'] ? $GLOBALS['HTTP_GET_VARS']['cats_app'] : $GLOBALS['HTTP_POST_VARS']['cats_app'];
			$extra			= $GLOBALS['HTTP_GET_VARS']['extra'] ? $GLOBALS['HTTP_GET_VARS']['extra'] : $GLOBALS['HTTP_POST_VARS']['extra'];
			$global_cats	= $GLOBALS['HTTP_GET_VARS']['global_cats'] ? $GLOBALS['HTTP_GET_VARS']['global_cats'] : $GLOBALS['HTTP_POST_VARS']['global_cats'];
			$cats_level		= $GLOBALS['HTTP_GET_VARS']['cats_level'] ? $GLOBALS['HTTP_GET_VARS']['cats_level'] : $GLOBALS['HTTP_POST_VARS']['global_cats'];
			$cat_id			= $GLOBALS['HTTP_GET_VARS']['cat_id'] ? $GLOBALS['HTTP_GET_VARS']['cat_id'] : $GLOBALS['HTTP_POST_VARS']['cat_id'];

			$link_data = array
			(
				'menuaction'	=> 'preferences.uicategories.index',
				'cats_app'		=> $cats_app,
				'extra'			=> $extra,
				'global_cats'	=> $global_cats,
				'cats_level'	=> $cats_level,
				'cat_id'		=> $cat_id
			);

			if (!$cat_id)
			{
				Header('Location: ' . $GLOBALS['phpgw']->link('/index.php',$link_data));
			}

			$GLOBALS['phpgw']->common->phpgw_header();
			echo parse_navbar();

			$new_parent			= $GLOBALS['HTTP_POST_VARS']['new_parent'];
			$submit				= $GLOBALS['HTTP_POST_VARS']['submit'];
			$cat_parent			= $GLOBALS['HTTP_POST_VARS']['cat_parent'];
			$cat_name			= $GLOBALS['HTTP_POST_VARS']['cat_name'];
			$cat_description	= $GLOBALS['HTTP_POST_VARS']['cat_description'];
			$cat_data			= $GLOBALS['HTTP_POST_VARS']['cat_data'];
			$cat_access			= $GLOBALS['HTTP_POST_VARS']['cat_access'];
			$old_parent			= $GLOBALS['HTTP_POST_VARS']['old_parent'];

			$this->t->set_file(array('form' => 'category_form.tpl'));
			$this->t->set_block('form','data_row','row');
			$this->t->set_block('form','add','addhandle');
			$this->t->set_block('form','edit','edithandle');

			$this->set_langs();
			$this->t->set_var('doneurl',$GLOBALS['phpgw']->link('/index.php',$link_data));
			$this->bo->cats->app_name = $cats_app;

			if ($new_parent)
			{
				$cat_parent = $new_parent;
			}

			if (!$global_cats)
			{
				$global_cats = False;
			}

			if ($submit)
			{
				$data = serialize($cat_data);

				$values = array
				(
					'id'			=> $cat_id,
					'parent'		=> $cat_parent,
					'descr'			=> $cat_description,
					'name'			=> $cat_name,
					'access'		=> $cat_access,
					'data'			=> $data,
					'old_parent'	=> $old_parent
				);

				$error = $this->bo->check_values($values);
				if (is_array($error))
				{
					$this->t->set_var('message',$GLOBALS['phpgw']->common->error_list($error));
				}
				else
				{
					$cat_id = $this->bo->save_cat($values);
					$this->t->set_var('message',lang('Category x has been updated !',$cat_name));
				}
			}

			$cats = $this->bo->cats->return_single($cat_id);

			$this->t->set_var('title_categories',lang('Edit x category for',lang($cats_app)));
			$this->t->set_var('lang_app',lang($cats_app));
			$link_data['menuaction'] = 'preferences.uicategories.edit';
			$this->t->set_var('actionurl',$GLOBALS['phpgw']->link('/index.php',$link_data));

			$this->t->set_var('cat_name',$GLOBALS['phpgw']->strip_html($cats[0]['name']));
			$this->t->set_var('cat_description',$GLOBALS['phpgw']->strip_html($cats[0]['description']));

			$this->t->set_var('hidden_vars','<input type="hidden" name="old_parent" value="' . $cats[0]['parent'] . '">');

			if ($cats_level)
			{
				$type = 'all';
			}
			else
			{
				$type = 'mains';
			}

			$this->t->set_var('category_list',$this->bo->cats->formated_list('select',$type,$cats[0]['parent'],$global_cats));

			$this->t->set_var('access','<input type="checkbox" name="cat_access" value="True"'
				. ($cats[0]['access'] == private ?' checked':'') . '>');

			if ($extra)
			{
				$edata = explode(',',$extra);

				$data = unserialize($cats[0]['data']);
				for($i=0;$i<count($edata);$i++)
				{
					$this->t->set_var('td_data','<input name="cat_data[' . $edata[$i] . ']" size="50" value="' . $data[$edata[$i]] . '">');
					$this->t->set_var('lang_data',lang($edata[$i]));
					$this->t->fp('row','data_row',True);
				}
			}

			if ($cats[0]['owner'] == $this->account)
			{
				$link_data['menuaction'] = 'preferences.uicategories.delete';
				$this->t->set_var('delete','<form method="POST" action="' . $GLOBALS['phpgw']->link('/index.php',$link_data)
					. '"><input type="submit" value="' . lang('Delete') .'"></form>');
			}
			else
			{
				$this->t->set_var('delete','&nbsp;');
			}

			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','form');
			$this->t->pfp('edithandle','edit');
		}

		function delete()
		{
			$cats_app    = $GLOBALS['HTTP_GET_VARS']['cats_app'] ? $GLOBALS['HTTP_GET_VARS']['cats_app'] : $GLOBALS['HTTP_POST_VARS']['cats_app'];
			$extra       = $GLOBALS['HTTP_GET_VARS']['extra'] ? $GLOBALS['HTTP_GET_VARS']['extra'] : $GLOBALS['HTTP_POST_VARS']['extra'];
			$global_cats = $GLOBALS['HTTP_GET_VARS']['global_cats'] ? $GLOBALS['HTTP_GET_VARS']['global_cats'] : $GLOBALS['HTTP_POST_VARS']['global_cats'];
			$cats_level  = $GLOBALS['HTTP_GET_VARS']['cats_level'] ? $GLOBALS['HTTP_GET_VARS']['cats_level'] : $GLOBALS['HTTP_POST_VARS']['global_cats'];
			$cat_id      = $GLOBALS['HTTP_GET_VARS']['cat_id'] ? $GLOBALS['HTTP_GET_VARS']['cat_id'] : $GLOBALS['HTTP_POST_VARS']['cat_id'];

			$link_data = array
			(
				'menuaction'  => 'preferences.uicategories.index',
				'cats_app'    => $cats_app,
				'extra'       => $extra,
				'global_cats' => $global_cats,
				'cats_level'  => $cats_level,
				'cat_id'      => $cat_id
			);

			if (!$cat_id)
			{
				Header('Location: ' . $GLOBALS['phpgw']->link('/index.php',$link_data));
			}

			$this->bo->cats->app_name = $cats_app;

			if ($GLOBALS['HTTP_POST_VARS']['confirm'])
			{
				if ($GLOBALS['HTTP_POST_VARS']['subs'])
				{
					$this->bo->delete($cat_id,True);
				}
				else
				{
					$this->bo->delete($cat_id,False);
				}
				Header('Location: ' . $GLOBALS['phpgw']->link('/index.php',$link_data));
			}
			else
			{
				$this->t->set_file(array('category_delete' => 'delete.tpl'));

				$nolink = $GLOBALS['phpgw']->link('/index.php',$link_data);

				$GLOBALS['phpgw']->common->phpgw_header();
				echo parse_navbar();

				$this->t->set_var('deleteheader',lang('Are you sure you want to delete this category ?'));

				$exists = $this->bo->exists(array
				(
					'type'     => 'subs',
					'cat_name' => '',
					'cat_id'   => $cat_id
				));

				if ($exists)
				{
					$this->t->set_var('lang_subs',lang('Do you also want to delete all subcategories ?'));
					$this->t->set_var('subs','<input type="checkbox" name="subs" value="True">');
				}
				else
				{
					$this->t->set_var('lang_subs','');
					$this->t->set_var('subs', '');
				}

				$this->t->set_var('nolink',$nolink);
				$this->t->set_var('lang_no',lang('No'));
				$link_data['menuaction'] = 'preferences.uicategories.delete';
				$this->t->set_var('action_url',$GLOBALS['phpgw']->link('/index.php',$link_data));
				$this->t->set_var('lang_yes',lang('Yes'));
				$this->t->pfp('out','category_delete');
			}
		}
	}
?>
