<?php
  /**************************************************************************\
  * phpGroupWare - Brewer Recipe view                                        *
  * http://www.phpgroupware.org                                              *
  * Written by Miles Lott <milosch@phpgroupware.org>                         *
  * -----------------------------------------------                          *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: view_recipe.php,v 1.3 2001/09/11 12:38:28 milosch Exp $ */

	$GLOBALS['phpgw_info']['flags'] = array(
		'currentapp' => 'brewer',
		'noheader'   => True,
		'nonavbar'   => True
	);
	include('../header.inc.php');

	$id = $HTTP_GET_VARS['id'];
	$type = $HTTP_GET_VARS['type'] ? $HTTP_GET_VARS['type'] : $HTTP_POST_VARS['type'];
	$cancel = $HTTP_POST_VARS['cancel'];

	if (!$id && $type || $cancel)
	{
		$redir = $type .'s.php';
		if (file_exists(PHPGW_APP_ROOT . SEP . $type . 'es.php'))
		{
			$redir = $type .'es.php';
		}
		Header('Location: ' . $GLOBALS['phpgw']->link('/brewer/' . $redir));
	}
	elseif($edit)
	{
		Header('Location: ' . $GLOBALS['phpgw']->link('/brewer/edit.php',"type=$type&id=$id"));
	}

	$GLOBALS['phpgw']->template->set_file(array('disp' => 'view_recipe.tpl'));
	$GLOBALS['phpgw']->template->set_block('disp','header','header');
	$GLOBALS['phpgw']->template->set_block('disp','ingredient','ingredient');
	$GLOBALS['phpgw']->template->set_block('disp','detail','detail');
	$GLOBALS['phpgw']->template->set_block('disp','buttons','buttons');
	$GLOBALS['phpgw']->template->set_block('disp','results','results');
	$GLOBALS['phpgw']->template->set_block('disp','brew_style','brew_style');
	$GLOBALS['phpgw']->template->set_block('disp','footer','footer');

	$hidden_vars =
		  '<input type="hidden" name="sort"   value="' . $sort   . '">' . "\n"
		. '<input type="hidden" name="order"  value="' . $order  . '">' . "\n"
		. '<input type="hidden" name="type"   value="' . $type   . '">' . "\n"
		. '<input type="hidden" name="query"  value="' . $query  . '">' . "\n"
		. '<input type="hidden" name="start"  value="' . $start  . '">' . "\n"
		. '<input type="hidden" name="filter" value="' . $filter . '">' . "\n"
		. '<input type="hidden" name="id"     value="' . $id     . '">' . "\n";

	$b = CreateObject('brewer.brew');
	$b->recipe->set_units();
	$tmp = $b->$type->get($id);
	$r->recipe = $tmp[$id];

	$GLOBALS['phpgw']->common->phpgw_header();
	echo parse_navbar();

	$GLOBALS['phpgw']->template->set_var('title',lang('View') . ' ' . lang(ucfirst($type)));
	$GLOBALS['phpgw']->template->set_var('lang_edit',lang('Edit'));
	$GLOBALS['phpgw']->template->set_var('lang_cancel',lang('Cancel'));
	$GLOBALS['phpgw']->template->set_var('hidden_vars',$hidden_vars);
	/* Themes and colors */
	$GLOBALS['phpgw']->template->set_var('th_bg',$GLOBALS['phpgw_info']['theme']['th_bg']);
	$GLOBALS['phpgw']->template->set_var('th_text',$GLOBALS['phpgw_info']['theme']['th_text']);
	$GLOBALS['phpgw']->template->set_var('row_on',$GLOBALS['phpgw_info']['theme']['row_on']);
	$GLOBALS['phpgw']->template->set_var('row_off',$GLOBALS['phpgw_info']['theme']['row_off']);

	/* Basic brew info and form url */
	$GLOBALS['phpgw']->template->set_var('title',lang('Brewer') . ' - ' . lang('Recipe Viewer'));
	$GLOBALS['phpgw']->template->set_var('action_url',$GLOBALS['phpgw']->link('/brewer/beer.php','action=get'));
	$GLOBALS['phpgw']->template->set_var('lang_name',lang('Recipe Name'));
	$GLOBALS['phpgw']->template->set_var('name',$r->recipe['name']);
	$GLOBALS['phpgw']->template->set_var('id',$id);

	/* Themes and colors */
	$GLOBALS['phpgw']->template->set_var('th_bg',$GLOBALS['phpgw_info']['theme']['th_bg']);
	$GLOBALS['phpgw']->template->set_var('th_text',$GLOBALS['phpgw_info']['theme']['th_text']);
	$GLOBALS['phpgw']->template->set_var('row_on',$GLOBALS['phpgw_info']['theme']['row_on']);
	$GLOBALS['phpgw']->template->set_var('row_off',$GLOBALS['phpgw_info']['theme']['row_off']);

	/* Ingredients */
	$GLOBALS['phpgw']->template->set_var('lang_ingredients',lang('Ingredients'));
	$ing = array('malt','yeast','hop');
	while(list($x,$type) = each($ing))
	{
		$types = $type . 's';
		while(list($key,$val) = @each($r->recipe[$types]))
		{
			$type_units = $type . '_weight_units';
			$tmp = $b->$type->get($val);
			$tmp = $tmp[$val];
			$weight = $type . '_weight_units';
			$tu = $type . '_units';
			$wvar = $b->recipe->$weight;
			$wvar = $wvar[0]['name'];
			$GLOBALS['phpgw']->template->set_var('ingred',($key+1) . ': ' . ucfirst($type) . ' - ' . $tmp['name']);
			$GLOBALS['phpgw']->template->set_var('amount',$r->recipe[$type.'_amounts'][$key]);
			$GLOBALS['phpgw']->template->set_var('units',$wvar);
			$GLOBALS['phpgw']->template->set_var('lang_remove',lang('Remove'));
			$GLOBALS['phpgw']->template->set_var('lang_amount',lang('Amount'));
			$GLOBALS['phpgw']->template->set_var('lang_units',lang('Units'));
			$GLOBALS['phpgw']->template->fp('ingredients','ingredient',True);
		}
	}

	/* Brew settings/methods (detail) */
	$GLOBALS['phpgw']->template->set_var('lang_detail',lang('Brew Settings'));
	$GLOBALS['phpgw']->template->set_var('lang_setting',lang('Setting'));
	$GLOBALS['phpgw']->template->set_var('lang_value',lang('Value'));
	$GLOBALS['phpgw']->template->set_var('lang_units',lang('Units'));

	$GLOBALS['phpgw']->template->set_var('lang_boil_vol',lang('Boil Volume'));
	$GLOBALS['phpgw']->template->set_var('boil_vol',$r->recipe['boil_vol']);
	$GLOBALS['phpgw']->template->set_var('boil_units',$b->recipe->volume_units[$r->recipe['boil_units']]['name']);
	$GLOBALS['phpgw']->template->set_var('lang_boil_time',lang('Boil Time'));
	$GLOBALS['phpgw']->template->set_var('lang_time_units',lang('minutes'));
	$GLOBALS['phpgw']->template->set_var('boil_time',$r->recipe['boil_time']);
	$GLOBALS['phpgw']->template->set_var('lang_total_vol',lang('Total Volume'));
	$GLOBALS['phpgw']->template->set_var('total_vol',$r->recipe['total_vol']);
	$GLOBALS['phpgw']->template->set_var('vol_units',$b->recipe->volume_units[$r->recipe['vol_units']]['name']);

	$GLOBALS['phpgw']->template->set_var('lang_IBU_Method',lang('IBU Method'));
	$GLOBALS['phpgw']->template->set_var('IBU_Method',$r->recipe['IBU_method']);

	/* Style information for comparison */
	$tmp = $b->style->get($r->recipe['style']);
	$style = $tmp[$r->recipe['style']];
	$GLOBALS['phpgw']->template->set_var('style',$style['name']);
	$GLOBALS['phpgw']->template->set_var('lang_style',lang('Style'));
	$GLOBALS['phpgw']->template->set_var('lang_description',lang('Description'));
	$GLOBALS['phpgw']->template->set_var('description',$style['description']);
    $GLOBALS['phpgw']->template->set_var('lang_mingravity',lang('Minimum Gravity'));
    $GLOBALS['phpgw']->template->set_var('lang_maxgravity',lang('Maximum Gravity'));
    $GLOBALS['phpgw']->template->set_var('lang_minalcohol',lang('Minimum Alcohol %'));
    $GLOBALS['phpgw']->template->set_var('lang_maxalcohol',lang('Maximum Alcohol %'));
    $GLOBALS['phpgw']->template->set_var('lang_mincolor',lang('Minimum Color'));
    $GLOBALS['phpgw']->template->set_var('lang_maxcolor',lang('Maximum Color'));
    $GLOBALS['phpgw']->template->set_var('lang_minbitter',lang('Minimum IBU'));
    $GLOBALS['phpgw']->template->set_var('lang_maxbitter',lang('Maximum IBU'));
    $GLOBALS['phpgw']->template->set_var('mingravity',$style['mingravity']);
    $GLOBALS['phpgw']->template->set_var('maxgravity',$style['maxgravity']);
    $GLOBALS['phpgw']->template->set_var('minalcohol',$style['minalcohol']);
    $GLOBALS['phpgw']->template->set_var('maxalcohol',$style['maxalcohol']);
    $GLOBALS['phpgw']->template->set_var('mincolor', $style['mincolor']);
    $GLOBALS['phpgw']->template->set_var('maxcolor', $style['maxcolor']);
    $GLOBALS['phpgw']->template->set_var('minbitter', $style['minbitter']);
    $GLOBALS['phpgw']->template->set_var('maxbitter', $style['maxbitter']);

	/* Print it */
	$GLOBALS['phpgw']->template->fp('out','header',True);
	$GLOBALS['phpgw']->template->fp('out','detail',True);
	$GLOBALS['phpgw']->template->fp('out','brew_style',True);
	$GLOBALS['phpgw']->template->fp('out','buttons',True);
	$GLOBALS['phpgw']->template->fp('out','footer',True);
	$GLOBALS['phpgw']->template->p('out');

	$GLOBALS['phpgw']->common->phpgw_footer();
?>
